/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.LogoPanel;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.ScrollingTextPane;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.Timer;

final class AboutWindow {
    private final JDialog DIALOG;
    private final ScrollingTextPane SCROLLING_PANE;
    private final JCheckBox SCROLL_CHECK_BOX = new JCheckBox(GUIMediator.getStringResource("ABOUT_SCROLL_CHECK_BOX_LABEL"));

    AboutWindow() {
        this.DIALOG = new JDialog(GUIMediator.getAppFrame());
        if (!CommonUtils.isMacOSX() || !CommonUtils.isJava14OrLater()) {
            this.DIALOG.setModal(true);
        }
        this.DIALOG.setSize(new Dimension(450, 400));
        this.DIALOG.setResizable(false);
        this.DIALOG.setTitle(GUIMediator.getStringResource("ABOUT_TITLE"));
        this.DIALOG.setDefaultCloseOperation(2);
        this.DIALOG.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent we) {
                AboutWindow.this.SCROLLING_PANE.stopScroll();
            }

            public void windowClosing(WindowEvent we) {
                AboutWindow.this.SCROLLING_PANE.stopScroll();
            }
        });
        String aboutName = "about_" + ResourceManager.getLocale().toString() + ".html";
        URL aboutUrl = GUIMediator.getURLResource(aboutName);
        if (aboutUrl == null) {
            aboutUrl = GUIMediator.getURLResource("about.html");
        }
        this.SCROLLING_PANE = new ScrollingTextPane(aboutUrl);
        this.SCROLLING_PANE.addHyperlinkListener(GUIUtils.getHyperlinkListener());
        this.SCROLL_CHECK_BOX.setSelected(true);
        this.SCROLL_CHECK_BOX.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AboutWindow.this.SCROLL_CHECK_BOX.isSelected()) {
                    AboutWindow.this.SCROLLING_PANE.startScroll();
                } else {
                    AboutWindow.this.SCROLLING_PANE.stopScroll();
                }
            }
        });
        JComponent pane = (JComponent)this.DIALOG.getContentPane();
        GUIUtils.addHideAction(pane);
        pane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 10;
        c.fill = 0;
        c.insets = new Insets(5, 0, 17, 0);
        LogoPanel logo = new LogoPanel();
        logo.setSearching(true);
        pane.add((Component)logo, c);
        JLabel client = new JLabel(GUIMediator.getStringResource("ABOUT_LABEL_START") + " " + CommonUtils.getLimeWireVersion());
        client.setHorizontalAlignment(0);
        JLabel java = new JLabel("Java " + CommonUtils.getJavaVersion());
        java.setHorizontalAlignment(0);
        URLLabel url = new URLLabel("http://www.limewire.com");
        url.setHorizontalAlignment(0);
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        pane.add((Component)client, c);
        pane.add((Component)java, c);
        pane.add((Component)url, c);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.insets = new Insets(3, 3, 3, 3);
        pane.add((Component)this.SCROLLING_PANE, c);
        c.gridwidth = -1;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        pane.add((Component)this.SCROLL_CHECK_BOX, c);
        JButton button = new JButton(GUIMediator.getStringResource("GENERAL_CLOSE_BUTTON_LABEL"));
        this.DIALOG.getRootPane().setDefaultButton(button);
        button.setToolTipText(GUIMediator.getStringResource("ABOUT_BUTTON_TIP"));
        button.addActionListener(GUIUtils.getDisposeAction());
        c.gridwidth = 0;
        c.anchor = 13;
        pane.add((Component)button, c);
    }

    void showDialog() {
        if (GUIMediator.isAppVisible()) {
            this.DIALOG.setLocationRelativeTo(GUIMediator.getAppFrame());
        } else {
            this.DIALOG.setLocation(GUIMediator.getScreenCenterPoint(this.DIALOG));
        }
        if (this.SCROLL_CHECK_BOX.isSelected()) {
            ActionListener startTimerListener = new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    if (AboutWindow.this.SCROLL_CHECK_BOX.isSelected()) {
                        AboutWindow.this.SCROLLING_PANE.startScroll();
                    }
                }
            };
            Timer startTimer = new Timer(10000, startTimerListener);
            startTimer.setRepeats(false);
            startTimer.start();
        }
        this.DIALOG.setVisible(true);
    }
}

