/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.Line;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.VerificationListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.httpclient.URI;

public class LicenseWindow
extends JDialog
implements VerificationListener {
    private final URN URN;
    private final License LICENSE;
    private final JPanel DETAILS;
    private final VerificationListener LISTENER;

    public LicenseWindow(License license, URN urn, VerificationListener listener) {
        super(GUIMediator.getAppFrame());
        this.URN = urn;
        this.LICENSE = license;
        this.DETAILS = new JPanel(new GridBagLayout());
        this.LISTENER = listener;
        this.setModal(false);
        this.setResizable(false);
        this.setTitle(GUIMediator.getStringResource("LICENSE_CC_TITLE"));
        this.setDefaultCloseOperation(2);
        JComponent pane = (JComponent)this.getContentPane();
        GUIUtils.addHideAction(pane);
        pane.setPreferredSize(new Dimension(400, 180));
        this.DETAILS.setPreferredSize(new Dimension(400, 150));
        this.getContentPane().setLayout(new GridBagLayout());
        this.constructDialog(this.getContentPane());
        this.validate();
        if (GUIMediator.isAppVisible()) {
            this.setLocationRelativeTo(GUIMediator.getAppFrame());
        } else {
            this.setLocation(GUIMediator.getScreenCenterPoint(this));
        }
    }

    public void licenseVerified(License license) {
        if (license == this.LICENSE) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LicenseWindow.this.buildDetails();
                }
            });
        }
        if (this.LISTENER != null) {
            this.LISTENER.licenseVerified(license);
        }
    }

    private void buildDetails() {
        this.DETAILS.removeAll();
        GridBagLayout bag = (GridBagLayout)this.DETAILS.getLayout();
        GridBagConstraints c = new GridBagConstraints();
        if (this.LICENSE.isVerifying()) {
            JTextArea text = this.newTextArea(GUIMediator.getStringResource("LICENSE_CC_LOCATING"));
            c.anchor = 10;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.DETAILS.add((Component)text, c);
        } else if (!this.LICENSE.isVerified()) {
            JTextArea text = this.newTextArea(GUIMediator.getStringResource("LICENSE_CC_UNVERIFIED"));
            c.gridwidth = 0;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.anchor = 18;
            this.DETAILS.add((Component)text, c);
            JButton button = new JButton(GUIMediator.getStringResource("LICENSE_CC_VERIFY"));
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    LicenseWindow.this.LICENSE.verify(LicenseWindow.this);
                    LicenseWindow.this.buildDetails();
                }
            });
            c.gridwidth = 0;
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.anchor = 16;
            this.DETAILS.add((Component)button, c);
        } else if (!this.LICENSE.isValid(this.URN)) {
            URI licenseURI = this.LICENSE.getLicenseURI();
            JComponent comp = new JLabel(GUIMediator.getThemeImage("warning"));
            c.anchor = 11;
            c.insets = new Insets(0, 0, 0, 5);
            this.DETAILS.add((Component)comp, c);
            String invalidText = GUIMediator.getStringResource("LICENSE_CC_INVALID");
            if (licenseURI != null) {
                invalidText = invalidText + "  " + GUIMediator.getStringResource("LICENSE_CC_RETRY");
            }
            comp = this.newTextArea(invalidText);
            c.gridwidth = 0;
            c.anchor = 18;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(0, 0, 0, 0);
            this.DETAILS.add((Component)comp, c);
            c.gridwidth = 1;
            c.gridheight = 2;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.DETAILS.add(Box.createGlue(), c);
            JButton button = new JButton(GUIMediator.getStringResource("LICENSE_CC_VERIFY"));
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    LicenseWindow.this.LICENSE.verify(LicenseWindow.this);
                    LicenseWindow.this.buildDetails();
                }
            });
            button.setVisible(licenseURI != null);
            c.gridwidth = -1;
            c.gridheight = 2;
            c.fill = 0;
            c.anchor = 10;
            c.insets = new Insets(0, 0, 0, 100);
            this.DETAILS.add((Component)button, c);
            if (this.LICENSE.getLicenseDeed(this.URN) == null) {
                comp = new JLabel();
                comp.setVisible(false);
            } else {
                comp = new URLLabel(this.LICENSE.getLicenseDeed(this.URN), GUIMediator.getStringResource("LICENSE_CC_CLAIMED_DEED"));
            }
            c.gridwidth = 0;
            c.gridheight = 1;
            c.anchor = 17;
            c.fill = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 0, 3, 0);
            this.DETAILS.add((Component)comp, c);
            if (licenseURI == null) {
                comp = new JLabel();
                comp.setVisible(false);
            } else {
                comp = new URLLabel(licenseURI, GUIMediator.getStringResource("LICENSE_CC_VERIFICATION"));
            }
            c.insets = new Insets(0, 0, 3, 0);
            this.DETAILS.add((Component)comp, c);
        } else {
            JLabel label = new JLabel(GUIMediator.getStringResource("LICENSE_CC_DETAILS"));
            Font f = label.getFont();
            label.setFont(new Font(f.getName(), 1, f.getSize()));
            c.fill = 2;
            c.gridwidth = 0;
            c.anchor = 18;
            this.DETAILS.add((Component)label, c);
            JTextArea text = this.newTextArea(this.LICENSE.getLicenseDescription(this.URN));
            c.gridwidth = -1;
            c.gridheight = 2;
            c.weighty = 1.0;
            c.weightx = 0.7;
            c.anchor = 18;
            c.fill = 1;
            this.DETAILS.add((Component)text, c);
            if (this.LICENSE.getLicenseDeed(this.URN) != null) {
                label = new URLLabel(this.LICENSE.getLicenseDeed(this.URN), GUIMediator.getStringResource("LICENSE_CC_DEED"));
            } else {
                label = new JLabel();
                label.setVisible(false);
            }
            c.gridwidth = 0;
            c.gridheight = 1;
            c.weighty = 0.0;
            c.weightx = 0.3;
            c.anchor = 18;
            c.fill = 1;
            c.insets = new Insets(0, 0, 3, 0);
            this.DETAILS.add((Component)label, c);
            label = new URLLabel(this.LICENSE.getLicenseURI(), GUIMediator.getStringResource("LICENSE_CC_VERIFICATION"));
            this.DETAILS.add((Component)label, c);
        }
        this.validate();
        this.repaint();
    }

    private void constructDialog(Container parent) {
        GridBagLayout bag = (GridBagLayout)parent.getLayout();
        GridBagConstraints c = new GridBagConstraints();
        URLLabel img = new URLLabel("http://www.creativecommons.org", GUIMediator.getThemeImage("cc_window"));
        c.insets = new Insets(4, 4, 2, 0);
        parent.add((Component)img, c);
        Line line = new Line(ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue());
        c.insets = new Insets(0, 2, 0, 2);
        c.gridwidth = -1;
        c.fill = 3;
        parent.add((Component)line, c);
        JTextArea text = this.newTextArea(this.LICENSE.getLicense());
        c.gridwidth = 0;
        c.fill = 1;
        c.insets = new Insets(4, 0, 2, 4);
        parent.add((Component)text, c);
        line = new Line(ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue());
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 2, 0);
        parent.add((Component)line, c);
        this.buildDetails();
        c.gridwidth = 0;
        c.fill = 1;
        c.insets = new Insets(4, 4, 0, 4);
        c.weighty = 1.0;
        c.weightx = 1.0;
        parent.add((Component)this.DETAILS, c);
        line = new Line(ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue());
        c.gridwidth = 0;
        c.gridheight = -1;
        c.fill = 2;
        c.insets = new Insets(2, 0, 2, 0);
        c.ipady = 0;
        c.weighty = 0.0;
        c.weightx = 0.0;
        parent.add((Component)line, c);
        JButton button = new JButton(GUIMediator.getStringResource("GENERAL_OK_BUTTON_LABEL"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                LicenseWindow.this.dispose();
                LicenseWindow.this.setVisible(false);
            }
        });
        c.gridheight = 0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 4, 4);
        c.fill = 0;
        c.anchor = 13;
        parent.add((Component)button, c);
        this.pack();
    }

    private JTextArea newTextArea(String msg) {
        JTextArea text = new JTextArea();
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setEditable(false);
        text.setFont(UIManager.getFont("Table.font"));
        JLabel label = new JLabel();
        text.setForeground(label.getForeground());
        text.setBackground(label.getBackground());
        text.setText(msg);
        return text;
    }
}

