/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class SaveDirectoryHandler {
    private SaveDirectoryHandler() {
    }

    private static void showSaveDirectoryWindow() {
        File dir = null;
        while (!SaveDirectoryHandler.isSaveDirectoryValid(dir)) {
            GUIMediator.showError("ERROR_INVALID_SAVE_DIRECTORY_WINDOW");
            dir = SaveDirectoryHandler.showChooser();
            if (dir == null) continue;
            FileUtils.setWriteable(dir);
        }
    }

    private static File showChooser() {
        File dir = FileChooserHandler.getInputDirectory(null);
        if (dir == null) {
            return null;
        }
        try {
            SharingSettings.setSaveDirectory(dir);
            SharingSettings.addDirectory(dir);
            return dir;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isSaveDirectoryValid(File saveDir) {
        block18: {
            if (saveDir == null) {
                return false;
            }
            if (!saveDir.exists()) {
                return false;
            }
            if (!saveDir.isDirectory()) {
                return false;
            }
            FileUtils.setWriteable(saveDir);
            RandomAccessFile testRAFile = null;
            File testFile = new File(saveDir, "test");
            testRAFile = new RandomAccessFile(testFile, "rw");
            testRAFile.write(7);
            testRAFile.close();
            Object var6_3 = null;
            testFile.delete();
            try {
                if (testRAFile != null) {
                    testRAFile.close();
                }
                break block18;
            }
            catch (IOException e1) {}
            break block18;
            {
                catch (FileNotFoundException e) {
                    boolean bl = false;
                    Object var6_4 = null;
                    testFile.delete();
                    try {
                        if (testRAFile != null) {
                            testRAFile.close();
                        }
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                    return bl;
                }
                catch (IOException e) {
                    boolean bl;
                    try {
                        bl = false;
                        Object var6_5 = null;
                        testFile.delete();
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        testFile.delete();
                        try {
                            if (testRAFile != null) {
                                testRAFile.close();
                            }
                        }
                        catch (IOException e1) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        if (testRAFile != null) {
                            testRAFile.close();
                        }
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                    return bl;
                }
            }
        }
        return saveDir.canWrite();
    }

    public static void handleSaveDirectory() {
        File saveDir = SharingSettings.getSaveDirectory();
        if (!SaveDirectoryHandler.isSaveDirectoryValid(saveDir)) {
            SaveDirectoryHandler.showSaveDirectoryWindow();
        }
    }
}

