/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.settings.StartupSettings;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public final class TipOfTheDayMediator
implements ThemeObserver {
    private static TipOfTheDayMediator instance;
    private static final String TOTD_TITLE;
    private static final String TOTD_INTRO;
    private static final String TOTD_STARTUP;
    private static final String TOTD_NEXT;
    private static final String TOTD_PREVIOUS;
    private static final String TOTD_CLOSE;
    private final JDialog TOTD = new JDialog();
    private final JEditorPane TIP = new JEditorPane();
    private final JButton PREVIOUS;
    private static final String GENERAL = "GENERAL_";
    private static final String OSX = "OSX_";
    private static final String WINDOWS = "WINDOWS_";
    private static final String LINUX = "LINUX_";
    private static final String OTHER = "OTHER_";
    private static final String NOT_OSX = "NOT_OSX_";
    private static final String PRO = "PRO_";
    private static final String FREE = "FREE_";
    private static final List KEYS;
    private static int _currentTip;
    private static Color foreground;
    private boolean _canDisplay = true;

    private TipOfTheDayMediator() {
        this.retrieveKeys();
        this.TOTD.setModal(false);
        this.TOTD.setResizable(false);
        this.TOTD.setTitle(TOTD_TITLE);
        GUIUtils.addHideAction((JComponent)this.TOTD.getContentPane());
        this.PREVIOUS = new JButton(TOTD_PREVIOUS);
        this.PREVIOUS.addActionListener(new PreviousTipListener());
        this.constructDialog();
        this.TIP.setText("...loading tips");
        ThemeMediator.addThemeObserver(this);
    }

    public static TipOfTheDayMediator instance() {
        if (instance == null) {
            instance = new TipOfTheDayMediator();
        }
        return instance;
    }

    public JDialog getDialog() {
        return this.TOTD;
    }

    public void displayTipWindow() {
        if (!this._canDisplay) {
            return;
        }
        if (this.TOTD.isShowing()) {
            this.TOTD.hide();
            this.TOTD.show();
            this.TOTD.toFront();
            return;
        }
        if (GUIMediator.isAppVisible()) {
            this.TOTD.setLocationRelativeTo(GUIMediator.getAppFrame());
        } else {
            this.TOTD.setLocation(GUIMediator.getScreenCenterPoint(this.TOTD));
        }
        this.TOTD.show();
        if (!"text/html".equals(this.TIP.getContentType())) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TipOfTheDayMediator.this.TIP.setContentType("text/html");
                    TipOfTheDayMediator.this.setText(TipOfTheDayMediator.this.getRandomTip());
                }
            });
        }
        this.TOTD.toFront();
    }

    public void hide() {
        this.TOTD.hide();
    }

    private void setText(String tip) {
        int r = foreground.getRed();
        int g = foreground.getGreen();
        int b = foreground.getBlue();
        String foreHex = this.toHex(r) + this.toHex(g) + this.toHex(b);
        this.TIP.setText("<html><body text='#" + foreHex + "'>" + tip + "</html>");
        this.TIP.setCaretPosition(0);
    }

    private String toHex(int i) {
        String hex = Integer.toHexString(i).toUpperCase();
        if (hex.length() == 1) {
            return "0" + hex;
        }
        return hex;
    }

    private void retrieveKeys() {
        ResourceBundle bundle = ResourceManager.getTOTDResourceBundle();
        Enumeration<String> e = bundle.getKeys();
        while (e.hasMoreElements()) {
            String k = e.nextElement();
            if (k.startsWith(GENERAL)) {
                KEYS.add(k);
                continue;
            }
            if (CommonUtils.isWindows() && k.startsWith(WINDOWS)) {
                KEYS.add(k);
                continue;
            }
            if (CommonUtils.isMacOSX() && k.startsWith(OSX)) {
                KEYS.add(k);
                continue;
            }
            if (CommonUtils.isLinux() && k.startsWith(LINUX)) {
                KEYS.add(k);
                continue;
            }
            if (!CommonUtils.isWindows() && !CommonUtils.isMacOSX() && !CommonUtils.isLinux() && k.startsWith(OTHER)) {
                KEYS.add(k);
                continue;
            }
            if (!CommonUtils.isMacOSX() && k.startsWith(NOT_OSX)) {
                KEYS.add(k);
                continue;
            }
            if (CommonUtils.isPro() && k.startsWith(PRO)) {
                KEYS.add(k);
                continue;
            }
            if (CommonUtils.isPro() || !k.startsWith(FREE)) continue;
            KEYS.add(k);
        }
        Collections.shuffle(KEYS);
        _currentTip = -1;
    }

    private String getRandomTip() {
        if (_currentTip == KEYS.size() - 1) {
            Collections.shuffle(KEYS);
            _currentTip = -1;
        } else if (_currentTip < -1) {
            _currentTip = -1;
        }
        String k = (String)KEYS.get(++_currentTip);
        if (_currentTip == 0) {
            this.PREVIOUS.setEnabled(false);
        } else {
            this.PREVIOUS.setEnabled(true);
        }
        ResourceBundle bundle = ResourceManager.getTOTDResourceBundle();
        return bundle.getString(k);
    }

    public void updateTheme() {
        boolean wasShowing = this.TOTD.isShowing();
        this.TOTD.hide();
        this.TOTD.getContentPane().removeAll();
        Font tipFont = new Font(this.TIP.getFont().getName(), this.TIP.getFont().getStyle(), this.TIP.getFont().getSize() - 2);
        this.TIP.setFont(tipFont);
        this.constructDialog();
        this.TIP.setContentType("text/html");
        this.setText(this.getRandomTip());
        if (wasShowing) {
            this.TOTD.show();
            this.TOTD.toFront();
        }
    }

    private void constructDialog() {
        JPanel imagePanel = new JPanel();
        imagePanel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue()));
        JLabel img = new JLabel(GUIMediator.getThemeImage("question"));
        imagePanel.add(img);
        JPanel didYouKnowPanel = new JPanel(new FlowLayout(0));
        JLabel didYouKnow = new JLabel(TOTD_INTRO);
        Font didYouKnowFont = new Font("Dialog", didYouKnow.getFont().getStyle(), didYouKnow.getFont().getSize() + 5);
        didYouKnow.setFont(didYouKnowFont);
        didYouKnowPanel.add(Box.createHorizontalStrut(3));
        didYouKnowPanel.add(didYouKnow);
        JPanel tipPanel = new JPanel();
        foreground = didYouKnow.getForeground();
        tipPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue()));
        this.TIP.setContentType("text");
        this.TIP.setEditable(false);
        this.TIP.setBackground(tipPanel.getBackground());
        Font tipFont = new Font("Dialog", this.TIP.getFont().getStyle(), this.TIP.getFont().getSize() + 2);
        this.TIP.setFont(tipFont);
        this.TIP.addHyperlinkListener(GUIUtils.getHyperlinkListener());
        JScrollPane tipScroller = new JScrollPane(this.TIP);
        tipScroller.setPreferredSize(new Dimension(400, 100));
        tipScroller.setHorizontalScrollBarPolicy(31);
        tipScroller.setVerticalScrollBarPolicy(20);
        tipScroller.setBorder(null);
        tipPanel.add(tipScroller);
        BoxPanel rightTip = new BoxPanel();
        rightTip.add(Box.createVerticalStrut(10));
        rightTip.add(didYouKnowPanel);
        rightTip.add(tipPanel);
        JPanel wholeTip = new JPanel(new BorderLayout());
        BoxPanel innerTip = new BoxPanel(0);
        innerTip.add(imagePanel);
        innerTip.add(rightTip);
        innerTip.setBorder(BorderFactory.createLoweredBevelBorder());
        wholeTip.add(Box.createHorizontalStrut(5), "West");
        wholeTip.add(Box.createHorizontalStrut(5), "East");
        wholeTip.add(Box.createVerticalStrut(5), "North");
        wholeTip.add(Box.createVerticalStrut(5), "South");
        wholeTip.add((Component)innerTip, "Center");
        JPanel startupPanel = new JPanel(new FlowLayout(0));
        JCheckBox showTips = new JCheckBox(TOTD_STARTUP);
        showTips.setSelected(StartupSettings.SHOW_TOTD.getValue());
        startupPanel.add(showTips);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.PREVIOUS);
        JButton next = new JButton(TOTD_NEXT);
        buttonPanel.add(next);
        JButton close = new JButton(TOTD_CLOSE);
        buttonPanel.add(close);
        JPanel navigation = new JPanel(new BorderLayout());
        navigation.add((Component)startupPanel, "West");
        navigation.add((Component)buttonPanel, "East");
        showTips.addActionListener(new ShowTipListener());
        next.addActionListener(new NextTipListener());
        close.addActionListener(GUIUtils.getDisposeAction());
        this.TOTD.setDefaultCloseOperation(2);
        Container pane = this.TOTD.getContentPane();
        pane.setLayout(new BoxLayout(pane, 1));
        pane.add(wholeTip);
        pane.add(Box.createVerticalStrut(5));
        pane.add(navigation);
        try {
            this.TOTD.pack();
        }
        catch (OutOfMemoryError oome) {
            this._canDisplay = false;
        }
    }

    static {
        TOTD_TITLE = GUIMediator.getStringResource("TOTD_TITLE");
        TOTD_INTRO = GUIMediator.getStringResource("TOTD_INTRODUCTION");
        TOTD_STARTUP = GUIMediator.getStringResource("TOTD_SHOW_AT_STARTUP");
        TOTD_NEXT = GUIMediator.getStringResource("TOTD_NEXT");
        TOTD_PREVIOUS = GUIMediator.getStringResource("TOTD_PREVIOUS");
        TOTD_CLOSE = GUIMediator.getStringResource("TOTD_CLOSE");
        KEYS = new ArrayList();
    }

    private class PreviousTipListener
    implements ActionListener {
        private PreviousTipListener() {
        }

        public void actionPerformed(ActionEvent e) {
            _currentTip = _currentTip - 2;
            TipOfTheDayMediator.this.setText(TipOfTheDayMediator.this.getRandomTip());
        }
    }

    private class NextTipListener
    implements ActionListener {
        private NextTipListener() {
        }

        public void actionPerformed(ActionEvent e) {
            TipOfTheDayMediator.this.setText(TipOfTheDayMediator.this.getRandomTip());
        }
    }

    private class ShowTipListener
    implements ActionListener {
        private ShowTipListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JCheckBox source = (JCheckBox)e.getSource();
            StartupSettings.SHOW_TOTD.setValue(source.isSelected());
        }
    }
}

