/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.gui.DaapManager;
import com.limegroup.gnutella.gui.Finalizer;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MainFrame;
import com.limegroup.gnutella.gui.PasswordDialog;
import com.limegroup.gnutella.gui.UpdateDialog;
import com.limegroup.gnutella.gui.chat.ChatUIManager;
import com.limegroup.gnutella.gui.iTunesMediator;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.security.User;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.File;
import java.util.Set;
import java.util.Vector;
import javax.swing.SwingUtilities;

public final class VisualConnectionCallback
implements ActivityCallback {
    private final String ENGLISH_MESSGE = "LimeWire has detected a new version on the network. Please update to version ";
    private final HandleQueryString HANDLE_QUERY_STRING = new HandleQueryString();

    VisualConnectionCallback() {
    }

    public void addressStateChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (GUIMediator.isConstructed()) {
                    SearchMediator.addressChanged();
                }
            }
        });
    }

    public void connectionInitializing(Connection c) {
        ConnectionInitializing doWorkRunnable = new ConnectionInitializing(c);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void connectionInitialized(Connection c) {
        ConnectionInitialized doWorkRunnable = new ConnectionInitialized(c);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void connectionClosed(Connection c) {
        ConnectionClosed doWorkRunnable = new ConnectionClosed(c);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void handleQueryResult(final RemoteFileDesc rfd, final HostData data, final Set locs) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchMediator.handleQueryResult(rfd, data, locs);
            }
        });
    }

    public void handleQueryString(String query) {
        this.HANDLE_QUERY_STRING.addQueryString(query);
    }

    public void fileManagerLoaded() {
    }

    public void addSharedDirectory(final File dir, final File parent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VisualConnectionCallback.this.mf().getLibraryMediator().addSharedDirectory(dir, parent);
            }
        });
    }

    public void addSharedFile(final FileDesc file, final File parent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VisualConnectionCallback.this.mf().getLibraryMediator().addSharedFile(file, parent);
            }
        });
    }

    public void handleSharedFileUpdate(File file) {
        this.mf().getLibraryMediator().updateSharedFile(file);
    }

    public void handleFileManagerEvent(final FileManagerEvent evt) {
        if (CommonUtils.isJava14OrLater()) {
            Runnable r = new Runnable(){

                public void run() {
                    DaapManager.instance().handleFileManagerEvent(evt);
                }
            };
            GUIMediator.instance().schedule(r);
        }
    }

    public void clearSharedFiles() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VisualConnectionCallback.this.mf().getLibraryMediator().clearLibrary();
            }
        });
    }

    public void setAnnotateEnabled(final boolean enabled) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VisualConnectionCallback.this.mf().getLibraryMediator().setAnnotateEnabled(enabled);
            }
        });
        if (CommonUtils.isJava14OrLater()) {
            Runnable r = new Runnable(){

                public void run() {
                    DaapManager.instance().setAnnotateEnabled(enabled);
                }
            };
            GUIMediator.instance().schedule(r);
        }
    }

    public void addDownload(Downloader mgr) {
        AddDownload doWorkRunnable = new AddDownload(mgr);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void removeDownload(Downloader mgr) {
        RemoveDownload doWorkRunnable = new RemoveDownload(mgr);
        SwingUtilities.invokeLater(doWorkRunnable);
        if (mgr.getState() == 4) {
            iTunesMediator.instance().handleCompleteDownload(mgr);
        }
    }

    public void downloadsComplete() {
        Finalizer.setDownloadsComplete();
    }

    public void addUpload(Uploader mgr) {
        AddUpload doWorkRunnable = new AddUpload(mgr);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void removeUpload(Uploader mgr) {
        RemoveUpload doWorkRunnable = new RemoveUpload(mgr);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void uploadsComplete() {
        Finalizer.setUploadsComplete();
    }

    public void notifyUserAboutUpdate(final String m, boolean isPro, final boolean loc) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.instance().showUpdateNotification(false);
                String message = loc ? GUIMediator.getStringResource("UPDATE_MESSAGE") + " " + m : "LimeWire has detected a new version on the network. Please update to version " + m;
                UpdateDialog up = new UpdateDialog(message);
                if (up.isUpdating()) {
                    GUIMediator.openURL("http://www.limewire.com/update");
                }
            }
        });
    }

    public void acceptChat(final Chatter chatter) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChatUIManager.instance().acceptChat(chatter);
            }
        });
    }

    public void receiveMessage(final Chatter chatter) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChatUIManager.instance().recieveMessage(chatter);
            }
        });
    }

    public void chatUnavailable(final Chatter chatter) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChatUIManager.instance().chatUnavailable(chatter);
            }
        });
    }

    public void chatErrorMessage(final Chatter chatter, final String str) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChatUIManager.instance().chatErrorMessage(chatter, str);
            }
        });
    }

    public void browseHostFailed(final GUID guid) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchMediator.browseHostFailed(guid);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUserAuthenticationInfo(String host) {
        Object lock = new Object();
        PasswordDialogRunnable passDialog = new PasswordDialogRunnable(host, lock);
        SwingUtilities.invokeLater(passDialog);
        Object object = lock;
        synchronized (object) {
            while (passDialog.notFinished()) {
                try {
                    lock.wait();
                }
                catch (InterruptedException ie) {}
            }
        }
        return passDialog.getUser();
    }

    public void promptAboutCorruptDownload(Downloader downloader) {
        final Downloader dloader = downloader;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int resp = GUIMediator.showYesNoMessage("MESSAGE_FILE_CORRUPT", dloader.getFileName(), "MESSAGE_CONTINUE_DOWNLOAD", QuestionsHandler.CORRUPT_DOWNLOAD);
                dloader.discardCorruptDownload(resp == 102);
            }
        });
    }

    public void restoreApplication() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.restoreView();
            }
        });
    }

    public void componentLoading(final String component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_COMPONENT_LOADING_" + component));
            }
        });
    }

    public void showDownloads() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.instance().setWindow(0);
            }
        });
    }

    public boolean isQueryAlive(GUID guid) {
        return SearchMediator.queryIsAlive(guid);
    }

    public void indicateNewVersion() {
        GUIMediator.instance().showUpdateNotification(true);
    }

    public String getHostValue(String key) {
        return GUIMediator.getStringResource(key);
    }

    private MainFrame mf() {
        return GUIMediator.instance().getMainFrame();
    }

    private class PasswordDialogRunnable
    implements Runnable {
        private String _title;
        private Object _lock;
        private volatile boolean _notFinished = true;
        private PasswordDialog _passwordDialog;
        private volatile boolean _cancelled = false;

        public PasswordDialogRunnable(String title, Object lock) {
            this._title = title;
            this._lock = lock;
            this._passwordDialog = new PasswordDialog(title);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int returnCode = GUIMediator.instance().showPasswordDialog(this._passwordDialog);
            if (returnCode == 78) {
                this._cancelled = true;
            }
            Object object = this._lock;
            synchronized (object) {
                this._notFinished = false;
                this._lock.notifyAll();
            }
        }

        public boolean notFinished() {
            return this._notFinished;
        }

        public User getUser() {
            if (this._cancelled) {
                return new User("", "");
            }
            return new User(this._passwordDialog.getUsername(), this._passwordDialog.getPassword());
        }
    }

    private class RemoveUpload
    implements Runnable {
        private Uploader mgr;

        public RemoveUpload(Uploader mgr) {
            this.mgr = mgr;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getUploadMediator().remove(this.mgr);
        }
    }

    private class AddUpload
    implements Runnable {
        private Uploader up;

        public AddUpload(Uploader up) {
            this.up = up;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getUploadMediator().add(this.up);
        }
    }

    private class RemoveDownload
    implements Runnable {
        private Downloader mgr;

        public RemoveDownload(Downloader mgr) {
            this.mgr = mgr;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getDownloadMediator().remove(this.mgr);
            VisualConnectionCallback.this.mf().getLibraryMediator().quickRefresh();
            SearchMediator.updateResults();
        }
    }

    private class AddDownload
    implements Runnable {
        private Downloader mgr;

        public AddDownload(Downloader mgr) {
            this.mgr = mgr;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getDownloadMediator().add(this.mgr);
        }
    }

    private class HandleQueryString
    implements Runnable {
        private Vector list = new Vector();
        private boolean active = false;

        public void addQueryString(String query) {
            this.list.add(query);
            if (!this.active) {
                this.active = true;
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            while (this.list.size() > 0) {
                String query = (String)this.list.elementAt(0);
                this.list.remove(0);
                VisualConnectionCallback.this.mf().getMonitorView().handleQueryString(query);
            }
            this.active = false;
        }
    }

    private class ConnectionClosed
    implements Runnable {
        private Connection c;

        public ConnectionClosed(Connection c) {
            this.c = c;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getConnectionMediator().remove(this.c);
        }
    }

    private class ConnectionInitialized
    implements Runnable {
        private Connection c;

        public ConnectionInitialized(Connection c) {
            this.c = c;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getConnectionMediator().update(this.c);
        }
    }

    private class ConnectionInitializing
    implements Runnable {
        private Connection c;

        public ConnectionInitializing(Connection c) {
            this.c = c;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getConnectionMediator().add(this.c);
        }
    }
}

