/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.download.PriorityHolder;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.FileTransfer;
import com.limegroup.gnutella.gui.tables.IconAndNameHolderImpl;
import com.limegroup.gnutella.gui.tables.LazyFileTransfer;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import com.limegroup.gnutella.gui.tables.SpeedHolder;
import com.limegroup.gnutella.gui.tables.TimeRemainingHolder;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.File;
import java.util.Iterator;
import javax.swing.Icon;

public final class DownloadDataLine
extends AbstractDataLine
implements LazyFileTransfer {
    private Downloader DOWNLOADER;
    private static final String QUEUED_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_QUEUED");
    private static final String CONNECTING_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_CONNECTING");
    private static final String WAITING_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_WAITING");
    private static final String COMPLETE_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_COMPLETE");
    private static final String ABORTED_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_ABORTED");
    private static final String FAILED_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_FAILED");
    private static final String DOWNLOADING_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_DOWNLOADING");
    private static final String LIBRARY_MOVE_FAILED_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_LIBRARY_MOVE_FAILED");
    private static final String CORRUPT_FILE_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_CORRUPT_FILE");
    private static final String REQUERY_WAITING_STATE_START = GUIMediator.getStringResource("DOWNLOAD_STATUS_WAITING_FOR_REQUERY_START");
    private static final String REQUERY_WAITING_STATE_END = GUIMediator.getStringResource("DOWNLOAD_STATUS_WAITING_FOR_REQUERY_END");
    private static final String REQUERY_WAITING_FOR_USER = GUIMediator.getStringResource("DOWNLOAD_STATUS_WAITING_FOR_USER");
    private static final String WAITING_FOR_CONNECTIONS_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_WAITING_FOR_CONN");
    private static final String REMOTE_QUEUED_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_REMOTE_QUEUED");
    private static final String HASHING_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_HASHING");
    private static final String SAVING_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_SAVING");
    private static final String IDENTIFY_CORRUPTION_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_IDENTIFY_CORRUPTION");
    private static final String RECOVERY_FAILED_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_RECOVERY_FAILED");
    private static final String PAUSING_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_PAUSING");
    private static final String PAUSED_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_PAUSED");
    private static final String AVERAGE_BANDWIDTH = GUIMediator.getStringResource("GENERAL_AVERAGE_BANDWIDTH");
    private static final String ALTERNATE_LOCATIONS = GUIMediator.getStringResource("GENERAL_ALTERNATE_LOCATIONS");
    private static final String INVALID_ALTERNATE_LOCATIONS = GUIMediator.getStringResource("GENERAL_INVALID_ALTERNATE_LOCATIONS");
    private static final String STARTED_ON = GUIMediator.getStringResource("GENERAL_STARTED_ON");
    private static final String FINISHED_ON = GUIMediator.getStringResource("GENERAL_FINISHED_ON");
    private static final String TIME_SPENT = GUIMediator.getStringResource("GENERAL_TIME_SPENT");
    private static final String HOSTS_LABEL = GUIMediator.getStringResource("DOWNLOAD_HOSTS_LABEL");
    private static final String HOST_LABEL = GUIMediator.getStringResource("DOWNLOAD_HOST_LABEL");
    private static final String[] GAVE_UP_MESSAGE = new String[]{GUIMediator.getStringResource("DOWNLOAD_AWAITING_SOURCES")};
    private static final String POSSIBLE_HOSTS = GUIMediator.getStringResource("DOWNLOAD_POSSIBLE_HOSTS");
    private static final String BUSY_HOSTS = GUIMediator.getStringResource("DOWNLOAD_BUSY_HOSTS");
    private static final String QUEUED_HOSTS = GUIMediator.getStringResource("DOWNLOAD_QUEUED_HOSTS");
    private static final String DOWNLOAD_SEARCHING = GUIMediator.getStringResource("DOWNLOAD_SEARCHING");
    private String _fileName;
    private String _status;
    private int _amountRead = 0;
    private int _progress;
    private boolean _chatEnabled;
    private boolean _browseEnabled;
    private int _size = -1;
    private double _speed;
    private int _timeLeft;
    private long _startTime;
    private long _endTime;
    private String _vendor;
    private int _state;
    private boolean _cleaned = false;
    static final int PRIORITY_INDEX = 0;
    private static final LimeTableColumn PRIORITY_COLUMN = new LimeTableColumn(0, "DOWNLOAD_PRIORITY_COLUMN", 40, false, class$com$limegroup$gnutella$gui$tables$CenteredHolder == null ? (class$com$limegroup$gnutella$gui$tables$CenteredHolder = DownloadDataLine.class$("com.limegroup.gnutella.gui.tables.CenteredHolder")) : class$com$limegroup$gnutella$gui$tables$CenteredHolder);
    static final int FILE_INDEX = 1;
    private static final LimeTableColumn FILE_COLUMN = new LimeTableColumn(1, "DOWNLOAD_NAME_COLUMN", 201, true, class$com$limegroup$gnutella$gui$tables$IconAndNameHolder == null ? (class$com$limegroup$gnutella$gui$tables$IconAndNameHolder = DownloadDataLine.class$("com.limegroup.gnutella.gui.tables.IconAndNameHolder")) : class$com$limegroup$gnutella$gui$tables$IconAndNameHolder);
    static final int SIZE_INDEX = 2;
    private static final LimeTableColumn SIZE_COLUMN = new LimeTableColumn(2, "DOWNLOAD_SIZE_COLUMN", 65, true, class$com$limegroup$gnutella$gui$tables$SizeHolder == null ? (class$com$limegroup$gnutella$gui$tables$SizeHolder = DownloadDataLine.class$("com.limegroup.gnutella.gui.tables.SizeHolder")) : class$com$limegroup$gnutella$gui$tables$SizeHolder);
    static final int STATUS_INDEX = 3;
    private static final LimeTableColumn STATUS_COLUMN = new LimeTableColumn(3, "DOWNLOAD_STATUS_COLUMN", 152, true, class$java$lang$String == null ? (class$java$lang$String = DownloadDataLine.class$("java.lang.String")) : class$java$lang$String);
    static final int CHAT_INDEX = 4;
    private static final LimeTableColumn CHAT_COLUMN = new LimeTableColumn(4, "DOWNLOAD_CHAT_COLUMN", 10, false, class$com$limegroup$gnutella$gui$tables$ChatHolder == null ? (class$com$limegroup$gnutella$gui$tables$ChatHolder = DownloadDataLine.class$("com.limegroup.gnutella.gui.tables.ChatHolder")) : class$com$limegroup$gnutella$gui$tables$ChatHolder);
    static final int PROGRESS_INDEX = 5;
    private static final LimeTableColumn PROGRESS_COLUMN = new LimeTableColumn(5, "DOWNLOAD_PROGRESS_COLUMN", 71, true, class$com$limegroup$gnutella$gui$tables$ProgressBarHolder == null ? (class$com$limegroup$gnutella$gui$tables$ProgressBarHolder = DownloadDataLine.class$("com.limegroup.gnutella.gui.tables.ProgressBarHolder")) : class$com$limegroup$gnutella$gui$tables$ProgressBarHolder);
    static final int SPEED_INDEX = 6;
    private static final LimeTableColumn SPEED_COLUMN = new LimeTableColumn(6, "DOWNLOAD_SPEED_COLUMN", 58, true, class$java$lang$String == null ? (class$java$lang$String = DownloadDataLine.class$("java.lang.String")) : class$java$lang$String);
    static final int TIME_INDEX = 7;
    private static final LimeTableColumn TIME_COLUMN = new LimeTableColumn(7, "DOWNLOAD_TIME_REMAINING_COLUMN", 49, true, class$com$limegroup$gnutella$gui$tables$TimeRemainingHolder == null ? (class$com$limegroup$gnutella$gui$tables$TimeRemainingHolder = DownloadDataLine.class$("com.limegroup.gnutella.gui.tables.TimeRemainingHolder")) : class$com$limegroup$gnutella$gui$tables$TimeRemainingHolder);
    static final int VENDOR_INDEX = 8;
    private static final LimeTableColumn VENDOR_COLUMN = new LimeTableColumn(8, "DOWNLOAD_SERVER_COLUMN", 20, false, class$java$lang$String == null ? (class$java$lang$String = DownloadDataLine.class$("java.lang.String")) : class$java$lang$String);
    static final int NUMBER_OF_COLUMNS = 9;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$CenteredHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$IconAndNameHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$SizeHolder;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$ChatHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$ProgressBarHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$TimeRemainingHolder;

    public int getColumnCount() {
        return 9;
    }

    public void initialize(Object downloader) {
        super.initialize(downloader);
        this.DOWNLOADER = (Downloader)downloader;
        this._startTime = System.currentTimeMillis();
        this._endTime = -1L;
        this._size = this.DOWNLOADER.getContentLength();
        this._fileName = this.DOWNLOADER.getFileName();
        if (this._fileName == null) {
            this._fileName = "";
        }
        this._status = "";
        this._chatEnabled = false;
        this._browseEnabled = false;
        this.update();
    }

    public void cleanup() {
        GUIMediator.instance().schedule(new Runnable(){

            public void run() {
                DownloadDataLine.this.DOWNLOADER.stop();
            }
        });
        this._cleaned = true;
    }

    public boolean isCleaned() {
        return this._cleaned;
    }

    public File getFile() {
        if (!CommonUtils.isWindows()) {
            return this.DOWNLOADER.getFile();
        }
        if (this.DOWNLOADER.isCompleted()) {
            return this.DOWNLOADER.getFile();
        }
        return null;
    }

    public FileTransfer getLazyFile() {
        return new FileTransfer(){

            public File getFile() {
                return DownloadDataLine.this.DOWNLOADER.getDownloadFragment();
            }
        };
    }

    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                if (this.DOWNLOADER.isPaused()) {
                    return PriorityHolder.PAUSED_P;
                }
                if (this.DOWNLOADER.isInactive()) {
                    return new PriorityHolder(this.DOWNLOADER.getInactivePriority());
                }
                if (this.DOWNLOADER.isCompleted()) {
                    return PriorityHolder.COMPLETE_P;
                }
                return PriorityHolder.ACTIVE_P;
            }
            case 1: {
                Icon icon = IconManager.instance().getIconForFile(this.DOWNLOADER.getFile());
                return new IconAndNameHolderImpl(icon, this._fileName);
            }
            case 2: {
                return new SizeHolder(this._size);
            }
            case 3: {
                return this._status;
            }
            case 4: {
                return this._chatEnabled ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return new Integer(this._progress);
            }
            case 6: {
                return new SpeedHolder(this._speed);
            }
            case 7: {
                return new TimeRemainingHolder(this._timeLeft);
            }
            case 8: {
                return this._vendor;
            }
        }
        return null;
    }

    public LimeTableColumn getColumn(int idx) {
        switch (idx) {
            case 0: {
                return PRIORITY_COLUMN;
            }
            case 1: {
                return FILE_COLUMN;
            }
            case 2: {
                return SIZE_COLUMN;
            }
            case 3: {
                return STATUS_COLUMN;
            }
            case 4: {
                return CHAT_COLUMN;
            }
            case 5: {
                return PROGRESS_COLUMN;
            }
            case 6: {
                return SPEED_COLUMN;
            }
            case 7: {
                return TIME_COLUMN;
            }
            case 8: {
                return VENDOR_COLUMN;
            }
        }
        return null;
    }

    public boolean isClippable(int idx) {
        switch (idx) {
            case 4: 
            case 5: {
                return false;
            }
        }
        return true;
    }

    public int getTypeAheadColumn() {
        return 1;
    }

    public String[] getToolTipArray(int col) {
        if (this._state == 6) {
            return GAVE_UP_MESSAGE;
        }
        String[] info = new String[this._endTime == -1L ? 9 : 10];
        String bandwidth = AVERAGE_BANDWIDTH + ": " + GUIUtils.rate2speed(this.DOWNLOADER.getAverageBandwidth());
        String numHosts = POSSIBLE_HOSTS + ": " + this.DOWNLOADER.getPossibleHostCount();
        String busyHosts = BUSY_HOSTS + ": " + this.DOWNLOADER.getBusyHostCount();
        String queuedHosts = QUEUED_HOSTS + ": " + this.DOWNLOADER.getQueuedHostCount();
        String numLocs = ALTERNATE_LOCATIONS + ": " + this.DOWNLOADER.getNumberOfAlternateLocations();
        String numInvalidLocs = INVALID_ALTERNATE_LOCATIONS + ": " + this.DOWNLOADER.getNumberOfInvalidAlternateLocations();
        info[0] = STARTED_ON + " " + GUIUtils.msec2DateTime(this._startTime);
        if (this._endTime != -1L) {
            info[1] = FINISHED_ON + " " + GUIUtils.msec2DateTime(this._endTime);
            info[2] = TIME_SPENT + ": " + GUIUtils.seconds2time((int)((this._endTime - this._startTime) / 1000L));
            info[3] = "";
            info[4] = bandwidth;
            info[5] = numHosts;
            info[6] = busyHosts;
            info[7] = queuedHosts;
            info[8] = numLocs;
            info[9] = numInvalidLocs;
        } else {
            info[1] = TIME_SPENT + ": " + GUIUtils.seconds2time((int)((System.currentTimeMillis() - this._startTime) / 1000L));
            info[2] = "";
            info[3] = bandwidth;
            info[4] = numHosts;
            info[5] = busyHosts;
            info[6] = queuedHosts;
            info[7] = numLocs;
            info[8] = numInvalidLocs;
        }
        return info;
    }

    public boolean isDynamic(int idx) {
        switch (idx) {
            case 0: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    int getLength() {
        return this._size;
    }

    boolean containsDownloader(Downloader downloader) {
        return this.DOWNLOADER.equals(downloader);
    }

    Downloader getDownloader() {
        return this.DOWNLOADER;
    }

    int getState() {
        return this._state;
    }

    boolean isCompleted() {
        return this._state == 4;
    }

    boolean getChatEnabled() {
        return this._chatEnabled;
    }

    boolean getBrowseEnabled() {
        return this._browseEnabled;
    }

    public void update() {
        if (this._fileName == null) {
            this._fileName = this.DOWNLOADER.getFileName();
        }
        this._speed = -1.0;
        if (this._size == -1) {
            this._size = this.DOWNLOADER.getContentLength();
        }
        this._amountRead = this.DOWNLOADER.getAmountRead();
        this._chatEnabled = this.DOWNLOADER.hasChatEnabledHost();
        this._browseEnabled = this.DOWNLOADER.hasBrowseEnabledHost();
        this._timeLeft = 0;
        double d = (double)this._amountRead / (double)this._size;
        this._progress = (int)(d * 100.0);
        this.updateStatus();
        if (!this.isInactive()) {
            this._endTime = -1L;
        }
    }

    private void updateStatus() {
        String lastVendor = this._vendor;
        this._vendor = "";
        this._state = this.DOWNLOADER.getState();
        boolean paused = this.DOWNLOADER.isPaused();
        if (paused && this._state != 18 && !this.DOWNLOADER.isCompleted()) {
            this._status = PAUSING_STATE;
            return;
        }
        switch (this._state) {
            case 0: {
                this._status = QUEUED_STATE;
                break;
            }
            case 1: {
                this._status = CONNECTING_STATE;
                break;
            }
            case 3: {
                this._status = WAITING_STATE;
                break;
            }
            case 11: {
                this._status = HASHING_STATE;
                break;
            }
            case 12: {
                this._status = SAVING_STATE;
                break;
            }
            case 4: {
                this._status = COMPLETE_STATE;
                this._progress = 100;
                break;
            }
            case 5: {
                this._status = ABORTED_STATE;
                break;
            }
            case 6: {
                this._status = FAILED_STATE;
                break;
            }
            case 16: {
                this._status = IDENTIFY_CORRUPTION_STATE;
                break;
            }
            case 17: {
                this._status = "Recovery Failed";
                break;
            }
            case 2: {
                this._vendor = lastVendor;
                this.updateHostCount(this.DOWNLOADER);
                try {
                    this._speed = this.DOWNLOADER.getMeasuredBandwidth();
                }
                catch (InsufficientDataException ide) {
                    this._speed = 0.0;
                }
                if (!(this._speed > 0.0)) break;
                double kbLeft = (double)this._size / 1024.0 - (double)this._amountRead / 1024.0;
                this._timeLeft = (int)(kbLeft / this._speed);
                break;
            }
            case 7: {
                this._status = LIBRARY_MOVE_FAILED_STATE;
                this._progress = 100;
                break;
            }
            case 9: {
                this._status = CORRUPT_FILE_STATE;
                break;
            }
            case 8: {
                int stateTime = this.DOWNLOADER.getRemainingStateTime();
                this._status = REQUERY_WAITING_STATE_START + " " + stateTime + REQUERY_WAITING_STATE_END;
                break;
            }
            case 15: {
                this._status = DOWNLOAD_SEARCHING;
                break;
            }
            case 13: {
                this._status = REQUERY_WAITING_FOR_USER;
                break;
            }
            case 14: {
                this._status = WAITING_FOR_CONNECTIONS_STATE;
                break;
            }
            case 10: {
                this._status = REMOTE_QUEUED_STATE + " " + this.DOWNLOADER.getQueuePosition();
                this._vendor = this.DOWNLOADER.getVendor();
                break;
            }
            case 18: {
                this._status = PAUSED_STATE;
                break;
            }
            default: {
                Assert.that(false, "Unknown status " + this.DOWNLOADER.getState() + " of downloader");
            }
        }
    }

    private void updateHostCount(Downloader d) {
        int count = 0;
        Endpoint last = null;
        Iterator iter = d.getHosts();
        while (iter.hasNext()) {
            last = (Endpoint)iter.next();
            ++count;
        }
        if (count == 0) {
            return;
        }
        if (count == 1) {
            this._status = DOWNLOADING_STATE + " " + count + " " + HOST_LABEL;
            this._vendor = d.getVendor();
        } else {
            this._status = DOWNLOADING_STATE + " " + count + " " + HOSTS_LABEL;
            this._vendor = d.getVendor();
        }
    }

    boolean isInactive() {
        return this._state == 4 || this._state == 5 || this._state == 6 || this._state == 7 || this._state == 9;
    }

    boolean isDownloaderInactive() {
        return this.DOWNLOADER.isInactive();
    }

    boolean isDownloading() {
        return this._state == 2;
    }

    void setEndTime(long time) {
        this._endTime = time;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

