/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.download.DownloadButtons;
import com.limegroup.gnutella.gui.download.DownloadDataLine;
import com.limegroup.gnutella.gui.download.DownloadModel;
import com.limegroup.gnutella.gui.download.DownloadPopupMenu;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.DragManager;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.SimpleColumnListener;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JPopupMenu;

public final class DownloadMediator
extends AbstractTableMediator {
    private static int _totalDownloads = 0;
    private static boolean _audioLaunched = false;
    private static DownloadMediator _instance = new DownloadMediator();
    private static boolean _chatEnabled;
    private static boolean _browseEnabled;
    private static final ProcessingQueue QUEUE;
    public ActionListener CHAT_LISTENER;
    public ActionListener CLEAR_LISTENER;
    public ActionListener BROWSE_LISTENER;
    public ActionListener LAUNCH_LISTENER;
    public ActionListener RESUME_LISTENER;
    public ActionListener PAUSE_LISTENER;
    public ActionListener PRIORITY_UP_LISTENER;
    public ActionListener PRIORITY_DOWN_LISTENER;
    private DownloadButtons _downloadButtons;

    public static DownloadMediator instance() {
        return _instance;
    }

    protected void buildSettings() {
        this.SETTINGS = new TableSettings(this.ID){

            public boolean getDefaultTooltips() {
                return false;
            }
        };
    }

    protected void setupDragAndDrop() {
        DragManager.install(this.TABLE);
    }

    protected void buildListeners() {
        super.buildListeners();
        this.CHAT_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DownloadMediator.this.chatWithSelectedDownloads();
            }
        };
        this.CLEAR_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DownloadMediator.this.clearCompletedDownloads();
            }
        };
        this.BROWSE_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DownloadMediator.this.browseSelectedDownloads();
            }
        };
        this.LAUNCH_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DownloadMediator.this.launchSelectedDownloads();
            }
        };
        this.RESUME_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DownloadMediator.this.resumeSelectedDownloads();
            }
        };
        this.PAUSE_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DownloadMediator.this.pauseSelectedDownloads();
            }
        };
        this.PRIORITY_UP_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DownloadMediator.this.bumpPriority(true);
            }
        };
        this.PRIORITY_DOWN_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DownloadMediator.this.bumpPriority(false);
            }
        };
    }

    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel(GUIMediator.getStringResource("DOWNLOAD_TITLE"));
        this.DATA_MODEL = new DownloadModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this._downloadButtons = new DownloadButtons(this);
        this.BUTTON_ROW = this._downloadButtons.getComponent();
    }

    protected void setupTableHeaders() {
        super.setupTableHeaders();
        Object pId = this.DATA_MODEL.getColumnId(0);
        this._downloadButtons.setQueuePanelVisible(this.TABLE.isColumnVisible(pId));
        ColumnPreferenceHandler cph = this.TABLE.getColumnPreferenceHandler();
        cph.setSimpleColumnListener(new SimpleColumnListener(){

            public void columnAdded(LimeTableColumn ltc, LimeJTable table) {
                Assert.that(table == DownloadMediator.this.TABLE);
                if (ltc.getModelIndex() == 0) {
                    DownloadMediator.this._downloadButtons.setQueuePanelVisible(true);
                }
            }

            public void columnRemoved(LimeTableColumn ltc, LimeJTable table) {
                Assert.that(table == DownloadMediator.this.TABLE);
                if (ltc.getModelIndex() == 0) {
                    DownloadMediator.this._downloadButtons.setQueuePanelVisible(false);
                }
            }
        });
    }

    protected void updateSplashScreen() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_DOWNLOAD_WINDOW"));
    }

    private DownloadMediator() {
        super("DOWNLOAD_TABLE");
        GUIMediator.addRefreshListener(this);
        ThemeMediator.addThemeObserver(this);
        if (this.SETTINGS.REAL_TIME_SORT.getValue()) {
            this.DATA_MODEL.sort(0);
        }
    }

    public void doRefresh() {
        boolean inactivePresent = (Boolean)this.DATA_MODEL.refresh();
        this.setButtonEnabled(6, inactivePresent);
        int[] selRows = this.TABLE.getSelectedRows();
        if (selRows.length > 0) {
            DownloadDataLine dataLine = (DownloadDataLine)this.DATA_MODEL.get(selRows[0]);
            if (dataLine.getState() == 13) {
                this._downloadButtons.transformResumeButton();
            } else {
                this._downloadButtons.transformSourcesButton();
            }
            boolean inactive = dataLine.isDownloaderInactive();
            boolean pausable = !dataLine.getDownloader().isPaused() && !dataLine.getDownloader().isCompleted();
            this.setButtonEnabled(3, inactive);
            this.setButtonEnabled(4, pausable);
            this.setButtonEnabled(0, inactive && pausable);
            this.setButtonEnabled(1, inactive && pausable);
        }
    }

    public int getTotalDownloads() {
        return _totalDownloads;
    }

    public int getCurrentDownloads() {
        return ((DownloadModel)this.DATA_MODEL).getCurrentDownloads();
    }

    public int getActiveDownloads() {
        return ((DownloadModel)this.DATA_MODEL).getRowCount();
    }

    public void add(Object downloader) {
        if (!this.DATA_MODEL.contains(downloader)) {
            ++_totalDownloads;
            super.add(downloader);
        }
    }

    public void remove(Object downloader) {
        Downloader dloader = (Downloader)downloader;
        int state = dloader.getState();
        if (state == 4 && this.isThemeFile(dloader.getFileName())) {
            File themeFile = dloader.getDownloadFragment();
            themeFile = this.copyToThemeDir(themeFile);
            int response = GUIMediator.showYesNoMessage("DOWNLOAD_APPLY_NEW_THEME_START", ThemeSettings.formatName(dloader.getFileName()), "DOWNLOAD_APPLY_NEW_THEME_END", QuestionsHandler.THEME_DOWNLOADED);
            if (response == 101) {
                ThemeMediator.changeTheme(themeFile);
            }
        }
        if (SharingSettings.CLEAR_DOWNLOAD.getValue() && (state == 4 || state == 5)) {
            super.remove(downloader);
        } else {
            DownloadDataLine ddl = (DownloadDataLine)this.DATA_MODEL.get(downloader);
            if (ddl != null) {
                ddl.setEndTime(System.currentTimeMillis());
            }
        }
    }

    private File copyToThemeDir(File themeFile) {
        File themeDir = ThemeSettings.THEME_DIR_FILE;
        File realLoc = new File(themeDir, themeFile.getName());
        if (realLoc.equals(themeFile)) {
            return themeFile;
        }
        realLoc.delete();
        CommonUtils.copy(themeFile, realLoc);
        return realLoc;
    }

    private boolean isThemeFile(String name) {
        return name.toLowerCase().endsWith("lwtp");
    }

    void launchSelectedDownloads() {
        DataLine[] lines = this.TABLE.getSelectedDataLines();
        _audioLaunched = false;
        for (int i = 0; i < lines.length; ++i) {
            final Downloader dl = (Downloader)lines[i].getInitializeObject();
            QUEUE.add(new Runnable(){

                public void run() {
                    File toLaunch = dl.getDownloadFragment();
                    if (toLaunch == null) {
                        GUIMediator.showMessage("NO_PREVIEW_BEGIN", dl.getFileName(), "NO_PREVIEW_END", QuestionsHandler.NO_PREVIEW_REPORT);
                        return;
                    }
                    if (!_audioLaunched && GUIMediator.isValidPlaylistFile(toLaunch)) {
                        GUIMediator.instance().launchAudio(toLaunch);
                        _audioLaunched = true;
                    } else {
                        try {
                            GUIMediator.launchFile(toLaunch);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    void pauseSelectedDownloads() {
        DataLine[] lines = this.TABLE.getSelectedDataLines();
        for (int i = 0; i < lines.length; ++i) {
            ((Downloader)lines[i].getInitializeObject()).pause();
        }
    }

    void bumpPriority(final boolean up) {
        DataLine[] lines = this.TABLE.getSelectedDataLines();
        Arrays.sort(lines, new Comparator(){

            public int compare(Object a, Object b) {
                int pb;
                int pa = ((Downloader)((DataLine)a).getInitializeObject()).getInactivePriority();
                return (pa < (pb = ((Downloader)((DataLine)b).getInitializeObject()).getInactivePriority()) ? -1 : (pa > pb ? 1 : 0)) * (up ? 1 : -1);
            }
        });
        for (int i = 0; i < lines.length; ++i) {
            Downloader dl = (Downloader)lines[i].getInitializeObject();
            RouterService.getDownloadManager().bumpPriority(dl, up);
        }
    }

    void resumeSelectedDownloads() {
        DataLine[] lines = this.TABLE.getSelectedDataLines();
        for (int i = 0; i < lines.length; ++i) {
            DownloadDataLine dd = (DownloadDataLine)lines[i];
            Downloader downloader = dd.getDownloader();
            try {
                if (dd.isCleaned()) continue;
                downloader.resume();
                continue;
            }
            catch (AlreadyDownloadingException e) {
                GUIMediator.showError("ERROR_ALREADY_DOWNLOADING", (Object)("\"" + e.getFilename() + "\"."), QuestionsHandler.ALREADY_DOWNLOADING);
            }
        }
    }

    void chatWithSelectedDownloads() {
        DataLine[] lines = this.TABLE.getSelectedDataLines();
        for (int i = 0; i < lines.length; ++i) {
            DataLine dl = lines[i];
            Downloader downloader = (Downloader)dl.getInitializeObject();
            Endpoint end = downloader.getChatEnabledHost();
            if (end == null) continue;
            RouterService.createChat(end.getAddress(), end.getPort());
        }
    }

    void browseSelectedDownloads() {
        DataLine[] lines = this.TABLE.getSelectedDataLines();
        for (int i = 0; i < lines.length; ++i) {
            DataLine dl = lines[i];
            Downloader downloader = (Downloader)dl.getInitializeObject();
            RemoteFileDesc end = downloader.getBrowseEnabledHost();
            if (end == null) continue;
            SearchMediator.doBrowseHost(end);
        }
    }

    public void handleActionKey() {
        this.launchSelectedDownloads();
    }

    void clearCompletedDownloads() {
        ((DownloadModel)this.DATA_MODEL).clearCompleted();
        this.clearSelection();
        this.setButtonEnabled(6, false);
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new DownloadPopupMenu(this).getComponent();
        boolean selection = !this.TABLE.getSelectionModel().isSelectionEmpty();
        menu.getComponent(0).setEnabled(selection);
        menu.getComponent(1).setEnabled(selection);
        menu.getComponent(2).setEnabled(selection);
        menu.getComponent(3).setEnabled(_chatEnabled);
        menu.getComponent(4).setEnabled(_browseEnabled);
        return menu;
    }

    public void handleSelection(int row) {
        boolean pausable;
        DownloadDataLine dataLine = (DownloadDataLine)this.DATA_MODEL.get(row);
        _chatEnabled = dataLine.getChatEnabled();
        _browseEnabled = dataLine.getBrowseEnabled();
        boolean inactive = dataLine.isDownloaderInactive();
        boolean bl = pausable = !dataLine.getDownloader().isPaused() && !dataLine.getDownloader().isCompleted();
        if (dataLine.getState() == 13) {
            this._downloadButtons.transformResumeButton();
        } else {
            this._downloadButtons.transformSourcesButton();
        }
        this.setButtonEnabled(2, true);
        this.setButtonEnabled(3, inactive);
        this.setButtonEnabled(5, true);
        this.setButtonEnabled(4, pausable);
        this.setButtonEnabled(0, inactive && pausable);
        this.setButtonEnabled(1, inactive && pausable);
    }

    public void handleNoSelection() {
        _chatEnabled = false;
        _browseEnabled = false;
        this.setButtonEnabled(2, false);
        this.setButtonEnabled(3, false);
        this.setButtonEnabled(5, false);
        this.setButtonEnabled(4, false);
        this.setButtonEnabled(0, false);
        this.setButtonEnabled(1, false);
    }

    static {
        QUEUE = new ProcessingQueue("DownloadLauncher");
    }
}

