/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.library.LibraryConstructor;
import com.limegroup.gnutella.gui.library.LibraryTableMediator;
import com.limegroup.gnutella.gui.library.LibraryTree;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class LibraryMediator
implements ThemeObserver {
    private static final LibraryMediator INSTANCE = new LibraryMediator();
    private static final LibraryTree LIBRARY_TREE = new LibraryTree();
    private static final LibraryTableMediator LIBRARY_TABLE = LibraryTableMediator.instance();
    private static final LibraryConstructor LIBRARY_CONSTRUCTOR = new LibraryConstructor(LIBRARY_TABLE, LIBRARY_TREE);
    private final HandleFileUpdate FILE_UPDATER = new HandleFileUpdate();

    public static LibraryMediator instance() {
        return INSTANCE;
    }

    private LibraryMediator() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_LIBRARY_WINDOW"));
        ThemeMediator.addThemeObserver(this);
    }

    public void updateTheme() {
        LIBRARY_CONSTRUCTOR.updateTheme();
        LIBRARY_TREE.updateTheme();
    }

    public JComponent getComponent() {
        return LIBRARY_CONSTRUCTOR.getComponent();
    }

    public void launch() {
        LIBRARY_TABLE.launch();
    }

    public void deleteLibraryFile() {
        LIBRARY_TABLE.removeSelection();
    }

    public void clearLibrary() {
        LIBRARY_TREE.clear();
        LIBRARY_TABLE.clearTable();
    }

    public void refresh() {
        LIBRARY_TABLE.clearTable();
        if (LIBRARY_TREE.incompleteDirectoryIsSelected()) {
            this.showIncompleteFiles();
        } else if (LIBRARY_TREE.savedDirectoryIsSelected()) {
            this.showSavedFile();
        } else {
            if (LIBRARY_TREE.getSelectedDirectory() != null) {
                this.loadShareableFiles(LIBRARY_TREE.getSelectedDirectory());
                LIBRARY_TABLE.forceResort();
            }
            FileManager fm = RouterService.getFileManager();
            fm.loadSettings(false);
        }
    }

    public void quickRefresh() {
        if (LIBRARY_TREE.incompleteDirectoryIsSelected()) {
            this.refresh();
        } else if (LIBRARY_TREE.savedDirectoryIsSelected()) {
            this.refresh();
        }
    }

    public void cancelEditing() {
        LIBRARY_TREE.cancelEditing();
    }

    public static void launchExplorer() {
        File exploreDir = null;
        if (LIBRARY_TREE.getSelectedDirectory() != null) {
            exploreDir = LIBRARY_TREE.getSelectedDirectory();
        }
        if (exploreDir == null) {
            return;
        }
        String explorePath = exploreDir.getPath();
        try {
            explorePath = exploreDir.getCanonicalPath();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            String cmdStr = "";
            if (CommonUtils.isWindows()) {
                cmdStr = "explorer";
            } else if (CommonUtils.isMacOSX()) {
                cmdStr = "open";
            }
            Runtime.getRuntime().exec(new String[]{cmdStr, explorePath});
        }
        catch (SecurityException se) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addSharedLibraryFolder() {
        File dir = FileChooserHandler.getInputDirectory();
        if (dir == null || !dir.isDirectory() || !dir.canRead()) {
            GUIMediator.showError("ERROR_INVALID_SHARED_DIRECTORY");
            return;
        }
        try {
            SharingSettings.addDirectory(dir);
            RouterService.getFileManager().loadSettings(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void handleRootSharedDirectoryChange() {
        File[] sharedDirectories = LIBRARY_TREE.getSharedDirectories();
        SharingSettings.DIRECTORIES_TO_SHARE.setValue(sharedDirectories);
        RouterService.getFileManager().loadSettings(true);
    }

    public void addSharedDirectory(File dir, File parent) {
        LIBRARY_TREE.addSharedDirectory(dir, parent);
    }

    public void addSharedFile(FileDesc file, File parent) {
        if (LIBRARY_TREE.parentIsSelected(parent)) {
            LIBRARY_TABLE.add(file);
        }
    }

    public void updateSharedFile(File file) {
        File selDir = LIBRARY_TREE.getSelectedDirectory();
        if (selDir != null && selDir.equals(FileUtils.getParentFile(file)) && LIBRARY_TABLE.getTable().isShowing()) {
            this.FILE_UPDATER.addFileUpdate(file);
        }
    }

    public void setAnnotateEnabled(boolean enabled) {
        LIBRARY_TABLE.setAnnotateEnabled(enabled);
    }

    public void unshareLibraryFolder() {
        LIBRARY_TREE.unshareLibraryFolder();
    }

    void addFileToPlayList(File toAdd) {
        GUIMediator.getPlayList().addFileToPlaylist(toAdd);
    }

    void launchAudio(File toPlay) {
        GUIMediator.instance().launchAudio(toPlay);
    }

    void updateTableFiles(File selectedDir) {
        FileDesc[] files = RouterService.getSharedFileDescriptors(selectedDir);
        LIBRARY_TABLE.clearTable();
        LIBRARY_TABLE.setIncompleteSelected(false);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                LIBRARY_TABLE.addUnsorted(files[i]);
            }
        }
        if (RouterService.getNumPendingShared() > 0) {
            this.loadShareableFiles(selectedDir);
        }
        LIBRARY_TABLE.forceResort();
    }

    void loadShareableFiles(File dir) {
        File[] pending = FileUtils.listFiles(dir);
        if (pending != null) {
            for (int i = 0; i < pending.length; ++i) {
                if (!FileManager.isFileShareable(pending[i], pending[i].length())) continue;
                LIBRARY_TABLE.addUnsorted(pending[i]);
            }
        }
    }

    private void showSavedFile() {
        File[] files;
        LIBRARY_TABLE.clearTable();
        File savedFile = SharingSettings.getSaveDirectory();
        if (savedFile == null) {
            return;
        }
        LIBRARY_TABLE.setIncompleteSelected(false);
        FileDesc[] sharedFiles = RouterService.getSharedFileDescriptors(savedFile);
        if (sharedFiles != null) {
            for (int i = 0; i < sharedFiles.length; ++i) {
                LIBRARY_TABLE.addUnsorted(sharedFiles[i]);
            }
        }
        if ((files = savedFile.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile();
            }
        })) != null) {
            for (int i = 0; i < files.length; ++i) {
                LIBRARY_TABLE.addUnsorted(files[i]);
            }
        }
        LIBRARY_TABLE.forceResort();
    }

    private void showIncompleteFiles() {
        File[] files;
        LIBRARY_TABLE.clearTable();
        File incFile = SharingSettings.INCOMPLETE_DIRECTORY.getValue();
        if (incFile == null) {
            return;
        }
        LIBRARY_TABLE.setIncompleteSelected(true);
        FileDesc[] sharedFiles = RouterService.getIncompleteFileDescriptors();
        if (sharedFiles != null) {
            for (int i = 0; i < sharedFiles.length; ++i) {
                LIBRARY_TABLE.addUnsorted(sharedFiles[i]);
            }
        }
        if ((files = incFile.listFiles(new FileFilter(){

            public boolean accept(File file) {
                String name = file.getName();
                return !file.isHidden() && !name.startsWith(".") && file.isFile() && !name.equals("downloads.dat") && !name.equals("downloads.bak");
            }
        })) != null) {
            for (int i = 0; i < files.length; ++i) {
                LIBRARY_TABLE.addUnsorted(files[i]);
            }
        }
        LIBRARY_TABLE.forceResort();
    }

    public boolean incompleteDirectoryIsSelected() {
        return LIBRARY_TREE.incompleteDirectoryIsSelected();
    }

    private static final class HandleFileUpdate
    implements Runnable {
        private Vector list = new Vector();
        private boolean active = false;

        public void addFileUpdate(File f) {
            this.list.addElement(f);
            if (!this.active) {
                this.active = true;
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            try {
                while (this.list.size() > 0) {
                    File f = (File)this.list.firstElement();
                    this.list.removeElementAt(0);
                    LIBRARY_TABLE.update(f);
                }
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (Exception e) {
                GUIMediator.showInternalError(e);
            }
            this.active = false;
        }
    }
}

