/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.playlist.PlaylistMediator;
import com.limegroup.gnutella.gui.tables.DragManager;
import com.limegroup.gnutella.gui.tables.FileTransfer;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.settings.FileSetting;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

final class LibraryTree {
    private final String INCOMPLETE_FILE_NAME = "Incomplete";
    private final LibraryMediator LIBRARY_MEDIATOR = LibraryMediator.instance();
    private final JTree TREE = new JTree();
    private final LibraryTreeNode ROOT_NODE = new LibraryTreeNode();
    private final DefaultTreeModel TREE_MODEL = new DefaultTreeModel(this.ROOT_NODE);
    private LibraryTreeNode incompleteNode;
    private LibraryTreeNode savedNode;
    private final JPopupMenu DIRECTORY_POPUP = new JPopupMenu();

    LibraryTree() {
        this.TREE.setModel(this.TREE_MODEL);
        this.TREE.setRootVisible(false);
        this.TREE.getSelectionModel().setSelectionMode(1);
        this.TREE.setEditable(false);
        this.TREE.setInvokesStopCellEditing(true);
        this.TREE.setShowsRootHandles(true);
        this.TREE.putClientProperty("JTree.lineStyle", "None");
        this.makePopupMenu();
        this.TREE.addTreeSelectionListener(new LibraryTreeSelectionListener());
        this.addIncompleteDirectory();
        this.addSaveDirectory();
        this.updateTheme();
        DragManager.install(this.TREE);
    }

    public void updateTheme() {
        Color tableColor = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        this.TREE.setBackground(tableColor);
        DefaultTreeCellRenderer rnd = new DefaultTreeCellRenderer();
        rnd.setOpaque(false);
        this.TREE.setCellRenderer(rnd);
    }

    void cancelEditing() {
        if (this.TREE.isEditing()) {
            this.TREE.getCellEditor().cancelCellEditing();
        }
    }

    void addSharedDirectory(File dir, File parent) {
        LibraryTreeNode curNode = null;
        LibraryTreeNode nodeToLoad = null;
        InternalNodeFileHolder holder = null;
        if (parent == null) {
            if (!this.ROOT_NODE.isChild(dir)) {
                holder = new InternalNodeFileHolder(dir);
                curNode = new LibraryTreeNode((AbstractFileHolder)holder);
                this.TREE_MODEL.insertNodeInto(curNode, this.ROOT_NODE, this.ROOT_NODE.getChildCount() - 2);
                nodeToLoad = this.ROOT_NODE;
            }
        } else {
            AbstractFileHolder curHolder = null;
            Enumeration<TreeNode> elems = this.ROOT_NODE.breadthFirstEnumeration();
            if (elems.hasMoreElements()) {
                while (elems.hasMoreElements()) {
                    curNode = (LibraryTreeNode)elems.nextElement();
                    curHolder = curNode.getFileHolder();
                    if (!curHolder.matchesFile(parent)) continue;
                    if (!curNode.isChild(dir)) {
                        holder = new InternalNodeFileHolder(dir);
                        LibraryTreeNode newNode = new LibraryTreeNode((AbstractFileHolder)holder);
                        this.TREE_MODEL.insertNodeInto(newNode, curNode, curNode.getChildCount());
                        nodeToLoad = curNode;
                    }
                    break;
                }
            } else {
                InternalNodeFileHolder newHolder = new InternalNodeFileHolder(dir);
                curNode = new LibraryTreeNode((AbstractFileHolder)newHolder);
                this.TREE_MODEL.insertNodeInto(curNode, this.ROOT_NODE, this.ROOT_NODE.getChildCount() - 2);
                nodeToLoad = this.ROOT_NODE;
            }
        }
        this.cancelEditing();
        int[] selected = this.TREE.getSelectionRows();
        this.TREE_MODEL.reload(nodeToLoad);
        if (selected == null || selected.length == 0) {
            this.setSelectionRow(0);
        } else {
            this.setSelectionRow(selected[0]);
        }
    }

    void addPlayListEntries() {
        LibraryTreeNode selectedNode = (LibraryTreeNode)this.TREE.getLastSelectedPathComponent();
        if (selectedNode == null) {
            return;
        }
        if (this.incompleteDirectoryIsSelected()) {
            return;
        }
        final File currFile = selectedNode.getFileHolder().getFile();
        GUIMediator.instance().schedule(new Runnable(){

            public void run() {
                String[] filter = new String[]{"mp3", "ogg"};
                File[] filesToAdd = FileManager.getFilesRecursive(currFile, filter);
                PlaylistMediator pm = GUIMediator.getPlayList();
                if (pm != null) {
                    pm.addFilesToPlaylist(filesToAdd);
                }
            }
        });
    }

    File getFileForPoint(Point mousePoint) {
        TreePath path = this.TREE.getPathForLocation(mousePoint.x, mousePoint.y);
        if (path == null) {
            return null;
        }
        LibraryTreeNode node = (LibraryTreeNode)path.getLastPathComponent();
        AbstractFileHolder fh = node.getFileHolder();
        File file = fh.getFile();
        if (file.isDirectory()) {
            return file;
        }
        return null;
    }

    boolean droppingToIncompleteFolder(Point mousePoint) {
        File f = this.getFileForPoint(mousePoint);
        if (f == null) {
            return false;
        }
        return f.getName().equals("Incomplete");
    }

    File getSelectedDirectory() {
        LibraryTreeNode selectedNode = (LibraryTreeNode)this.TREE.getLastSelectedPathComponent();
        if (selectedNode == null) {
            return null;
        }
        return selectedNode.getFileHolder().getFile();
    }

    File[] getSharedDirectories() {
        int length = this.ROOT_NODE.getChildCount();
        ArrayList<File> newFiles = new ArrayList<File>();
        for (int i = 0; i < length; ++i) {
            File f;
            LibraryTreeNode curNode = (LibraryTreeNode)this.ROOT_NODE.getChildAt(i);
            AbstractFileHolder fh = curNode.getFileHolder();
            if (this.isIncompleteDirectory(curNode) || this.isSavedDirectory(curNode) || !(f = fh.getFile()).isDirectory()) continue;
            newFiles.add(f);
        }
        File[] files = new File[newFiles.size()];
        for (int r = 0; r < newFiles.size(); ++r) {
            files[r] = (File)newFiles.get(r);
        }
        return files;
    }

    void setSelectionRow(int row) {
        this.TREE.setSelectionRow(row);
    }

    boolean parentIsSelected(File parent) {
        LibraryTreeNode node = (LibraryTreeNode)this.TREE.getLastSelectedPathComponent();
        if (node == null) {
            return false;
        }
        return node.getFileHolder().matchesFile(parent);
    }

    void clear() {
        this.ROOT_NODE.removeAllChildren();
        this.addIncompleteDirectory();
        this.addSaveDirectory();
    }

    void unshareLibraryFolder() {
        LibraryTreeNode node = (LibraryTreeNode)this.TREE.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (this.incompleteDirectoryIsSelected()) {
            this.showIncompleteFolderMessage("delete");
        } else if (!node.getLibraryTreeNodeParent().isRoot()) {
            GUIMediator.showMessage("MESSAGE_CANNOT_UNSHARE_SUBDIRS");
        } else {
            String msgKey = "MESSAGE_CONFIRM_UNSHARE_DIRECTORY";
            int response = GUIMediator.showYesNoMessage(msgKey, QuestionsHandler.UNSHARE_DIRECTORY);
            if (response != 101) {
                return;
            }
            this.TREE_MODEL.removeNodeFromParent(node);
            this.LIBRARY_MEDIATOR.handleRootSharedDirectoryChange();
        }
    }

    boolean incompleteDirectoryIsSelected() {
        LibraryTreeNode node = (LibraryTreeNode)this.TREE.getLastSelectedPathComponent();
        if (node == null) {
            return false;
        }
        return this.isIncompleteDirectory(node);
    }

    boolean savedDirectoryIsSelected() {
        LibraryTreeNode node = (LibraryTreeNode)this.TREE.getLastSelectedPathComponent();
        if (node == null) {
            return false;
        }
        return this.isSavedDirectory(node);
    }

    JTree getTree() {
        return this.TREE;
    }

    private boolean isIncompleteDirectory(LibraryTreeNode node) {
        return node == this.incompleteNode;
    }

    private boolean isSavedDirectory(LibraryTreeNode node) {
        return node == this.savedNode;
    }

    private void addIncompleteDirectory() {
        SettingFileHolder fh = new SettingFileHolder(SharingSettings.INCOMPLETE_DIRECTORY, GUIMediator.getStringResource("LIBRARY_TREE_INCOMPLETE_DIRECTORY"));
        this.incompleteNode = new LibraryTreeNode(fh, false);
        this.TREE_MODEL.insertNodeInto(this.incompleteNode, this.ROOT_NODE, 0);
        this.TREE_MODEL.reload(this.ROOT_NODE);
    }

    private void addSaveDirectory() {
        SettingFileHolder fh = new SettingFileHolder(SharingSettings.DIRECTORY_FOR_SAVING_FILES, GUIMediator.getStringResource("LIBRARY_TREE_SAVED_DIRECTORY"));
        this.savedNode = new LibraryTreeNode(fh, false);
        this.TREE_MODEL.insertNodeInto(this.savedNode, this.ROOT_NODE, 0);
        this.TREE_MODEL.reload(this.ROOT_NODE);
    }

    private void showIncompleteFolderMessage(String action) {
        String key1 = "MESSAGE_INCOMPLETE_DIRECTORY_START";
        String key2 = "MESSAGE_INCOMPLETE_DIRECTORY_END";
        GUIMediator.showError(key1, (Object)action, key2);
    }

    private void showFolderDeletionError(String folderName) {
        String key1 = "MESSAGE_UNABLE_TO_DELETE_DIRECTORY_START";
        String key2 = "MESSAGE_UNABLE_TO_CHANGE_DIRECTORY_END";
        String msg = "'" + folderName + "'.";
        GUIMediator.showError("MESSAGE_UNABLE_TO_DELETE_DIRECTORY_START", (Object)msg, "MESSAGE_UNABLE_TO_CHANGE_DIRECTORY_END");
    }

    private void handleDirectoryChange(LibraryTreeNode node) {
        if (node.getLibraryTreeNodeParent().isRoot()) {
            this.LIBRARY_MEDIATOR.handleRootSharedDirectoryChange();
        } else {
            this.LIBRARY_MEDIATOR.refresh();
        }
    }

    private void makePopupMenu() {
        JMenuItem unshareItem = new JMenuItem(GUIMediator.getStringResource("LIBRARY_TREE_UNSHARE_FOLDER_LABEL"));
        JMenuItem addPlayListItem = new JMenuItem(GUIMediator.getStringResource("LIBRARY_TREE_TO_PLAYLIST_FOLDER_LABEL"));
        unshareItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                LibraryTree.this.unshareLibraryFolder();
            }
        });
        addPlayListItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                LibraryTree.this.addPlayListEntries();
            }
        });
        this.DIRECTORY_POPUP.add(unshareItem);
        if (GUIMediator.isPlaylistVisible()) {
            this.DIRECTORY_POPUP.add(addPlayListItem);
        }
        MouseAdapter ml = new MouseAdapter(){

            public void checkPopUp(MouseEvent e) {
                int row = LibraryTree.this.TREE.getRowForLocation(e.getX(), e.getY());
                if (row == -1) {
                    return;
                }
                LibraryTree.this.TREE.setSelectionRow(row);
                if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                    boolean allowUnshare = !LibraryTree.this.incompleteDirectoryIsSelected() && !LibraryTree.this.savedDirectoryIsSelected();
                    LibraryTree.this.DIRECTORY_POPUP.getComponent(0).setEnabled(allowUnshare);
                    LibraryTree.this.DIRECTORY_POPUP.show(LibraryTree.this.TREE, e.getX(), e.getY());
                }
            }

            public void mouseClicked(MouseEvent e) {
                this.checkPopUp(e);
            }

            public void mousePressed(MouseEvent e) {
                this.checkPopUp(e);
            }
        };
        this.TREE.addMouseListener(ml);
    }

    private class SettingFileHolder
    extends AbstractFileHolder {
        private final FileSetting SETTING;
        private final String DISPLAY;

        SettingFileHolder(FileSetting setting, String name) {
            this.SETTING = setting;
            this.DISPLAY = name;
        }

        protected File getFile() {
            return this.SETTING.getValue();
        }

        protected boolean matchesFile(File file) {
            return this.getFile().equals(file);
        }

        public String toString() {
            return this.DISPLAY;
        }
    }

    private class RootNodeFileHolder
    extends AbstractFileHolder {
        private RootNodeFileHolder() {
        }

        protected File getFile() {
            return null;
        }

        protected boolean matchesFile(File file) {
            return false;
        }

        public String toString() {
            return "";
        }
    }

    private class InternalNodeFileHolder
    extends AbstractFileHolder {
        private final File FILE;

        InternalNodeFileHolder(File file) {
            this.FILE = file;
        }

        protected File getFile() {
            return this.FILE;
        }

        protected boolean matchesFile(File file) {
            return this.FILE.equals(file);
        }

        public String toString() {
            return this.FILE.getName();
        }
    }

    private abstract class AbstractFileHolder {
        private AbstractFileHolder() {
        }

        protected abstract File getFile();

        protected abstract boolean matchesFile(File var1);
    }

    private final class LibraryTreeNode
    extends DefaultMutableTreeNode
    implements FileTransfer {
        private AbstractFileHolder _holder;
        private final boolean hasParents;

        private LibraryTreeNode() {
            this._holder = new RootNodeFileHolder();
            this.hasParents = true;
        }

        private LibraryTreeNode(AbstractFileHolder holder) {
            this(holder, true);
        }

        private LibraryTreeNode(AbstractFileHolder holder, boolean hasParents) {
            super(holder);
            if (holder == null) {
                throw new NullPointerException("null holder in LibraryTreeNode");
            }
            this._holder = holder;
            this.hasParents = hasParents;
        }

        public File getFile() {
            return this._holder.getFile();
        }

        private AbstractFileHolder getFileHolder() {
            return this._holder;
        }

        private boolean isChild(File file) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                LibraryTreeNode curNode = (LibraryTreeNode)this.getChildAt(i);
                if (!curNode.hasParents) {
                    return false;
                }
                File curFile = curNode.getFileHolder().getFile();
                if (!curFile.equals(file)) continue;
                return true;
            }
            return false;
        }

        public void setUserObject(Object holder) {
            if (holder == null) {
                return;
            }
            if (!(holder instanceof AbstractFileHolder)) {
                throw new IllegalArgumentException("unexpected object: " + holder);
            }
            super.setUserObject(holder);
            this._holder = (AbstractFileHolder)holder;
        }

        private LibraryTreeNode getLibraryTreeNodeParent() {
            TreeNode parentNode = super.getParent();
            if (parentNode == null) {
                return null;
            }
            return (LibraryTreeNode)parentNode;
        }
    }

    private class LibraryTreeSelectionListener
    implements TreeSelectionListener {
        private LibraryTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            LibraryTreeNode node = (LibraryTreeNode)LibraryTree.this.TREE.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            if (!LibraryTree.this.incompleteDirectoryIsSelected() && !LibraryTree.this.savedDirectoryIsSelected()) {
                LibraryTree.this.LIBRARY_MEDIATOR.updateTableFiles(node.getFileHolder().getFile());
            } else {
                LibraryTree.this.LIBRARY_MEDIATOR.refresh();
            }
        }
    }
}

