/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.menu.Menu;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.util.Locale;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

abstract class AbstractMenu
implements Menu {
    static final Font FONT = new Font("Dialog", 0, 11);
    protected final JMenu MENU = new JMenu();
    private static Class _keyEventClass = null;

    protected AbstractMenu(String key) {
        String titleKey = "MENU_" + key + "_TITLE";
        String titleMnemonicKey = titleKey + "_MNEMONIC";
        this.MENU.setText(GUIMediator.getStringResource(titleKey));
        if (_keyEventClass == null) {
            try {
                _keyEventClass = Class.forName("java.awt.event.KeyEvent");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.MENU.setMnemonic(this.getCodeForCharKey(titleMnemonicKey));
        this.MENU.setFont(FONT);
    }

    public JMenu getMenu() {
        return this.MENU;
    }

    protected JMenuItem addMenuItem(String key, ActionListener listener) {
        String labelKey = "MENU_" + key;
        String accessKey = labelKey + "_ACCESSIBLE";
        String mnemonicKey = labelKey + "_MNEMONIC";
        String label = GUIMediator.getStringResource(labelKey);
        String access = GUIMediator.getStringResource(accessKey);
        int mnemonic = this.getCodeForCharKey(mnemonicKey);
        JMenuItem menuItem = new JMenuItem(label, mnemonic);
        menuItem.getAccessibleContext().setAccessibleDescription(access);
        menuItem.addActionListener(listener);
        menuItem.setFont(FONT);
        this.MENU.add(menuItem);
        return menuItem;
    }

    protected JMenuItem addToggleMenuItem(String key, ActionListener listener, boolean enabled) {
        String labelKey = "MENU_" + key;
        String accessKey = "MENU_" + key + "_ACCESSIBLE";
        String mnemonicKey = "MENU_" + key + "_MNEMONIC";
        String label = GUIMediator.getStringResource(labelKey);
        String access = GUIMediator.getStringResource(accessKey);
        int mnemonic = this.getCodeForCharKey(mnemonicKey);
        JMenuItem menuItem = CommonUtils.isMacOSX() ? new JRadioButtonMenuItem(label, enabled) : new JCheckBoxMenuItem(label, enabled);
        menuItem.setMnemonic(mnemonic);
        menuItem.getAccessibleContext().setAccessibleDescription(access);
        menuItem.addActionListener(listener);
        menuItem.setFont(FONT);
        this.MENU.add(menuItem);
        return menuItem;
    }

    protected void addSeparator() {
        this.MENU.addSeparator();
    }

    protected int getCodeForCharKey(String str) {
        int charCode = -1;
        String charStr = GUIMediator.getStringResource(str).toUpperCase(Locale.US);
        if (charStr.length() > 1) {
            return -1;
        }
        try {
            Field charField = _keyEventClass.getField("VK_" + charStr);
            charCode = charField.getInt(_keyEventClass);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return charCode;
    }
}

