/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MediaButton;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.mp3.AudioPlayer;
import com.limegroup.gnutella.gui.mp3.AudioPlayerListener;
import com.limegroup.gnutella.gui.mp3.BasicPlayer;
import com.limegroup.gnutella.gui.mp3.SongProgressBar;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MediaPlayerComponent
implements AudioPlayerListener,
RefreshListener,
ThemeObserver {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$gui$mp3$MediaPlayerComponent == null ? (class$com$limegroup$gnutella$gui$mp3$MediaPlayerComponent = MediaPlayerComponent.class$("com.limegroup.gnutella.gui.mp3.MediaPlayerComponent")) : class$com$limegroup$gnutella$gui$mp3$MediaPlayerComponent);
    private static MediaPlayerComponent INSTANCE = null;
    private final AudioPlayer PLAYER;
    private JProgressBar PROGRESS;
    private static final ProcessingQueue SONG_QUEUE = new ProcessingQueue("SongProcessor");
    private volatile File myCurrentPlayingFile = null;
    private volatile File nextSongToPlay = null;
    private static volatile boolean stopWasLast = false;
    private volatile int currBeginIndex = -1;
    private static final int STRING_SIZE_TO_SHOW = 24;
    private static final MediaButton PLAY_BUTTON = new MediaButton("MEDIA_PLAY_BUTTON_TIP", "play_up", "play_dn");
    private static final MediaButton PAUSE_BUTTON = new MediaButton("MEDIA_PAUSE_BUTTON_TIP", "pause_up", "pause_dn");
    private static final MediaButton STOP_BUTTON = new MediaButton("MEDIA_STOP_BUTTON_TIP", "stop_up", "stop_dn");
    private static final MediaButton FORWARD_BUTTON = new MediaButton("MEDIA_FORWARD_BUTTON_TIP", "forward_up", "forward_dn");
    private static final MediaButton REWIND_BUTTON = new MediaButton("MEDIA_REWIND_BUTTON_TIP", "rewind_up", "rewind_dn");
    private JPanel myMediaPanel = null;
    private String currentFileName;
    private final Object cfnLock = new Object();
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$mp3$MediaPlayerComponent;

    public static MediaPlayerComponent instance() {
        INSTANCE = new MediaPlayerComponent();
        return INSTANCE;
    }

    private MediaPlayerComponent() {
        this.PLAYER = new BasicPlayer();
        this.PLAYER.addAudioPlayerListener(this);
        GUIMediator.addRefreshListener(this);
        ThemeMediator.addThemeObserver(this);
    }

    public void updateTheme() {
        PLAY_BUTTON.updateTheme();
        PAUSE_BUTTON.updateTheme();
        STOP_BUTTON.updateTheme();
        FORWARD_BUTTON.updateTheme();
        REWIND_BUTTON.updateTheme();
        Dimension progressBarDimension = ThemeSettings.isNativeOSXTheme() ? new Dimension(110, 25) : new Dimension(110, 15);
        this.PROGRESS.setMaximumSize(progressBarDimension);
        this.PROGRESS.setPreferredSize(progressBarDimension);
        this.PROGRESS.setString(GUIMediator.getStringResource("MEDIA_PLAYER_DEFAULT_STRING"));
    }

    private JPanel constructMediaPanel() {
        BoxPanel retPanel = new BoxPanel(0);
        BoxPanel buttonPanel = new BoxPanel(0);
        int tempWidth = 0;
        int tempHeight = 0;
        tempHeight += PLAY_BUTTON.getIcon().getIconHeight() + 2;
        tempWidth += PLAY_BUTTON.getIcon().getIconWidth() + 2 + PAUSE_BUTTON.getIcon().getIconWidth() + 2 + STOP_BUTTON.getIcon().getIconWidth() + 2 + FORWARD_BUTTON.getIcon().getIconWidth() + 2 + REWIND_BUTTON.getIcon().getIconWidth() + 2;
        this.PROGRESS = new SongProgressBar();
        Dimension progressBarDimension = CommonUtils.isMacOSX() ? new Dimension(110, 25) : new Dimension(110, 15);
        this.PROGRESS.setMaximumSize(progressBarDimension);
        this.PROGRESS.setPreferredSize(progressBarDimension);
        this.PROGRESS.setString(GUIMediator.getStringResource("MEDIA_PLAYER_DEFAULT_STRING"));
        PLAY_BUTTON.addActionListener(new PlayListener());
        PAUSE_BUTTON.addActionListener(new PauseListener());
        STOP_BUTTON.addActionListener(new StopListener());
        FORWARD_BUTTON.addActionListener(new NextListener());
        REWIND_BUTTON.addActionListener(new BackListener());
        this.updatePBValue(0);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.setMaximumSize(new Dimension(tempWidth, tempHeight));
        buttonPanel.setMinimumSize(new Dimension(tempWidth, tempHeight));
        buttonPanel.add(REWIND_BUTTON);
        buttonPanel.add(PLAY_BUTTON);
        buttonPanel.add(PAUSE_BUTTON);
        buttonPanel.add(STOP_BUTTON);
        buttonPanel.add(FORWARD_BUTTON);
        buttonPanel.add(Box.createHorizontalGlue());
        retPanel.add(Box.createVerticalGlue());
        retPanel.add(buttonPanel);
        retPanel.add(this.PROGRESS);
        retPanel.add(Box.createVerticalGlue());
        BoxPanel tempPanel = retPanel;
        retPanel = new BoxPanel(0);
        retPanel.add(Box.createHorizontalGlue());
        retPanel.add(tempPanel);
        return retPanel;
    }

    public JPanel getMediaPanel() {
        if (this.myMediaPanel == null) {
            this.myMediaPanel = this.constructMediaPanel();
        }
        return this.myMediaPanel;
    }

    public static void playSongImmediately(File f) {
        if (INSTANCE == null || f == null) {
            return;
        }
        stopWasLast = false;
        if (!MediaPlayerComponent.isPlaying(f)) {
            INSTANCE.setNextSong(f);
        }
    }

    public static void launchAudio(File toPlay) {
        if (INSTANCE == null || toPlay == null) {
            return;
        }
        if (MediaPlayerComponent.isPlaying(toPlay)) {
            return;
        }
        switch (MediaPlayerComponent.INSTANCE.PLAYER.getStatus()) {
            case 2: {
                INSTANCE.setNextSong(toPlay);
                break;
            }
            case 0: {
                if (GUIMediator.getPlayList().isSongPlaying()) {
                    GUIMediator.getPlayList().playSongNext(toPlay);
                    break;
                }
                INSTANCE.setNextSong(toPlay);
                break;
            }
            case 1: {
                INSTANCE.setNextSong(toPlay);
            }
        }
    }

    public static boolean isPlaying(File f) {
        return f != null && f.equals(MediaPlayerComponent.INSTANCE.myCurrentPlayingFile);
    }

    private void pauseSong() {
        if (this.PLAYER.getStatus() == 1) {
            if (this.PLAYER.getFrameSeek() != 0) {
                this.PLAYER.stop();
            } else {
                this.PLAYER.unpause();
            }
        } else {
            this.PLAYER.pause();
        }
    }

    private void setNextSong(File f) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setting next song to be: " + f);
        }
        this.nextSongToPlay = f;
        this.stopSong();
        if (f != null) {
            SONG_QUEUE.add(new SongBuffer());
        }
    }

    private File getNextSong() {
        return this.nextSongToPlay;
    }

    private void stopSong() {
        if (this.PLAYER.getStatus() != 2) {
            this.PLAYER.stop();
        }
    }

    private void unpause() {
        if (this.PLAYER.getStatus() == 1 && this.PLAYER.getFrameSeek() == 0) {
            this.PLAYER.unpause();
        }
    }

    public void playComplete() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("play completed for: " + this.myCurrentPlayingFile);
        }
        this.myCurrentPlayingFile = null;
        this.updatePBValue(this.PROGRESS.getMaximum());
        this.updatePBString("");
        if (stopWasLast || !GUIMediator.getPlayList().isContinuous()) {
            GUIMediator.getPlayList().playComplete(true);
        } else {
            GUIMediator.getPlayList().playComplete(false);
            if (this.getNextSong() == null) {
                this.setNextSong(GUIMediator.getPlayList().getFileToPlay());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpSeek(int lengthInFrames) {
        this.updatePBValue(0);
        this.updatePBMaximum(lengthInFrames);
        Object object = this.cfnLock;
        synchronized (object) {
            this.currentFileName = this.myCurrentPlayingFile.getName();
            if (this.currentFileName.length() > 24) {
                this.currentFileName = this.currentFileName + " *** " + this.currentFileName + " *** ";
            }
            this.updatePBString(this.currentFileName);
            this.currBeginIndex = -5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAudioPosition(int value) {
        this.updatePBValue(value);
        Object object = this.cfnLock;
        synchronized (object) {
            if (this.currentFileName == null) {
                return;
            }
            if (this.currentFileName.length() <= 24) {
                return;
            }
            Assert.that(this.currentFileName.length() > 48);
            this.currBeginIndex += 5;
            if (this.currBeginIndex + 24 >= this.currentFileName.length()) {
                this.currBeginIndex -= this.currentFileName.length() / 2;
            }
            this.updatePBString(this.currentFileName.substring(this.currBeginIndex, this.currBeginIndex + 24));
        }
    }

    public void refresh() {
        this.PLAYER.refresh();
    }

    private void updatePBMaximum(final int update) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MediaPlayerComponent.this.PROGRESS.setMaximum(update);
            }
        });
    }

    private void updatePBString(final String update) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MediaPlayerComponent.this.PROGRESS.setString(update);
            }
        });
    }

    private void updatePBValue(final int update) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    MediaPlayerComponent.this.PROGRESS.setValue(update);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SongBuffer
    implements Runnable {
        private SongBuffer() {
        }

        public void run() {
            if (MediaPlayerComponent.this.getNextSong() == null) {
                LOG.trace("no next song, leaving.");
                return;
            }
            while (MediaPlayerComponent.this.PLAYER.getStatus() != 2) {
                LOG.trace("player isn't stopped, sleeping.");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ignored) {}
            }
            if (MediaPlayerComponent.isPlaying(MediaPlayerComponent.this.getNextSong())) {
                LOG.trace("already playing requested song, leaving.");
                return;
            }
            while (MediaPlayerComponent.this.myCurrentPlayingFile != null) {
                LOG.trace("player is still completing something, sleeping...");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ignored) {}
            }
            File playFile = null;
            while (playFile != MediaPlayerComponent.this.getNextSong()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("new song, setting as: " + MediaPlayerComponent.this.getNextSong() + " and waiting for changes...");
                }
                playFile = MediaPlayerComponent.this.getNextSong();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ignored) {}
            }
            if (playFile == null) {
                LOG.debug("song selection cancelled, leaving.");
                return;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("starting song: " + playFile);
            }
            MediaPlayerComponent.this.myCurrentPlayingFile = playFile;
            MediaPlayerComponent.this.setNextSong(null);
            try {
                if (!MediaPlayerComponent.this.PLAYER.play(playFile)) {
                    MediaPlayerComponent.this.myCurrentPlayingFile = null;
                    return;
                }
                GUIMediator.getPlayList().playStarted();
            }
            catch (IOException ioe) {
                MediaPlayerComponent.this.myCurrentPlayingFile = null;
                ErrorService.error(ioe);
            }
        }
    }

    private class PauseListener
    implements ActionListener {
        private PauseListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            MediaPlayerComponent.this.pauseSong();
        }
    }

    private class BackListener
    implements ActionListener {
        private BackListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            if (MediaPlayerComponent.this.PLAYER.getStatus() != 2) {
                GUIMediator.getPlayList().setBackwardsMode();
                if (MediaPlayerComponent.this.PLAYER.getStatus() == 1) {
                    MediaPlayerComponent.this.PLAYER.unpause();
                }
                MediaPlayerComponent.this.stopSong();
            }
        }
    }

    private class NextListener
    implements ActionListener {
        private NextListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            if (MediaPlayerComponent.this.PLAYER.getStatus() != 2) {
                if (MediaPlayerComponent.this.PLAYER.getStatus() == 1) {
                    MediaPlayerComponent.this.PLAYER.unpause();
                }
                MediaPlayerComponent.this.stopSong();
            }
        }
    }

    private class StopListener
    implements ActionListener {
        private StopListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            stopWasLast = true;
            MediaPlayerComponent.this.stopSong();
        }
    }

    private class PlayListener
    implements ActionListener {
        private PlayListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            stopWasLast = false;
            switch (MediaPlayerComponent.this.PLAYER.getStatus()) {
                case 1: {
                    MediaPlayerComponent.this.unpause();
                    break;
                }
                case 2: {
                    MediaPlayerComponent.this.setNextSong(GUIMediator.getPlayList().getFileToPlay());
                }
            }
        }
    }
}

