/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.bugs.LocalClientInfo;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.BugSettings;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class BugsPaneItem
extends AbstractPaneItem {
    private static final String ALWAYS_SEND = "ERROR_INTERNAL_ALWAYS_SEND";
    private static final String ALWAYS_REVIEW = "ERROR_INTERNAL_ALWAYS_REVIEW";
    private static final String ALWAYS_DISCARD = "ERROR_INTERNAL_ALWAYS_DISCARD";
    private static final String VIEW_EXAMPLE = GUIMediator.getStringResource("OPTIONS_BUGS_VIEW_EXAMPLE");
    private final JRadioButton SEND_BOX = new JRadioButton();
    private final JRadioButton REVIEW_BOX = new JRadioButton();
    private final JRadioButton DISCARD_BOX = new JRadioButton();
    private final ButtonGroup BGROUP = new ButtonGroup();

    public BugsPaneItem(String key) {
        super(key);
        LabeledComponent comp1 = new LabeledComponent(ALWAYS_SEND, this.SEND_BOX, 120);
        LabeledComponent comp2 = new LabeledComponent(ALWAYS_REVIEW, this.REVIEW_BOX, 120);
        LabeledComponent comp3 = new LabeledComponent(ALWAYS_DISCARD, this.DISCARD_BOX, 120);
        JButton example = new JButton(VIEW_EXAMPLE);
        example.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Exception e = new Exception("Example Bug");
                LocalClientInfo info = new LocalClientInfo(e, Thread.currentThread(), "Example", false);
                JTextArea textArea = new JTextArea(info.toBugReport());
                textArea.setColumns(50);
                textArea.setEditable(false);
                JScrollPane scroller = new JScrollPane(textArea);
                scroller.setBorder(BorderFactory.createEtchedBorder());
                scroller.setPreferredSize(new Dimension(500, 200));
                MessageService.instance().showMessage(scroller);
            }
        });
        this.BGROUP.add(this.SEND_BOX);
        this.BGROUP.add(this.REVIEW_BOX);
        this.BGROUP.add(this.DISCARD_BOX);
        this.add(example);
        this.add(comp1.getComponent());
        this.add(comp2.getComponent());
        this.add(comp3.getComponent());
    }

    public void initOptions() {
        if (BugSettings.IGNORE_ALL_BUGS.getValue()) {
            this.BGROUP.setSelected(this.DISCARD_BOX.getModel(), true);
        } else if (BugSettings.USE_BUG_SERVLET.getValue()) {
            this.BGROUP.setSelected(this.SEND_BOX.getModel(), true);
        } else {
            this.BGROUP.setSelected(this.REVIEW_BOX.getModel(), true);
        }
    }

    public boolean applyOptions() throws IOException {
        ButtonModel bm = this.BGROUP.getSelection();
        if (bm.equals(this.DISCARD_BOX.getModel())) {
            BugSettings.IGNORE_ALL_BUGS.setValue(true);
        } else if (bm.equals(this.SEND_BOX.getModel())) {
            BugSettings.IGNORE_ALL_BUGS.setValue(false);
            BugSettings.USE_BUG_SERVLET.setValue(true);
        } else {
            BugSettings.IGNORE_ALL_BUGS.setValue(false);
            BugSettings.USE_BUG_SERVLET.setValue(false);
        }
        return false;
    }

    public boolean isDirty() {
        if (this.BGROUP.getSelection().equals(this.DISCARD_BOX.getModel())) {
            return !BugSettings.IGNORE_ALL_BUGS.getValue();
        }
        if (this.BGROUP.getSelection().equals(this.SEND_BOX.getModel())) {
            return BugSettings.IGNORE_ALL_BUGS.getValue() || !BugSettings.USE_BUG_SERVLET.getValue();
        }
        return BugSettings.IGNORE_ALL_BUGS.getValue() || BugSettings.USE_BUG_SERVLET.getValue();
    }
}

