/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.DaapManager;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.DaapSettings;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public final class DaapSupportPaneItem
extends AbstractPaneItem {
    private final String DAAP_ENABLED_LABEL = "OPTIONS_ITUNES_DAAP_SUPPORT_DAAP_ENABLED_LABEL";
    private final String USE_BIO_LABEL = "OPTIONS_ITUNES_DAAP_SUPPORT_USE_BIO_LABEL";
    private final String SERVICE_NAME_LABEL = "OPTIONS_ITUNES_DAAP_SUPPORT_SERVICE_NAME_LABEL";
    private final JCheckBox DAAP_ENABLED = new JCheckBox();
    private final JCheckBox USE_BIO = new JCheckBox();
    private final JTextField SERVICE_NAME = new SizedTextField();

    public DaapSupportPaneItem(String key) {
        super(key);
        LabeledComponent comp = new LabeledComponent("OPTIONS_ITUNES_DAAP_SUPPORT_DAAP_ENABLED_LABEL", this.DAAP_ENABLED, 120);
        this.add(comp.getComponent());
        this.add(this.getVerticalSeparator());
        comp = new LabeledComponent("OPTIONS_ITUNES_DAAP_SUPPORT_USE_BIO_LABEL", this.USE_BIO, 120);
        this.add(comp.getComponent());
        this.add(this.getVerticalSeparator());
        this.add(this.getVerticalSeparator());
        comp = new LabeledComponent("OPTIONS_ITUNES_DAAP_SUPPORT_SERVICE_NAME_LABEL", this.SERVICE_NAME, 130);
        this.add(comp.getComponent());
    }

    public void initOptions() {
        this.DAAP_ENABLED.setSelected(DaapSettings.DAAP_ENABLED.getValue() && DaapManager.instance().isServerRunning());
        this.USE_BIO.setSelected(!DaapSettings.DAAP_USE_NIO.getValue());
        this.SERVICE_NAME.setText(DaapSettings.DAAP_SERVICE_NAME.getValue());
    }

    public boolean applyOptions() throws IOException {
        boolean prevEnabled = DaapSettings.DAAP_ENABLED.getValue();
        boolean prevUseNIO = DaapSettings.DAAP_USE_NIO.getValue();
        String prevServiceName = DaapSettings.DAAP_SERVICE_NAME.getValue();
        String serviceName = this.SERVICE_NAME.getText().trim();
        if (serviceName.length() == 0 && this.DAAP_ENABLED.isSelected()) {
            throw new IOException();
        }
        DaapSettings.DAAP_ENABLED.setValue(this.DAAP_ENABLED.isSelected());
        DaapSettings.DAAP_USE_NIO.setValue(!this.USE_BIO.isSelected());
        DaapSettings.DAAP_SERVICE_NAME.setValue(serviceName);
        DaapSettings.DAAP_LIBRARY_NAME.setValue(serviceName);
        try {
            if (this.DAAP_ENABLED.isSelected()) {
                if (!prevEnabled || !this.USE_BIO.isSelected() != prevUseNIO) {
                    DaapManager.instance().restart();
                } else if (!serviceName.equals(prevServiceName)) {
                    DaapManager.instance().updateService();
                }
            } else if (prevEnabled) {
                DaapManager.instance().stop();
            }
        }
        catch (IOException err) {
            DaapSettings.DAAP_ENABLED.setValue(prevEnabled);
            DaapSettings.DAAP_USE_NIO.setValue(prevUseNIO);
            DaapSettings.DAAP_SERVICE_NAME.setValue(prevServiceName);
            DaapSettings.DAAP_LIBRARY_NAME.setValue(prevServiceName);
            DaapManager.instance().stop();
            this.initOptions();
            throw err;
        }
        return false;
    }

    public boolean isDirty() {
        return DaapSettings.DAAP_ENABLED.getValue() != this.DAAP_ENABLED.isSelected() || DaapSettings.DAAP_USE_NIO.getValue() == this.USE_BIO.isSelected() || !DaapSettings.DAAP_SERVICE_NAME.getValue().equals(this.SERVICE_NAME.getText()) || !DaapSettings.DAAP_LIBRARY_NAME.getValue().equals(this.SERVICE_NAME.getText());
    }
}

