/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableLineFilter;
import com.limegroup.gnutella.xml.LimeXMLDocument;

class FieldFilter
implements TableLineFilter {
    private final String SCHEMA;
    private final String FIELD;
    private final String VALUE;

    FieldFilter(String schema, String field, String value) {
        if (schema == null) {
            throw new NullPointerException("null schema");
        }
        if (field == null) {
            throw new NullPointerException("null field");
        }
        if (value == null) {
            throw new NullPointerException("null value");
        }
        this.SCHEMA = schema;
        this.FIELD = field;
        this.VALUE = value;
    }

    public boolean allow(TableLine line) {
        LimeXMLDocument doc = line.getXMLDocument();
        return doc != null && this.SCHEMA.equals(doc.getSchema().getDescription()) && this.VALUE.equalsIgnoreCase(doc.getValue(this.FIELD));
    }

    public boolean equals(Object o) {
        if (!(o instanceof FieldFilter)) {
            return false;
        }
        FieldFilter other = (FieldFilter)o;
        return this.SCHEMA.equals(other.SCHEMA) && this.FIELD.equals(other.FIELD) && this.VALUE.equals(other.VALUE);
    }
}

