/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.DisplayManager;
import com.limegroup.gnutella.gui.tables.IconAndNameHolder;
import com.limegroup.gnutella.xml.LimeXMLProperties;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import com.limegroup.gnutella.xml.XMLStringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class NamedMediaType
implements IconAndNameHolder,
Comparable {
    private static final Map CACHED_TYPES = new HashMap();
    private final MediaType _mediaType;
    private final String _name;
    private final Icon _icon;
    private final LimeXMLSchema _schema;

    public NamedMediaType(MediaType mt, LimeXMLSchema schema) {
        if (mt == null) {
            throw new NullPointerException("Null media type.");
        }
        this._mediaType = mt;
        this._schema = schema;
        this._name = NamedMediaType.constructName(this._mediaType, this._schema);
        this._icon = this.getIcon(this._mediaType, this._schema);
    }

    public int compareTo(Object o) {
        NamedMediaType other = (NamedMediaType)o;
        return this._name.compareTo(other._name);
    }

    public String getName() {
        return this._name;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public String toString() {
        return this._name;
    }

    public MediaType getMediaType() {
        return this._mediaType;
    }

    public LimeXMLSchema getSchema() {
        return this._schema;
    }

    public static NamedMediaType getFromDescription(String description) {
        NamedMediaType type = (NamedMediaType)CACHED_TYPES.get(description);
        if (type != null) {
            return type;
        }
        type = new NamedMediaType(new MediaType(description), null);
        CACHED_TYPES.put(description, type);
        return type;
    }

    public static NamedMediaType getFromExtension(String extension) {
        MediaType mt = MediaType.getMediaTypeForExtension(extension);
        if (mt == null) {
            return null;
        }
        String description = mt.getMimeType();
        return NamedMediaType.getFromDescription(description);
    }

    public static List getAllNamedMediaTypes() {
        LinkedList<NamedMediaType> allSchemas = new LinkedList<NamedMediaType>();
        Iterator i = LimeXMLSchemaRepository.instance().getAvailableSchemas().iterator();
        while (i.hasNext()) {
            LimeXMLSchema schema = (LimeXMLSchema)i.next();
            allSchemas.add(NamedMediaType.getFromSchema(schema));
        }
        MediaType[] allTypes = MediaType.getDefaultMediaTypes();
        for (int i2 = 0; i2 < allTypes.length; ++i2) {
            if (NamedMediaType.containsMediaType(allSchemas, allTypes[i2])) continue;
            allSchemas.add(NamedMediaType.getFromMediaType(allTypes[i2]));
        }
        return allSchemas;
    }

    private static NamedMediaType getFromSchema(LimeXMLSchema schema) {
        String description = schema.getDescription();
        NamedMediaType type = (NamedMediaType)CACHED_TYPES.get(description);
        if (type != null) {
            return type;
        }
        MediaType mt = !MediaType.isDefaultType(description) ? new MediaType(description) : MediaType.getMediaTypeForSchema(description);
        type = new NamedMediaType(mt, schema);
        CACHED_TYPES.put(description, type);
        return type;
    }

    private static NamedMediaType getFromMediaType(MediaType media) {
        String description = media.getMimeType();
        NamedMediaType type = (NamedMediaType)CACHED_TYPES.get(description);
        if (type != null) {
            return type;
        }
        type = new NamedMediaType(media, null);
        CACHED_TYPES.put(description, type);
        return type;
    }

    private static boolean containsMediaType(List named, MediaType type) {
        Iterator i = named.iterator();
        while (i.hasNext()) {
            if (!((NamedMediaType)i.next()).getMediaType().equals(type)) continue;
            return true;
        }
        return false;
    }

    private Icon getIcon(MediaType type, LimeXMLSchema schema) {
        ImageIcon icon;
        if (type == MediaType.getAnyTypeMediaType()) {
            icon = GUIMediator.getThemeImage("lime");
        } else {
            String location = LimeXMLProperties.instance().getXMLImagesDir() + type.getMimeType();
            icon = GUIMediator.getImageFromPath(location);
        }
        icon.setDescription(this.getName());
        return icon;
    }

    private static String constructName(MediaType type, LimeXMLSchema schema) {
        String name = null;
        if (type.isDefault()) {
            String key = type.getDescriptionKey();
            try {
                if (key != null) {
                    name = GUIMediator.getStringResource(key);
                }
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
            if (name == null) {
                name = LimeXMLUtils.capitalizeFirst(type.getMimeType());
            }
        } else {
            List fields = schema.getCanonicalizedFields();
            String field = ((SchemaFieldInfo)fields.get(0)).getCanonicalizedFieldName();
            List nodes = XMLStringUtils.split(field);
            String root = (String)nodes.get(0);
            String element = (String)nodes.get(1);
            String key = root + "__" + element;
            name = DisplayManager.instance().getDisplayName(key, schema.getDescription());
        }
        return name;
    }
}

