/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.DisplayManager;
import com.limegroup.gnutella.util.StringUtils;
import java.util.MissingResourceException;

class Selector {
    public static final int SCHEMA = 1;
    public static final int FIELD = 2;
    public static final int PROPERTY = 3;
    private static final String S_SCHEMA = "schema";
    private static final String S_FIELD = "field";
    private static final String S_PROPERTY = "property";
    private final String _SCHEMA;
    private final String _VALUE;
    private final int _TYPE;
    private boolean _minimized = false;

    private Selector(String schema, String value, int type) {
        this._SCHEMA = schema;
        this._VALUE = value;
        this._TYPE = type;
    }

    public static Selector createSchemaSelector() {
        return new Selector("", "", 1);
    }

    public static Selector createFieldSelector(String schema, String field) {
        return new Selector(schema, field, 2);
    }

    public static Selector createPropertySelector(String property) {
        return new Selector("", property, 3);
    }

    /*
     * WARNING - void declaration
     */
    public static Selector createFromString(String value) {
        void var5_6;
        Selector selector;
        String right;
        String left;
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        int pipe = (value = value.toLowerCase()).indexOf("|");
        if (pipe == -1 || pipe == value.length()) {
            left = value.trim();
            right = "";
        } else {
            left = value.substring(0, pipe).trim();
            right = value.substring(pipe + 1).trim();
        }
        String[] data = StringUtils.split(left, ",");
        if (data.length == 0) {
            throw new IllegalArgumentException(value);
        }
        for (int i = 0; i < data.length; ++i) {
            data[i] = data[i].trim();
        }
        if (S_SCHEMA.equals(data[0])) {
            selector = Selector.createSchemaSelector();
            if (data.length != 1) {
                throw new IllegalArgumentException(value);
            }
        } else if (S_FIELD.equals(data[0])) {
            if (data.length != 3) {
                throw new IllegalArgumentException(value);
            }
            String schema = data[1];
            String info = data[2];
            selector = Selector.createFieldSelector(schema, info);
        } else if (S_PROPERTY.equals(data[0])) {
            if (data.length != 2) {
                throw new IllegalArgumentException(value);
            }
            String info = data[1].toUpperCase();
            selector = Selector.createPropertySelector(info);
        } else {
            throw new IllegalArgumentException(value);
        }
        data = StringUtils.split(right, ",");
        for (int i = 0; i < data.length; ++i) {
            data[i] = data[i].trim();
        }
        if (data.length > 0) {
            var5_6.setMinimized(data[0].equals("true"));
        }
        return var5_6;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        switch (this._TYPE) {
            case 1: {
                String value = S_SCHEMA;
                break;
            }
            case 2: {
                String value = "field, " + this._SCHEMA + ", " + this._VALUE;
                break;
            }
            case 3: {
                String value = "property, " + this._VALUE;
                break;
            }
            default: {
                throw new IllegalStateException("invalid type: " + this._TYPE);
            }
        }
        return (String)var1_1 + " | " + this._minimized;
    }

    public boolean isMinimized() {
        return this._minimized;
    }

    public void setMinimized(boolean minimized) {
        this._minimized = minimized;
    }

    public String getTitle() {
        switch (this._TYPE) {
            case 1: {
                return GUIMediator.getStringResource("SEARCH_FILTER_MEDIA");
            }
            case 2: {
                return DisplayManager.instance().getDisplayName(this._VALUE, this._SCHEMA);
            }
            case 3: {
                try {
                    return GUIMediator.getStringResource(this._VALUE);
                }
                catch (MissingResourceException mse) {
                    return this._VALUE;
                }
            }
        }
        throw new IllegalArgumentException("invalid type: " + this._TYPE);
    }

    public boolean isSchemaSelector() {
        return this._TYPE == 1;
    }

    public boolean isFieldSelector() {
        return this._TYPE == 2;
    }

    public boolean isPropertySelector() {
        return this._TYPE == 3;
    }

    public int getSelectorType() {
        return this._TYPE;
    }

    public String getSchema() {
        if (this._TYPE != 2) {
            throw new IllegalStateException("invalid type: " + this._TYPE);
        }
        return this._SCHEMA;
    }

    public String getValue() {
        if (this._TYPE != 2 && this._TYPE != 3) {
            throw new IllegalStateException("invalid type: " + this._TYPE);
        }
        return this._VALUE;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Selector) {
            Selector f = (Selector)o;
            return f._TYPE == this._TYPE && f._SCHEMA.equals(this._SCHEMA) && f._VALUE.equals(this._VALUE);
        }
        return false;
    }

    public int hashCode() {
        return this._TYPE;
    }
}

