/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.AquaSortArrowIcon;
import com.limegroup.gnutella.gui.tables.JSortTable;
import com.limegroup.gnutella.gui.tables.SortArrowIcon;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public final class SortHeaderRenderer
extends DefaultTableCellRenderer
implements ThemeObserver {
    public static Icon ASCENDING;
    public static Icon DESCENDING;
    private boolean allowIcon = true;

    private static void updateIcons() {
        if (CommonUtils.isMacOSX() || ThemeSettings.isWindowsTheme()) {
            ASCENDING = AquaSortArrowIcon.getAscendingIcon();
            DESCENDING = AquaSortArrowIcon.getDescendingIcon();
        } else {
            ASCENDING = SortArrowIcon.getAscendingIcon();
            DESCENDING = SortArrowIcon.getDescendingIcon();
        }
    }

    public SortHeaderRenderer() {
        this.setHorizontalAlignment(0);
        this.setIconTextGap(2);
        this.setHorizontalTextPosition(2);
        ThemeMediator.addThemeObserver(this);
    }

    public void updateTheme() {
        SortHeaderRenderer.updateIcons();
    }

    public void setAllowIcon(boolean allow) {
        this.allowIcon = allow;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        int index = -1;
        boolean ascending = true;
        boolean isPressed = false;
        if (this.allowIcon && table instanceof JSortTable) {
            JSortTable sortTable = (JSortTable)((Object)table);
            index = sortTable.getSortedColumnIndex();
            ascending = sortTable.isSortedColumnAscending();
            isPressed = sortTable.getPressedColumnIndex() == col;
        }
        JLabel renderer = this;
        if (table != null) {
            JTableHeader header = table.getTableHeader();
            try {
                TableCellRenderer tcr;
                Component c;
                if (header != null && (c = (tcr = header.getDefaultRenderer()).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col)) instanceof JLabel) {
                    renderer = (JLabel)c;
                    renderer.setFont(header.getFont());
                    renderer.setBackground(header.getBackground());
                    renderer.setForeground(header.getForeground());
                }
            }
            catch (NullPointerException ignored) {
                // empty catch block
            }
        }
        if (value instanceof Icon) {
            renderer.setIcon((Icon)value);
            renderer.setText(null);
        } else {
            Icon icon = col == index ? (ascending ? ASCENDING : DESCENDING) : null;
            renderer.setIcon(icon);
            renderer.setText(value == null ? null : value.toString());
        }
        if (renderer != this) {
            renderer.setHorizontalAlignment(0);
            renderer.setIconTextGap(2);
            renderer.setHorizontalTextPosition(2);
        }
        Border pressed = UIManager.getBorder("TableHeader.cellPressedBorder");
        Border normal = UIManager.getBorder("TableHeader.cellBorder");
        Border active = renderer.getBorder();
        if (active == pressed || active == normal || active == null) {
            if (isPressed) {
                renderer.setBorder(pressed == null ? normal : pressed);
            } else {
                renderer.setBorder(normal);
            }
        }
        return renderer;
    }

    static {
        SortHeaderRenderer.updateIcons();
    }
}

