/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml;

import com.limegroup.gnutella.gui.AutoCompleteTextField;
import com.limegroup.gnutella.gui.xml.ComboBoxValue;
import com.limegroup.gnutella.gui.xml.IndentingPanel;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;

public class InputPanel
extends IndentingPanel {
    private final LimeXMLSchema SCHEMA;

    public InputPanel(LimeXMLSchema schema, ActionListener listener, Document document, UndoManager undoer) {
        this(schema, listener, document, undoer, false, false, true);
    }

    public InputPanel(LimeXMLSchema schema, ActionListener listener, Document document, UndoManager undoer, boolean expand, boolean indent, boolean search) {
        super(schema, listener, document, undoer, expand, indent, search);
        this.SCHEMA = schema;
    }

    public String getSchemaURI() {
        return this.SCHEMA.getSchemaURI();
    }

    public String getInput() {
        return this.getInput(false);
    }

    public String getInput(boolean normalize) {
        LinkedList<NameValue> namValList = new LinkedList<NameValue>();
        List list = this.SCHEMA.getCanonicalizedFields();
        for (int i = 0; i < list.size(); ++i) {
            SchemaFieldInfo field = (SchemaFieldInfo)list.get(i);
            String key = field.getCanonicalizedFieldName();
            JComponent comp = this.getField(key);
            String value = "";
            if (comp instanceof JTextField) {
                JTextField theField = (JTextField)comp;
                value = theField.getText();
            } else if (comp instanceof JComboBox) {
                JComboBox theBox = (JComboBox)comp;
                value = ((ComboBoxValue)theBox.getSelectedItem()).getValue();
            }
            if (value == null || value.equals("")) continue;
            NameValue namValue = new NameValue(key, normalize ? I18NConvert.instance().getNorm(value) : value);
            namValList.add(namValue);
        }
        String schemaURI = this.SCHEMA.getSchemaURI();
        String str = this.constructXML(namValList, schemaURI);
        return str;
    }

    public void storeInput() {
        List list = this.SCHEMA.getCanonicalizedFields();
        for (int i = 0; i < list.size(); ++i) {
            AutoCompleteTextField theField;
            SchemaFieldInfo field = (SchemaFieldInfo)list.get(i);
            String key = field.getCanonicalizedFieldName();
            JComponent comp = this.getField(key);
            if (!(comp instanceof AutoCompleteTextField) || (theField = (AutoCompleteTextField)comp).getText().equals("")) continue;
            theField.addToDictionary();
        }
    }

    public String getStandardQuery() {
        List list = this.SCHEMA.getCanonicalizedFields();
        StringBuffer retString = new StringBuffer();
        int numWords = 0;
        for (int i = 0; i < list.size() && numWords < 3; ++i) {
            SchemaFieldInfo field = (SchemaFieldInfo)list.get(i);
            String key = field.getCanonicalizedFieldName();
            JComponent comp = this.getField(key);
            String value = "";
            if (comp instanceof JTextField) {
                JTextField theField = (JTextField)comp;
                value = theField.getText();
            } else if (comp instanceof JComboBox) {
                JComboBox theBox = (JComboBox)comp;
                value = ((ComboBoxValue)theBox.getSelectedItem()).toString();
            }
            if (value == null || value.trim().length() <= 1) continue;
            retString.append(value + " ");
        }
        return retString.toString();
    }

    public String constructXML(List namValList, String uri) {
        if (namValList == null || namValList.isEmpty()) {
            return null;
        }
        return new LimeXMLDocument(namValList, uri).getXMLString();
    }
}

