/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.xml.ComboBoxValue;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorPanel;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.text.JTextComponent;

public abstract class MetaEditorTabbedPane
extends JTabbedPane {
    protected final FileDesc fd;
    protected final LimeXMLDocument document;
    protected final LimeXMLSchema schema;

    public MetaEditorTabbedPane(FileDesc fd, String uri) {
        this.fd = fd;
        SchemaReplyCollectionMapper map = SchemaReplyCollectionMapper.instance();
        LimeXMLReplyCollection collection = map.getReplyCollection(uri);
        LimeXMLSchemaRepository rep = LimeXMLSchemaRepository.instance();
        this.schema = rep.getSchema(uri);
        LimeXMLDocument storedDoc = null;
        Iterator i = fd.getLimeXMLDocuments().iterator();
        while (i.hasNext()) {
            LimeXMLDocument doc = (LimeXMLDocument)i.next();
            if (!this.schema.equals(doc.getSchema())) continue;
            storedDoc = doc;
            break;
        }
        this.document = storedDoc;
    }

    public FileDesc getFileDesc() {
        return this.fd;
    }

    public LimeXMLDocument getDocument() {
        return this.document;
    }

    public LimeXMLSchema getSchema() {
        return this.schema;
    }

    public String getInput() {
        ArrayList<NameValue> namValList = new ArrayList<NameValue>();
        int count = this.getTabCount();
        for (int i = 0; i < count; ++i) {
            MetaEditorPanel panel;
            Component tab = this.getComponentAt(i);
            if (!(tab instanceof MetaEditorPanel) || !(panel = (MetaEditorPanel)tab).hasChanged()) continue;
            panel.prepareSave();
            Iterator it = panel.getComponentIterator();
            while (it.hasNext()) {
                String cbvalue;
                JComboBox box;
                ComboBoxValue cbv;
                String name = (String)it.next();
                JComponent comp = panel.getComponent(name);
                String value = null;
                if (comp instanceof JTextComponent) {
                    value = ((JTextComponent)comp).getText().trim();
                } else if (comp instanceof JComboBox && (cbv = (ComboBoxValue)(box = (JComboBox)comp).getSelectedItem()) != null && (cbvalue = cbv.getValue()) != null) {
                    value = cbvalue.trim();
                }
                if (value == null || value.equals("")) continue;
                NameValue namValue = new NameValue(name, value);
                namValList.add(namValue);
            }
            Iterator j = panel.getUneditedFieldsIterator();
            while (j.hasNext()) {
                namValList.add((NameValue)j.next());
            }
        }
        if (namValList.isEmpty()) {
            return null;
        }
        return new LimeXMLDocument(namValList, this.getSchema().getSchemaURI()).getXMLString();
    }
}

