/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValueCollection;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.statistics.BandwidthStat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;

public final class HTTPUtils {
    private static final String CRLF = "\r\n";
    private static final String COLON_SPACE = ": ";
    private static final String COLON = ":";
    private static final String SLASH = "/";

    private HTTPUtils() {
    }

    public static void writeHeader(HTTPHeaderName name, String value, OutputStream os) throws IOException {
        if (name == null) {
            throw new NullPointerException("null name in writing http header");
        }
        if (value == null) {
            throw new NullPointerException("null value in writing http header: " + name);
        }
        if (os == null) {
            throw new NullPointerException("null os in writing http header: " + name);
        }
        String header = HTTPUtils.createHeader(name, value);
        os.write(header.getBytes());
        BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH.addData(header.length());
    }

    public static void writeHeader(HTTPHeaderName name, String value, Writer out) throws IOException {
        if (name == null) {
            throw new NullPointerException("null name in writing http header");
        }
        if (value == null) {
            throw new NullPointerException("null value in writing http header: " + name);
        }
        if (out == null) {
            throw new NullPointerException("null os in writing http header: " + name);
        }
        String header = HTTPUtils.createHeader(name, value);
        out.write(header);
        BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH.addData(header.length());
    }

    public static void writeHeader(HTTPHeaderName name, HTTPHeaderValue value, OutputStream os) throws IOException {
        if (name == null) {
            throw new NullPointerException("null name in writing http header");
        }
        if (value == null) {
            throw new NullPointerException("null value in writing http header: " + name);
        }
        if (os == null) {
            throw new NullPointerException("null os in writing http header: " + name);
        }
        String header = HTTPUtils.createHeader(name, value.httpStringValue());
        os.write(header.getBytes());
        BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH.addData(header.length());
    }

    public static void writeHeader(HTTPHeaderName name, HTTPHeaderValue value, Writer out) throws IOException {
        if (name == null) {
            throw new NullPointerException("null name in writing http header");
        }
        if (value == null) {
            throw new NullPointerException("null value in writing http header: " + name);
        }
        if (out == null) {
            throw new NullPointerException("null os in writing http header: " + name);
        }
        String header = HTTPUtils.createHeader(name, value.httpStringValue());
        out.write(header);
        BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH.addData(header.length());
    }

    private static String createHeader(HTTPHeaderName name, String valueStr) throws IOException {
        if (name == null || valueStr == null) {
            throw new NullPointerException("null value in creating http header");
        }
        String nameStr = name.httpStringValue();
        if (nameStr == null) {
            throw new NullPointerException("null value in creating http header");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(nameStr);
        sb.append(COLON_SPACE);
        sb.append(valueStr);
        sb.append(CRLF);
        return sb.toString();
    }

    public static String extractHeaderValue(String header) {
        int index = header.indexOf(COLON);
        if (index <= 0) {
            return null;
        }
        return header.substring(index + 1).trim();
    }

    public static void writeHeader(HTTPHeaderName name, int value, Writer writer) throws IOException {
        HTTPUtils.writeHeader(name, String.valueOf(value), writer);
    }

    public static void writeHeader(HTTPHeaderName name, int value, OutputStream stream) throws IOException {
        HTTPUtils.writeHeader(name, String.valueOf(value), stream);
    }

    public static void writeDate(Writer writer) throws IOException {
        HTTPUtils.writeHeader(HTTPHeaderName.DATE, HTTPUtils.getDateValue(), writer);
    }

    public static void writeDate(OutputStream stream) throws IOException {
        HTTPUtils.writeHeader(HTTPHeaderName.DATE, HTTPUtils.getDateValue(), stream);
    }

    public static void writeFeatures(Writer writer) throws IOException {
        Set features = HTTPUtils.getFeaturesValue();
        if (features.size() > 0) {
            HTTPUtils.writeHeader(HTTPHeaderName.FEATURES, (HTTPHeaderValue)new HTTPHeaderValueCollection(features), writer);
        }
    }

    public static void writeFeatures(OutputStream stream) throws IOException {
        Set features = HTTPUtils.getFeaturesValue();
        if (features.size() > 0) {
            HTTPUtils.writeHeader(HTTPHeaderName.FEATURES, (HTTPHeaderValue)new HTTPHeaderValueCollection(features), stream);
        }
    }

    private static Set getFeaturesValue() {
        HashSet<HTTPHeaderValue> features = new HashSet<HTTPHeaderValue>(4);
        features.add(ConstantHTTPHeaderValue.BROWSE_FEATURE);
        if (ChatSettings.CHAT_ENABLED.getValue()) {
            features.add(ConstantHTTPHeaderValue.CHAT_FEATURE);
        }
        features.add(ConstantHTTPHeaderValue.PUSH_LOCS_FEATURE);
        if (!RouterService.acceptedIncomingConnection() && UDPService.instance().canDoFWT()) {
            features.add(ConstantHTTPHeaderValue.FWT_PUSH_LOCS_FEATURE);
        }
        return features;
    }

    public static float parseFeatureToken(String token) throws ProblemReadingHeaderException {
        int slashIndex = token.indexOf(SLASH);
        if (slashIndex == -1 || slashIndex >= token.length() - 1) {
            throw new ProblemReadingHeaderException("invalid feature token");
        }
        String versionS = token.substring(slashIndex + 1);
        try {
            return Float.parseFloat(versionS);
        }
        catch (NumberFormatException bad) {
            throw new ProblemReadingHeaderException(bad);
        }
    }

    private static String getDateValue() {
        SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(new Date());
    }
}

