/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class LicenseCache {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$licenses$LicenseCache == null ? (class$com$limegroup$gnutella$licenses$LicenseCache = LicenseCache.class$("com.limegroup.gnutella.licenses.LicenseCache")) : class$com$limegroup$gnutella$licenses$LicenseCache);
    private static final long EXPIRY_TIME = 604800000L;
    private final File CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "licenses.cache");
    private Map licenses;
    private Map data;
    private static final LicenseCache INSTANCE = new LicenseCache();
    static /* synthetic */ Class class$com$limegroup$gnutella$licenses$LicenseCache;

    private LicenseCache() {
        this.deserialize();
    }

    public static LicenseCache instance() {
        return INSTANCE;
    }

    synchronized void addVerifiedLicense(License license) {
        this.licenses.put(license.getLicenseURI(), license);
    }

    synchronized void addData(Object key, Object value) {
        this.data.put(key, value);
    }

    synchronized License getLicense(String licenseString, URI licenseURI) {
        License license = (License)this.licenses.get(licenseURI);
        if (license != null) {
            return license.copy(licenseString, licenseURI);
        }
        return null;
    }

    synchronized Object getData(Object key) {
        return this.data.get(key);
    }

    synchronized boolean isVerifiedAndValid(URN urn, URI uri) {
        License license = (License)this.licenses.get(uri);
        return license != null && license.isValid(urn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void deserialize() {
        block22: {
            ObjectInputStream ois;
            block20: {
                ois = null;
                ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.CACHE_FILE)));
                HashMap map = (HashMap)ois.readObject();
                if (map != null) {
                    Iterator i = map.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry next = i.next();
                        Object key = next.getKey();
                        Object value = next.getValue();
                        if (key instanceof URI && value instanceof License) continue;
                        if (LOG.isWarnEnabled()) {
                            LOG.warn("Invalid k[" + key + "], v[" + value + "]");
                        }
                        i.remove();
                    }
                } else {
                    map = new HashMap();
                }
                this.licenses = map;
                this.data = (Map)ois.readObject();
                this.removeOldEntries();
                Object var8_8 = null;
                if (ois == null) break block20;
                try {
                    ois.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (this.licenses == null) {
                this.licenses = new HashMap();
            }
            if (this.data == null) {
                this.data = new HashMap();
            }
            break block22;
            {
                catch (Throwable t) {
                    LOG.error("Can't read licenses", t);
                    Object var8_9 = null;
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    if (this.licenses == null) {
                        this.licenses = new HashMap();
                    }
                    if (this.data == null) {
                        this.data = new HashMap();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (this.licenses == null) {
                    this.licenses = new HashMap();
                }
                if (this.data == null) {
                    this.data = new HashMap();
                }
                throw throwable;
            }
        }
    }

    private void removeOldEntries() {
        long cutoff = System.currentTimeMillis() - 604800000L;
        Iterator i = this.licenses.values().iterator();
        while (i.hasNext()) {
            License license = (License)i.next();
            if (license.getLastVerifiedTime() >= cutoff) continue;
            i.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void persistCache() {
        ObjectOutputStream oos = null;
        oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.CACHE_FILE)));
        oos.writeObject(this.licenses);
        oos.writeObject(this.data);
        oos.flush();
        Object var4_2 = null;
        if (oos == null) return;
        try {
            oos.close();
            return;
        }
        catch (IOException ignored) {}
        return;
        {
            catch (IOException e) {
                ErrorService.error(e);
                Object var4_3 = null;
                if (oos == null) return;
                try {
                    oos.close();
                    return;
                }
                catch (IOException ignored) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (oos == null) throw throwable;
            try {
                oos.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

