/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.metadata.AudioMetaData;
import com.limegroup.gnutella.metadata.MP3MetaData;
import com.limegroup.gnutella.util.CountingInputStream;
import com.limegroup.gnutella.util.IOUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class M4AMetaData
extends AudioMetaData {
    private static final int FTYP_ATOM = 1718909296;
    private static final int MOOV_ATOM = 1836019574;
    private static final int MVHD_ATOM = 1836476516;
    private static final int TRAK_ATOM = 1953653099;
    private static final int TKHD_ATOM = 1953196132;
    private static final int MDIA_ATOM = 1835297121;
    private static final int ESDS_ATOM = 1702061171;
    private static final int ALAC_ATOM = 1634492771;
    private static final int MDHD_ATOM = 1835296868;
    private static final int MINF_ATOM = 1835626086;
    private static final int DINF_ATOM = 1684631142;
    private static final int SMHD_ATOM = 1936549988;
    private static final int STBL_ATOM = 1937007212;
    private static final int STSD_ATOM = 1937011556;
    private static final int MP4A_ATOM = 1836069985;
    private static final int DRMS_ATOM = 1685220723;
    private static final int UDTA_ATOM = 1969517665;
    private static final int META_ATOM = 1835365473;
    private static final int HDLR_ATOM = 1751411826;
    private static final int STTS_ATOM = 0x73747473;
    private static final int STSC_ATOM = 1937011555;
    private static final int STSZ_ATOM = 1937011578;
    private static final int STCO_ATOM = 1937007471;
    private static final int ILST_ATOM = 1768715124;
    private static final int NAME_ATOM = -1452383891;
    private static final int ALBUM_ATOM = -1453233054;
    private static final int ARTIST_ATOM = -1455336876;
    private static final int DATE_ATOM = -1453039239;
    private static final int GENRE_ATOM = 1735291493;
    private static final int GENRE_ATOM_STANDARD = -1452841618;
    private static final int TRACK_ATOM = 1953655662;
    private static final int TRACK_ATOM_STANDARD = -1451986325;
    private static final int COMMENT_ATOM = -1453101708;
    private static final int DISK_ATOM = 1684632427;
    private static final int DATA_ATOM = 1684108385;
    private int _maxLength;

    public M4AMetaData(File f) throws IOException {
        super(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseFile(File f) throws IOException {
        FileInputStream fin = null;
        try {
            this._maxLength = (int)f.length();
            fin = new FileInputStream(f);
            this.positionMetaDataStream(fin);
            Map metaData = this.populateMetaDataMap(fin);
            byte[] current = (byte[])metaData.get(new Integer(-1452383891));
            this.setTitle(current == null ? "" : new String(current, "UTF-8"));
            current = (byte[])metaData.get(new Integer(-1455336876));
            this.setArtist(current == null ? "" : new String(current, "UTF-8"));
            current = (byte[])metaData.get(new Integer(-1453233054));
            this.setAlbum(current == null ? "" : new String(current, "UTF-8"));
            current = (byte[])metaData.get(new Integer(-1453101708));
            this.setComment(current == null ? "" : new String(current, "UTF-8"));
            current = (byte[])metaData.get(new Integer(1735291493));
            if (current != null) {
                if (current[3] == 1) {
                    String genre = new String(current, 8, current.length - 8, "UTF-8");
                    this.setGenre(genre);
                } else {
                    short genreShort = (short)(ByteOrder.beb2short(current, current.length - 2) - 1);
                    this.setGenre(MP3MetaData.getGenreString(genreShort));
                }
            }
            if ((current = (byte[])metaData.get(new Integer(-1453039239))) == null) {
                this.setYear("");
            } else {
                String year = new String(current, 8, current.length - 8);
                if (year.length() > 4) {
                    year = year.substring(0, 4);
                }
                this.setYear(year);
            }
            current = (byte[])metaData.get(new Integer(1953655662));
            if (current != null) {
                short trackShort = ByteOrder.beb2short(current, current.length - 6);
                this.setTrack(trackShort);
                short trackTotal = ByteOrder.beb2short(current, current.length - 4);
                this.setTotalTracks(trackTotal);
            }
            if ((current = (byte[])metaData.get(new Integer(1684632427))) != null) {
                short diskShort = ByteOrder.beb2short(current, current.length - 4);
                this.setDisk(diskShort);
                short diskTotal = ByteOrder.beb2short(current, current.length - 2);
                this.setTotalDisks(diskTotal);
            }
            Object var8_10 = null;
            if (fin == null) return;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (fin == null) throw throwable;
            try {
                fin.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fin.close();
            return;
        }
        catch (IOException ignored) {}
    }

    private void skipAtom(int atomType, DataInputStream in) throws IOException {
        IOUtils.ensureSkip(in, this.enterAtom(atomType, in));
    }

    private int enterAtom(int atomType, DataInputStream in) throws IOException {
        boolean extended = false;
        int size = in.readInt();
        if (size >= this._maxLength) {
            throw new IOException("invalid size field read");
        }
        int type = in.readInt();
        if (type != atomType) {
            throw new IOException("atom type mismatch, expected " + atomType + " got " + type);
        }
        if (size == 1) {
            extended = true;
            size = (int)in.readLong();
        }
        return size -= extended ? 16 : 8;
    }

    private void positionMetaDataStream(InputStream rawIn) throws IOException {
        DataInputStream in = new DataInputStream(rawIn);
        Object ILST = null;
        this.skipAtom(1718909296, in);
        this.enterAtom(1836019574, in);
        int mvhdSize = this.enterAtom(1836476516, in) - 20;
        IOUtils.ensureSkip(in, 12L);
        int timeScale = in.readInt();
        int timeUnits = in.readInt();
        this.setLength(timeUnits / timeScale);
        IOUtils.ensureSkip(in, mvhdSize);
        this.enterAtom(1953653099, in);
        this.skipAtom(1953196132, in);
        this.enterAtom(1835297121, in);
        this.skipAtom(1835296868, in);
        this.skipAtom(1751411826, in);
        this.enterAtom(1835626086, in);
        this.skipAtom(1936549988, in);
        this.skipAtom(1684631142, in);
        this.enterAtom(1937007212, in);
        this.enterAtom(1937011556, in);
        this.processSTSDAtom(in);
        this.skipAtom(0x73747473, in);
        this.skipAtom(1937011555, in);
        this.skipAtom(1937011578, in);
        this.skipAtom(1937007471, in);
        this.enterAtom(1969517665, in);
        this.enterAtom(1835365473, in);
        IOUtils.ensureSkip(in, 4L);
        this.skipAtom(1751411826, in);
        this._maxLength = this.enterAtom(1768715124, in);
    }

    private void processSTSDAtom(DataInputStream in) throws IOException {
        IOUtils.ensureSkip(in, 12L);
        int atomType = in.readInt();
        IOUtils.ensureSkip(in, 28L);
        if (atomType == 1836069985) {
            this.enterBitrateAtom(1702061171, 26, in);
        } else if (atomType == 1634492771) {
            this.enterBitrateAtom(1634492771, 20, in);
        } else {
            throw new IOException("atom type mismatch, expected 1836069985 or 1634492771 got " + atomType);
        }
    }

    private void enterBitrateAtom(int atom, int skip, DataInputStream in) throws IOException {
        int length = this.enterAtom(atom, in);
        length = (int)((long)length - IOUtils.ensureSkip(in, skip));
        int avgBitrate = in.readInt();
        this.setBitrate(avgBitrate / 1000);
        IOUtils.ensureSkip(in, length -= 4);
    }

    private Map populateMetaDataMap(InputStream rawIn) throws IOException {
        HashMap<Integer, byte[]> metaData = new HashMap<Integer, byte[]>();
        CountingInputStream cin = new CountingInputStream(rawIn);
        DataInputStream in = new DataInputStream(cin);
        block10: while (cin.getAmountRead() < this._maxLength && !this.isComplete()) {
            int currentSize = in.readInt();
            if (currentSize > this._maxLength) {
                throw new IOException("invalid file size");
            }
            int currentType = in.readInt();
            switch (currentType) {
                case -1452383891: {
                    metaData.put(new Integer(-1452383891), this.readDataAtom(in));
                    continue block10;
                }
                case -1455336876: {
                    metaData.put(new Integer(-1455336876), this.readDataAtom(in));
                    continue block10;
                }
                case -1453233054: {
                    metaData.put(new Integer(-1453233054), this.readDataAtom(in));
                    continue block10;
                }
                case -1451986325: 
                case 1953655662: {
                    metaData.put(new Integer(1953655662), this.readDataAtom(in));
                    continue block10;
                }
                case -1452841618: 
                case 1735291493: {
                    metaData.put(new Integer(1735291493), this.readDataAtom(in));
                    continue block10;
                }
                case -1453039239: {
                    metaData.put(new Integer(-1453039239), this.readDataAtom(in));
                    continue block10;
                }
                case -1453101708: {
                    metaData.put(new Integer(-1453101708), this.readDataAtom(in));
                    continue block10;
                }
                case 1684632427: {
                    metaData.put(new Integer(1684632427), this.readDataAtom(in));
                    continue block10;
                }
            }
            IOUtils.ensureSkip(in, currentSize - 8);
        }
        return metaData;
    }

    private byte[] readDataAtom(DataInputStream in) throws IOException {
        int size = in.readInt();
        if (in.readInt() != 1684108385) {
            throw new IOException("data tag not found");
        }
        byte[] res = new byte[size - 8];
        in.readFully(res);
        return res;
    }
}

