/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.ByteOrder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public final class MP3Info {
    private final String _file;
    private int _header;
    private VBRHeader _vbrHeader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MP3Info(String file) throws IOException {
        this._file = file;
        int i = 0;
        int pos = 0;
        int adjustedEOB = 0;
        int c = 0;
        FileInputStream fis = null;
        byte[] buf = new byte[2048];
        try {
            fis = new FileInputStream(this._file);
            c = fis.read(buf, 0, buf.length);
            if (c < 4) {
                throw new IOException("early EOF, tiny file?");
            }
            if (!(buf[0] != 105 && buf[0] != 73 || buf[1] != 100 && buf[1] != 68 || buf[2] != 51)) {
                i = buf[6] << 7 | buf[7] << 7 | buf[8] << 7 | buf[9];
                if (i > 0) {
                    i += 10;
                } else if (i < 0) {
                    i = 0;
                }
            }
            block9: do {
                if (pos < buf.length - 3) {
                    adjustedEOB = c - 3;
                } else {
                    i = 0;
                    adjustedEOB = c;
                }
                while (i < adjustedEOB) {
                    if (buf[i] == -1 && (buf[i + 1] & 0xFF) >= 224) {
                        this._header = ByteOrder.ubyte2int(buf[i + 3]) | ByteOrder.ubyte2int(buf[i + 2]) << 8 | ByteOrder.ubyte2int(buf[i + 1]) << 16 | ByteOrder.ubyte2int(buf[i]) << 24;
                        if (this.getVersionIndex() != 1 && this.getLayerIndex() != 0 && this.getBitrateIndex() != 0 && this.getBitrateIndex() != 15 && this.getFrequencyIndex() != 3 && this.getEmphasisIndex() != 2) {
                            pos += i;
                            break block9;
                        }
                    }
                    ++i;
                }
                if (adjustedEOB != -1) {
                    buf[0] = buf[c - 3];
                    buf[1] = buf[c - 2];
                    buf[2] = buf[c - 1];
                }
                pos += c - 3;
                c = fis.read(buf, 3, buf.length - 3);
                if (c >= 6) continue;
                throw new IOException("MP3 Header not found.");
            } while (c != -1 && pos < 100000);
            if (c == -1 || pos >= 100000) {
                this._header = 0;
                throw new IOException("MP3 header not found.");
            }
            int need = buf.length - i - 3 - 120 - 36;
            if (need < 0) {
                i -= need;
                int j = 0;
                for (need = -need; need < buf.length; ++need) {
                    buf[j] = buf[need];
                    ++j;
                }
                c = fis.read(buf, j, buf.length - j);
            }
            i = this.getVersionIndex() == 3 ? (i += this.getModeIndex() == 3 ? 21 : 36) : (i += this.getModeIndex() == 3 ? 23 : 21);
            switch (buf[i + 0]) {
                case 88: {
                    if (buf[i + 1] != 105 && buf[i + 1] != 73 || buf[i + 2] != 110 && buf[i + 2] != 78 || buf[i + 3] != 103 && buf[i + 3] != 71) break;
                    this.loadXingHeader(buf, i + 4);
                    break;
                }
                case 86: {
                    if (buf[i + 1] != 66 || buf[i + 2] != 82 || buf[i + 3] != 73) break;
                    this.loadFhgHeader(buf, i + 4);
                }
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (IOException e) {}
    }

    public int getBitRate() {
        double mediumFrameSize;
        int i;
        if (this.hasVariableBitRate() && (i = this._vbrHeader.getBitRate()) != -1) {
            return i;
        }
        long size = this.getFileSize();
        int retInt = (int)((double)size / ((double)size / (mediumFrameSize = (double)((this.getLayerIndex() == 3 ? 12000 : 144000) * this.getHeaderBitRate()) / (double)this.getFrequency())) * (double)this.getFrequency() / (double)(this.getLayerIndex() == 3 ? 12000 : 144000));
        if (retInt < 1) {
            return this.getHeaderBitRate();
        }
        return retInt;
    }

    private int getBitrateIndex() {
        return this._header >> 12 & 0xF;
    }

    public String getEmphasis() {
        switch (this.getEmphasisIndex()) {
            case 0: {
                return "none";
            }
            case 1: {
                return "50/15 ms";
            }
            case 2: {
                return null;
            }
            case 3: {
                return "CCIT J.17";
            }
        }
        return "<unknown>";
    }

    private int getEmphasisIndex() {
        return this._header & 3;
    }

    public long getFileSize() {
        if (this.hasVariableBitRate() && this._vbrHeader.numBytes != -1) {
            return this._vbrHeader.numBytes;
        }
        return new File(this._file).length();
    }

    private int getFrameSync() {
        return this._header >> 21 & 0x7FF;
    }

    public int getFrequency() {
        switch (this.getVersionIndex()) {
            case 0: {
                switch (this.getFrequencyIndex()) {
                    case 0: {
                        return 11025;
                    }
                    case 1: {
                        return 12000;
                    }
                    case 2: {
                        return 8000;
                    }
                }
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                switch (this.getFrequencyIndex()) {
                    case 0: {
                        return 22050;
                    }
                    case 1: {
                        return 24000;
                    }
                    case 2: {
                        return 16000;
                    }
                }
                return -1;
            }
            case 3: {
                switch (this.getFrequencyIndex()) {
                    case 0: {
                        return 44100;
                    }
                    case 1: {
                        return 48000;
                    }
                    case 2: {
                        return 32000;
                    }
                }
                return -1;
            }
        }
        return -1;
    }

    private int getFrequencyIndex() {
        return this._header >> 10 & 3;
    }

    public int getHeaderBitRate() {
        int ind = -1;
        switch (this.getVersionIndex()) {
            case 0: 
            case 2: {
                if (this.getLayer_Numeric() == 1) {
                    ind = 3;
                    break;
                }
                ind = 4;
                break;
            }
            default: {
                return 0;
            }
            case 3: {
                ind = this.getLayer_Numeric() - 1;
            }
        }
        try {
            short[] BITRATE_TABLE = new short[]{0, 0, 0, 0, 0, 32, 32, 32, 32, 8, 64, 48, 40, 48, 16, 96, 56, 48, 56, 24, 128, 64, 56, 64, 32, 160, 80, 64, 80, 40, 192, 96, 80, 96, 48, 224, 112, 96, 112, 56, 256, 128, 112, 128, 64, 288, 160, 128, 144, 80, 320, 192, 160, 160, 96, 352, 224, 192, 176, 112, 384, 256, 224, 192, 128, 416, 320, 256, 224, 144, 448, 384, 320, 256, 160};
            return BITRATE_TABLE[this.getBitrateIndex() * 5 + ind];
        }
        catch (ArrayIndexOutOfBoundsException aiob) {
            return -1;
        }
    }

    public int getLayer_Numeric() {
        return 4 - this.getLayerIndex();
    }

    public String getLayer_String() {
        switch (this.getLayerIndex()) {
            case 1: {
                return "Layer III";
            }
            case 2: {
                return "Layer II";
            }
            case 3: {
                return "Layer I";
            }
        }
        return "Layer ?";
    }

    private int getLayerIndex() {
        return this._header >> 17 & 3;
    }

    public long getLengthInSeconds() {
        int i;
        if (this.hasVariableBitRate() && (i = this._vbrHeader.getLengthInSeconds()) != -1) {
            return i;
        }
        return this.getFileSize() / (long)(this.getHeaderBitRate() * 1000 / 8);
    }

    public String getMode() {
        switch (this.getModeIndex()) {
            case 0: {
                return "Stereo";
            }
            case 1: {
                return "Joint Stereo";
            }
            case 2: {
                return "Dual Channel";
            }
            case 3: {
                return "Single Channel";
            }
        }
        return "<unknown>";
    }

    private int getModeExtIndex() {
        return this._header >> 4 & 3;
    }

    private int getModeIndex() {
        return this._header >> 6 & 3;
    }

    public int getNumberOfFrames() {
        if (this.hasVariableBitRate() && this._vbrHeader.numFrames != -1) {
            return this._vbrHeader.numFrames;
        }
        return (int)(this.getFileSize() / (long)(this.getLayerIndex() == 3 ? 12000 : 144000 * this.getBitRate() / this.getFrequency() + (this.isPadded() ? (this.getLayerIndex() == 3 ? 32 : 8) : 0)));
    }

    public VBRHeader getVBRHeader() {
        return this._vbrHeader;
    }

    public double getVersion_Numeric() {
        switch (this.getVersionIndex()) {
            case 0: {
                return 2.5;
            }
            default: {
                return 0.0;
            }
            case 2: {
                return 2.0;
            }
            case 3: 
        }
        return 1.0;
    }

    public String getVersion_String() {
        switch (this.getVersionIndex()) {
            case 0: {
                return "MPEG Version 2.5";
            }
            case 1: {
                return null;
            }
            case 2: {
                return "MPEG Version 2.0";
            }
            case 3: {
                return "MPEG Version 1.0";
            }
        }
        return "MPEG Version ?";
    }

    private int getVersionIndex() {
        return this._header >> 19 & 3;
    }

    public boolean hasVariableBitRate() {
        return this._vbrHeader != null;
    }

    public boolean isCoprighted() {
        return (this._header >> 3 & 1) != 0;
    }

    public boolean isOriginal() {
        return (this._header >> 2 & 1) != 0;
    }

    public boolean isPadded() {
        return (this._header >> 9 & 1) != 0;
    }

    public boolean isPrivate() {
        return (this._header >> 8 & 1) != 0;
    }

    public boolean isProtected() {
        return (this._header >> 16 & 1) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRiffWav() {
        boolean result = false;
        FileInputStream fis = null;
        fis = new FileInputStream(this._file);
        byte[] buffer = new byte[16];
        fis.read(buffer);
        result = buffer[0] == 82 && buffer[1] == 73 && buffer[2] == 70 && buffer[3] == 70 && buffer[8] == 87 && buffer[9] == 65 && buffer[10] == 86 && buffer[11] == 69 && buffer[12] == 102 && buffer[13] == 109 && buffer[14] == 116 && buffer[15] == 32;
        Object var5_5 = null;
        if (fis == null) return result;
        try {
            fis.close();
            return result;
        }
        catch (IOException ioe) {}
        return result;
        {
            catch (IOException iOException) {
                Object var5_6 = null;
                if (fis == null) return result;
                try {
                    fis.close();
                    return result;
                }
                catch (IOException ioe) {}
                return result;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void loadFhgHeader(byte[] buf, int pos) {
        this._vbrHeader = new VBRHeader();
        this._vbrHeader.scale = ByteOrder.ubyte2int(buf[pos += 2]);
        this._vbrHeader.numBytes = (ByteOrder.ubyte2int(buf[++pos]) << 24) + (ByteOrder.ubyte2int(buf[++pos]) << 16) + (ByteOrder.ubyte2int(buf[++pos]) << 8) + ByteOrder.ubyte2int(buf[++pos]);
        this._vbrHeader.numFrames = (ByteOrder.ubyte2int(buf[++pos]) << 24) + (ByteOrder.ubyte2int(buf[++pos]) << 16) + (ByteOrder.ubyte2int(buf[++pos]) << 8) + ByteOrder.ubyte2int(buf[++pos]);
    }

    private void loadXingHeader(byte[] buf, int offset) {
        this._vbrHeader = new VBRHeader();
        byte b = (byte)ByteOrder.ubyte2int(buf[offset += 3]);
        if ((b & 1) != 0) {
            this._vbrHeader.numFrames = (ByteOrder.ubyte2int(buf[++offset]) << 24) + (ByteOrder.ubyte2int(buf[++offset]) << 16) + (ByteOrder.ubyte2int(buf[++offset]) << 8) + ByteOrder.ubyte2int(buf[++offset]);
        }
        if ((b & 2) != 0) {
            this._vbrHeader.numBytes = (ByteOrder.ubyte2int(buf[++offset]) << 24) + (ByteOrder.ubyte2int(buf[++offset]) << 16) + (ByteOrder.ubyte2int(buf[++offset]) << 8) + ByteOrder.ubyte2int(buf[++offset]);
        }
        if ((b & 4) != 0) {
            VBRHeader.access$402(this._vbrHeader, new byte[100]);
            System.arraycopy(buf, ++offset, this._vbrHeader.toc, 0, 100);
            offset += 99;
        }
        if ((b & 8) != 0) {
            this._vbrHeader.scale = ByteOrder.ubyte2int(buf[offset += 4]);
        }
    }

    final class VBRHeader {
        private int numFrames = -1;
        private int numBytes = -1;
        private int scale = -1;
        private byte[] toc;

        VBRHeader() {
        }

        int getScale() {
            return this.scale;
        }

        byte[] getTableOfContents() {
            return this.toc;
        }

        int getBitRate() {
            if (this.numFrames != -1 && this.numBytes != -1) {
                double tpf = 0.0;
                switch (MP3Info.this.getLayerIndex()) {
                    case 1: 
                    case 2: {
                        tpf = 1152.0;
                        break;
                    }
                    case 3: {
                        tpf = 384.0;
                    }
                }
                tpf /= (double)MP3Info.this.getFrequency();
                if (MP3Info.this.getVersion_Numeric() == 2.0 || MP3Info.this.getVersion_Numeric() == 0.0) {
                    tpf /= 2.0;
                }
                return (int)((double)(this.numBytes * 8) / (tpf * (double)this.numFrames * 1000.0));
            }
            return -1;
        }

        int getLengthInSeconds() {
            if (this.numFrames != -1) {
                double tpf = 0.0;
                switch (MP3Info.this.getLayerIndex()) {
                    case 1: 
                    case 2: {
                        tpf = 1152.0;
                        break;
                    }
                    case 3: {
                        tpf = 384.0;
                    }
                }
                tpf /= (double)MP3Info.this.getFrequency();
                if (MP3Info.this.getVersion_Numeric() == 2.0 || MP3Info.this.getVersion_Numeric() == 0.0) {
                    tpf /= 2.0;
                }
                return (int)(tpf * (double)this.numFrames);
            }
            return -1;
        }

        static /* synthetic */ byte[] access$402(VBRHeader x0, byte[] x1) {
            x0.toc = x1;
            return x1;
        }
    }
}

