/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.security;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SignatureVerifier {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$security$SignatureVerifier == null ? (class$com$limegroup$gnutella$security$SignatureVerifier = SignatureVerifier.class$("com.limegroup.gnutella.security.SignatureVerifier")) : class$com$limegroup$gnutella$security$SignatureVerifier);
    private final byte[] plainText;
    private final byte[] signature;
    private final PublicKey publicKey;
    private final String algorithm;
    static /* synthetic */ Class class$com$limegroup$gnutella$security$SignatureVerifier;

    public SignatureVerifier(byte[] pText, byte[] sigBytes, PublicKey key, String algorithm) {
        this.plainText = pText;
        this.signature = sigBytes;
        this.publicKey = key;
        this.algorithm = algorithm;
    }

    public boolean verifySignature() {
        try {
            Signature verifier = Signature.getInstance(this.algorithm);
            verifier.initVerify(this.publicKey);
            verifier.update(this.plainText, 0, this.plainText.length);
            return verifier.verify(this.signature);
        }
        catch (NoSuchAlgorithmException nsax) {
            LOG.error("No alg", nsax);
            return false;
        }
        catch (InvalidKeyException ikx) {
            LOG.error("Invalid key", ikx);
            return false;
        }
        catch (SignatureException sx) {
            LOG.error("Bad sig", sx);
            return false;
        }
        catch (ClassCastException ccx) {
            LOG.error("bad cast", ccx);
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

