/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.Setting;
import com.limegroup.gnutella.settings.SettingsFactory;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.File;
import java.util.Iterator;
import java.util.Properties;

public abstract class AbstractSettings {
    private final File PROPS_FILE;
    private final SettingsFactory FACTORY;
    private boolean _shouldSave = true;

    protected AbstractSettings(String fileName, String header) {
        File settingsDir = CommonUtils.getUserSettingsDir();
        this.PROPS_FILE = new File(settingsDir, fileName);
        this.FACTORY = new SettingsFactory(this.PROPS_FILE, header);
        SettingsHandler.addSettings(this);
    }

    public Properties getProperties() {
        return this.FACTORY.getProperties();
    }

    public File getPropertiesFile() {
        return this.PROPS_FILE;
    }

    public SettingsFactory getFactory() {
        return this.FACTORY;
    }

    public void reload() {
        this.FACTORY.reload();
    }

    public void save() {
        if (this._shouldSave) {
            this.FACTORY.save();
        }
    }

    public void revertToDefault() {
        this.FACTORY.revertToDefault();
    }

    public void setShouldSave(boolean shouldSave) {
        this._shouldSave = shouldSave;
    }

    public boolean getShouldSave() {
        return this._shouldSave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Setting getSetting(String key) {
        SettingsFactory settingsFactory = this.FACTORY;
        synchronized (settingsFactory) {
            Iterator iter = this.FACTORY.iterator();
            while (iter.hasNext()) {
                Setting currSetting = (Setting)iter.next();
                if (!currSetting.getKey().equals(key)) continue;
                return currSetting;
            }
        }
        return null;
    }

    public Setting getSimppSetting(String simppKey) {
        return this.FACTORY.getSettingForSimppKey(simppKey);
    }
}

