/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.util.FixedsizeForgetfulHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class HashTreeNodeManager {
    private static final HashTreeNodeManager INSTANCE = new HashTreeNodeManager();
    private static final int MAX_NODES = 500;
    private FixedsizeForgetfulHashMap MAP = new FixedsizeForgetfulHashMap(250);
    private int _currentNodes = 0;

    public static HashTreeNodeManager instance() {
        return INSTANCE;
    }

    private HashTreeNodeManager() {
    }

    List getAllNodes(HashTree tree) {
        switch (tree.getDepth()) {
            case 0: {
                ArrayList<List> outer = new ArrayList<List>(1);
                outer.add(tree.getNodes());
                return outer;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                return HashTree.createAllParentNodes(tree.getNodes());
            }
        }
        return this.getAllNodesImpl(tree);
    }

    void register(HashTree tree, List nodes) {
        int depth = tree.getDepth();
        if (depth > 2 && depth < 7 && !this.MAP.containsKey(tree)) {
            this.insertEntry(tree, nodes);
        }
    }

    private synchronized List getAllNodesImpl(HashTree tree) {
        List nodes = (List)this.MAP.get(tree);
        if (nodes != null) {
            this.MAP.put(tree, nodes);
            return nodes;
        }
        nodes = HashTree.createAllParentNodes(tree.getNodes());
        this.insertEntry(tree, nodes);
        return nodes;
    }

    private synchronized void insertEntry(HashTree tree, List nodes) {
        int size = HashTreeNodeManager.calculateSize(nodes);
        while (this._currentNodes + size > 500) {
            if (this.MAP.isEmpty()) {
                throw new IllegalStateException("current: " + this._currentNodes + ", size: " + size);
            }
            this.purgeLRU();
        }
        this._currentNodes += size;
        this.MAP.put(tree, nodes);
    }

    private synchronized void purgeLRU() {
        List nodes = (List)this.MAP.removeLRUEntry();
        this._currentNodes -= HashTreeNodeManager.calculateSize(nodes);
    }

    private static int calculateSize(List nodes) {
        int size = 0;
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            size += ((List)i.next()).size();
        }
        return size;
    }
}

