/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.udpconnect.AckMessage;
import com.limegroup.gnutella.udpconnect.DataMessage;
import com.limegroup.gnutella.udpconnect.FinMessage;
import com.limegroup.gnutella.udpconnect.KeepAliveMessage;
import com.limegroup.gnutella.udpconnect.SynMessage;
import java.io.IOException;
import java.io.OutputStream;

public abstract class UDPConnectionMessage
extends Message {
    public static final int PROTOCOL_VERSION_NUMBER = 0;
    protected static final byte OP_SYN = 0;
    protected static final byte OP_ACK = 1;
    protected static final byte OP_KEEPALIVE = 2;
    protected static final byte OP_DATA = 3;
    protected static final byte OP_FIN = 4;
    protected static final int GUID_SIZE = 16;
    protected static final int MAX_GUID_DATA = 12;
    protected static final int GUID_DATA_START = 4;
    protected static byte[] emptyByteArray = new byte[0];
    protected byte _connectionID;
    protected byte _opcode;
    protected long _sequenceNumber;
    protected byte[] _data1;
    protected int _data1Offset;
    protected int _data1Length;
    protected byte[] _data2;
    protected int _data2Offset;
    protected int _data2Length;
    private static final BadPacketException NO_MATCH = new BadPacketException("No matching UDPConnectionMessage");

    public static UDPConnectionMessage createMessage(byte[] guid, byte ttl, byte hops, byte[] payload) throws BadPacketException {
        byte opcode = (byte)((guid[1] & 0xF0) >> 4);
        switch (opcode) {
            case 0: {
                return new SynMessage(guid, ttl, hops, payload);
            }
            case 1: {
                return new AckMessage(guid, ttl, hops, payload);
            }
            case 2: {
                return new KeepAliveMessage(guid, ttl, hops, payload);
            }
            case 3: {
                return new DataMessage(guid, ttl, hops, payload);
            }
            case 4: {
                return new FinMessage(guid, ttl, hops, payload);
            }
        }
        throw NO_MATCH;
    }

    protected UDPConnectionMessage(byte connectionID, byte opcode, long sequenceNumber, byte[] data, int datalength) {
        super(UDPConnectionMessage.buildGUID(connectionID, opcode, sequenceNumber, data, datalength), (byte)65, (byte)1, (byte)0, UDPConnectionMessage.calcPayloadLength(datalength));
        this._connectionID = connectionID;
        this._opcode = opcode;
        this._sequenceNumber = sequenceNumber;
        this._data1 = data;
        this._data1Offset = 0;
        this._data1Length = datalength >= 12 ? 12 : datalength;
        this._data2 = data;
        this._data2Offset = 12;
        this._data2Length = this.getLength();
    }

    protected UDPConnectionMessage(byte[] guid, byte ttl, byte hops, byte[] payload) throws BadPacketException {
        super(guid, (byte)65, ttl, hops, payload.length);
        this.unpackFromWire(guid, payload);
    }

    public byte getConnectionID() {
        return this._connectionID;
    }

    public long getSequenceNumber() {
        return this._sequenceNumber;
    }

    public void extendSequenceNumber(long seqNo) {
        this._sequenceNumber = seqNo;
    }

    private static byte[] buildGUID(byte connectionID, byte opcode, long sequenceNumber, byte[] data, int datalength) {
        int guidDataLength = datalength >= 12 ? 12 : datalength;
        byte[] guid = new byte[16];
        guid[0] = connectionID;
        guid[1] = (byte)((opcode & 0xF) << 4 | (byte)guidDataLength & 0xF);
        guid[2] = (byte)((sequenceNumber & 0xFF00L) >> 8);
        guid[3] = (byte)(sequenceNumber & 0xFFL);
        int end = 4 + guidDataLength;
        for (int i = 4; i < end; ++i) {
            guid[i] = data[i - 4];
        }
        return guid;
    }

    private static int calcPayloadLength(int datalength) {
        return datalength <= 12 ? 0 : datalength - 12;
    }

    private void unpackFromWire(byte[] guid, byte[] payload) throws BadPacketException {
        this._connectionID = guid[0];
        this._opcode = (byte)((guid[1] & 0xF0) >> 4);
        this._sequenceNumber = ((long)guid[2] & 0xFFL) << 8 | (long)guid[3] & 0xFFL;
        this._data1 = guid;
        this._data1Offset = 4;
        this._data1Length = guid[1] & 0xF;
        this._data2 = payload;
        this._data2Offset = 0;
        this._data2Length = payload.length;
        if (this._data1Length > 12) {
            throw new BadPacketException("GUID data too big");
        }
    }

    public static byte[] buildByteArray(byte data) {
        byte[] darray = new byte[]{data};
        return darray;
    }

    public static byte[] buildByteArray(byte val1, int val2) {
        byte[] darray = new byte[]{val1, (byte)((val2 & 0xFF00) >> 8), (byte)(val2 & 0xFF)};
        return darray;
    }

    public static byte[] buildByteArray(int val1, int val2) {
        byte[] darray = new byte[]{(byte)((val1 & 0xFF00) >> 8), (byte)(val1 & 0xFF), (byte)((val2 & 0xFF00) >> 8), (byte)(val2 & 0xFF)};
        return darray;
    }

    public static int getShortInt(byte b1, byte b2) {
        return (b1 & 0xFF) << 8 | b2 & 0xFF;
    }

    public int getDataLength() {
        return this._data1Length + this.getLength();
    }

    protected void writePayload(OutputStream out) throws IOException {
        if (this._data2Length > 0) {
            out.write(this._data2, this._data2Offset, this._data2Length);
        }
    }

    public Message stripExtendedPayload() {
        return this;
    }

    public void recordDrop() {
    }
}

