/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.UploadState;
import java.io.IOException;
import java.io.OutputStream;

public class QueuedUploadState
extends UploadState {
    private final int POSITION;

    public QueuedUploadState(int pos, HTTPUploader uploader) {
        super(uploader);
        this.POSITION = pos;
    }

    public void writeMessageHeaders(OutputStream ostream) throws IOException {
        Assert.that(this.POSITION != -1);
        String str = "HTTP/1.1 503 Service Unavailable\r\n";
        ostream.write(str.getBytes());
        HTTPUtils.writeHeader(HTTPHeaderName.SERVER, ConstantHTTPHeaderValue.SERVER_VALUE, ostream);
        str = "X-Queue: position=" + (this.POSITION + 1) + ", pollMin=" + 45 + ", pollMax=" + 120 + "\r\n";
        ostream.write(str.getBytes());
        this.writeAlts(ostream);
        this.writeRanges(ostream);
        if (this.UPLOADER.isFirstReply()) {
            HTTPUtils.writeFeatures(ostream);
        }
        if (this.FILE_DESC.getHashTree() != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.THEX_URI, (HTTPHeaderValue)this.FILE_DESC.getHashTree(), ostream);
        }
        str = "\r\n";
        ostream.write(str.getBytes());
    }

    public void writeMessageBody(OutputStream ostream) throws IOException {
    }

    public boolean getCloseConnection() {
        return false;
    }
}

