/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.statistics.UploadStat;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class StalledUploadWatchdog
implements Runnable {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$uploader$StalledUploadWatchdog == null ? (class$com$limegroup$gnutella$uploader$StalledUploadWatchdog = StalledUploadWatchdog.class$("com.limegroup.gnutella.uploader.StalledUploadWatchdog")) : class$com$limegroup$gnutella$uploader$StalledUploadWatchdog);
    public static long DELAY_TIME = 120000L;
    private OutputStream ostream;
    private boolean isScheduled;
    private long nextCheckTime;
    private boolean closed;
    static /* synthetic */ Class class$com$limegroup$gnutella$uploader$StalledUploadWatchdog;

    public synchronized boolean deactivate() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deactived on: " + this.ostream);
        }
        this.nextCheckTime = -1L;
        this.ostream = null;
        return this.closed;
    }

    public synchronized void activate(OutputStream os) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Activated on: " + os);
        }
        this.nextCheckTime = System.currentTimeMillis() + DELAY_TIME;
        if (!this.isScheduled) {
            RouterService.schedule(this, DELAY_TIME, 0L);
            this.isScheduled = true;
        }
        this.ostream = os;
    }

    public synchronized void run() {
        this.isScheduled = false;
        if (this.nextCheckTime == -1L) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now < this.nextCheckTime) {
            RouterService.schedule(this, this.nextCheckTime - now, 0L);
        } else {
            this.closed = true;
            try {
                if (this.ostream != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("STALLED!  Killing: " + this.ostream);
                    }
                    UploadStat.STALLED.incrementStat();
                    this.ostream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.ostream = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

