/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.XMLParsingUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public final class LimeXMLDocumentHelper {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$xml$LimeXMLDocumentHelper == null ? (class$com$limegroup$gnutella$xml$LimeXMLDocumentHelper = LimeXMLDocumentHelper.class$("com.limegroup.gnutella.xml.LimeXMLDocumentHelper")) : class$com$limegroup$gnutella$xml$LimeXMLDocumentHelper);
    public static final String XML_HEADER = "<?xml version=\"1.0\"?>";
    public static final String XML_NAMESPACE = "xsi:noNamespaceSchemaLocation=\"";
    static /* synthetic */ Class class$com$limegroup$gnutella$xml$LimeXMLDocumentHelper;

    private LimeXMLDocumentHelper() {
    }

    public static List getDocuments(String aggregatedXML, int totalResponseCount) {
        if (aggregatedXML == null || aggregatedXML.equals("") || totalResponseCount <= 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<LimeXMLDocument[]> results = new ArrayList<LimeXMLDocument[]>();
        Iterator i = XMLParsingUtils.split(aggregatedXML).iterator();
        while (i.hasNext()) {
            XMLParsingUtils.ParseResult parsingResult;
            String xmlDocument = (String)i.next();
            try {
                parsingResult = XMLParsingUtils.parse(xmlDocument, totalResponseCount);
            }
            catch (SAXException sax) {
                LOG.warn("SAX while parsing: " + xmlDocument, sax);
                continue;
            }
            catch (IOException bad) {
                LOG.warn("IOX while parsing: " + aggregatedXML, bad);
                return Collections.EMPTY_LIST;
            }
            String indexKey = parsingResult.canonicalKeyPrefix + "index__";
            LimeXMLDocument[] documents = new LimeXMLDocument[totalResponseCount];
            Iterator j = parsingResult.iterator();
            while (j.hasNext()) {
                Map attributes = (Map)j.next();
                String sindex = (String)attributes.remove(indexKey);
                if (sindex == null) {
                    return Collections.EMPTY_LIST;
                }
                int index = -1;
                try {
                    index = Integer.parseInt(sindex);
                }
                catch (NumberFormatException bad) {
                    LOG.warn("NFE while parsing", bad);
                    return Collections.EMPTY_LIST;
                }
                if (index >= documents.length || index < 0) {
                    return Collections.EMPTY_LIST;
                }
                if (attributes.isEmpty()) continue;
                try {
                    documents[index] = new LimeXMLDocument(attributes, parsingResult.schemaURI, parsingResult.canonicalKeyPrefix);
                }
                catch (IOException ignored) {
                    LOG.debug("", ignored);
                }
            }
            results.add(documents);
        }
        return results;
    }

    public static String getAggregateString(Response[] responses) {
        HashMap<LimeXMLSchema, StringBuffer> allXML = new HashMap<LimeXMLSchema, StringBuffer>();
        for (int i = 0; i < responses.length; ++i) {
            LimeXMLDocument doc = responses[i].getDocument();
            if (doc == null) continue;
            LimeXMLSchema schema = doc.getSchema();
            StringBuffer built = (StringBuffer)allXML.get(schema);
            if (built == null) {
                built = new StringBuffer();
                allXML.put(schema, built);
            }
            built.append(doc.getAttributeStringWithIndex(i));
        }
        StringBuffer fullXML = new StringBuffer();
        Iterator i = allXML.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            LimeXMLSchema schema = (LimeXMLSchema)entry.getKey();
            StringBuffer buffer = (StringBuffer)entry.getValue();
            LimeXMLDocumentHelper.buildXML(fullXML, schema, buffer.toString());
        }
        return fullXML.toString();
    }

    public static void buildXML(StringBuffer buffer, LimeXMLSchema schema, String inner) {
        buffer.append(XML_HEADER);
        buffer.append("<");
        buffer.append(schema.getRootXMLName());
        buffer.append(" ");
        buffer.append(XML_NAMESPACE);
        buffer.append(schema.getSchemaURI());
        buffer.append("\">");
        buffer.append(inner);
        buffer.append("</");
        buffer.append(schema.getRootXMLName());
        buffer.append(">");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

