/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.xml.LimeXMLProperties;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class XMLHostCache {
    private final String XML_HOSTS_DIR = "xml" + File.separator + "misc" + File.separator;
    private final String XML_HOSTS_FILE = "server.props";
    private final String HOSTS_DELIM = ",";
    private Properties _props;
    private String _dbFile;
    private static final boolean debugOn = false;

    public XMLHostCache() throws Exception {
        String limeHome = LimeXMLProperties.instance().getPath();
        this._dbFile = limeHome + File.separator + this.XML_HOSTS_DIR + File.separator + "server.props";
        FileInputStream toLoadProps = new FileInputStream(this._dbFile);
        this._props = new Properties();
        this._props.load(toLoadProps);
        XMLHostCache.debug("" + this._props);
    }

    private String getHostsForSchema(String schemaURI) {
        String retString = null;
        String displayString = LimeXMLSchema.getDisplayString(schemaURI);
        if (displayString != null) {
            retString = this._props.getProperty(displayString);
        }
        return retString;
    }

    public String[] getCachedHostsForURI(String schemaURI) {
        String[] retHosts = null;
        String hosts = this.getHostsForSchema(schemaURI);
        if (hosts != null) {
            StringTokenizer st = new StringTokenizer(hosts, ",");
            ArrayList<String> ipAddresses = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String currHost = st.nextToken();
                try {
                    InetAddress currIA = InetAddress.getByName(currHost);
                    ipAddresses.add(currIA.getHostAddress());
                }
                catch (UnknownHostException ignored) {}
            }
            retHosts = new String[ipAddresses.size()];
            for (int i = 0; i < retHosts.length; ++i) {
                retHosts[i] = (String)ipAddresses.get(i);
            }
        }
        return retHosts;
    }

    public static void main(String[] argv) throws Exception {
        XMLHostCache xmlhc = new XMLHostCache();
        LimeXMLSchemaRepository rep = LimeXMLSchemaRepository.instance();
        if (rep != null) {
            String[] uris = rep.getAvailableSchemaURIs();
            for (int i = 0; i < uris.length; ++i) {
                XMLHostCache.debug("curr uri = " + uris[i]);
                String[] hosts = xmlhc.getCachedHostsForURI(uris[i]);
                for (int j = 0; hosts != null && j < hosts.length; ++j) {
                    XMLHostCache.debug(hosts[j]);
                }
                XMLHostCache.debug("--------------------");
            }
        }
    }

    public static final void debug(String out) {
    }
}

