/*
 * Decompiled with CFR 0.152.
 */
import java.util.Iterator;
import org.cybergarage.upnp.ControlPoint;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.DeviceList;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.device.DeviceChangeListener;
import org.cybergarage.upnp.device.NotifyListener;
import org.cybergarage.upnp.event.EventListener;
import org.cybergarage.upnp.ssdp.SSDPPacket;

public class Test
extends ControlPoint
implements DeviceChangeListener,
EventListener,
NotifyListener {
    private static final String WAN_DEVICE = "urn:schemas-upnp-org:device:WANDevice:1";
    private static final String WANCON_DEVICE = "urn:schemas-upnp-org:device:WANConnectionDevice:1";
    private static final String SERVICE_TYPE = "urn:schemas-upnp-org:service:WANIPConnection:1";
    Device _router;
    Service _service;

    public void eventNotifyReceived(String uuid, long seq, String varName, String value) {
        System.out.println(String.valueOf(uuid) + "  " + seq + " " + varName + " " + value);
    }

    public Test() {
        System.out.println("starting");
        this.addDeviceChangeListener(this);
        this.addEventListener(this);
        this.addNotifyListener(this);
        this.start();
    }

    private void discoverService() {
        Iterator iter = this._router.getDeviceList().iterator();
        while (iter.hasNext()) {
            Device current = (Device)iter.next();
            if (!current.getDeviceType().equals(WAN_DEVICE)) continue;
            DeviceList l = current.getDeviceList();
            int i = 0;
            while (i < current.getDeviceList().size()) {
                Device current2 = l.getDevice(i);
                if (current2.getDeviceType().equals(WANCON_DEVICE)) {
                    this._service = current2.getService(SERVICE_TYPE);
                    return;
                }
                ++i;
            }
        }
    }

    public void deviceAdded(Device dev) {
        System.out.println(dev.getDeviceType());
        this._router = dev;
        this.discoverService();
        System.out.println(this._service.getServiceType());
        this.subscribe(this._service);
    }

    public void deviceRemoved(Device dev) {
    }

    public static void main(String[] args) {
        Test t = new Test();
    }

    public void deviceNotifyReceived(SSDPPacket ssdpPacket) {
        System.out.println(ssdpPacket);
    }
}

