/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.hash;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.logi.crypto.Crypto;
import org.logi.crypto.CryptoCorruptError;
import org.logi.crypto.InvalidCDSException;
import org.logi.crypto.hash.Fingerprint;

public abstract class HashState
extends Crypto {
    private static String defaultHashFunction = "SHA1";

    public static HashState create(String string) throws InvalidCDSException {
        Constructor constructor;
        Object object;
        Class clazz = Crypto.makeClass(string + "State");
        try {
            object = new Class[]{};
            constructor = clazz.getConstructor((Class<?>)object);
        }
        catch (Exception exception) {
            throw new InvalidCDSException(string + " does not have a " + string + "State() constructor");
        }
        try {
            Object[] objectArray = new Class[]{};
            object = constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InvalidCDSException("Unable to create an instance of " + string + "State [ " + invocationTargetException.getTargetException().toString() + " ]");
        }
        catch (Exception exception) {
            throw new InvalidCDSException("Unable to create an instance of " + string);
        }
        try {
            return (HashState)object;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidCDSException(string + "State is not a descendant of HashState");
        }
    }

    public static HashState create() {
        try {
            return HashState.create(defaultHashFunction);
        }
        catch (InvalidCDSException invalidCDSException) {
            throw new CryptoCorruptError("The HashState object for " + defaultHashFunction + " has disappeared.");
        }
    }

    public static void setDefaultHashFunction(String string) throws InvalidCDSException {
        HashState.create(string);
        defaultHashFunction = string;
    }

    public static String getDefaultHashFunction() {
        return defaultHashFunction;
    }

    public abstract String getName();

    public abstract void reset();

    public abstract void update(byte[] var1, int var2, int var3);

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public void update(String string) {
        this.update(string.getBytes());
    }

    public abstract Fingerprint calculate();

    public abstract int blockSize();

    public abstract int hashSize();
}

