/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.keys;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Vector;
import org.logi.crypto.Crypto;
import org.logi.crypto.InvalidCDSException;
import org.logi.crypto.hash.Fingerprint;
import org.logi.crypto.hash.HashState;
import org.logi.crypto.hash.SHA1State;
import org.logi.crypto.keys.Key;

public class KeyRecord
extends Crypto {
    private String ownerName;
    private String ownerMail;
    private String notes;
    private Key key;
    Vector signatures;

    public static KeyRecord parseCDS(String string) throws InvalidCDSException {
        KeyRecord keyRecord = null;
        try {
            StringReader stringReader = new StringReader(string);
            Object object = Crypto.fromString(stringReader);
            if (!(object instanceof Key)) {
                throw new InvalidCDSException("CDS for a Key object expected as first argument to KeyRecord()");
            }
            StreamTokenizer streamTokenizer = new StreamTokenizer(stringReader);
            streamTokenizer.ordinaryChars(48, 57);
            streamTokenizer.wordChars(48, 57);
            int n = -3;
            int n2 = -2;
            if (streamTokenizer.nextToken() != 44) {
                throw new InvalidCDSException(", expected after " + object);
            }
            if (streamTokenizer.nextToken() != n && streamTokenizer.ttype != 34) {
                throw new InvalidCDSException("String expected as second argument to KeyRecord()");
            }
            String string2 = streamTokenizer.sval;
            if (streamTokenizer.nextToken() != 44) {
                throw new InvalidCDSException(", expected after " + string2);
            }
            if (streamTokenizer.nextToken() != n && streamTokenizer.ttype != 34) {
                throw new InvalidCDSException("String expected as third argument to KeyRecord()");
            }
            String string3 = streamTokenizer.sval;
            if (streamTokenizer.nextToken() != 44) {
                throw new InvalidCDSException(", expected after " + string3);
            }
            if (streamTokenizer.nextToken() != n && streamTokenizer.ttype != 34) {
                throw new InvalidCDSException("String expected as fourth argument to KeyRecord()");
            }
            String string4 = streamTokenizer.sval;
            keyRecord = new KeyRecord((Key)object, string2, string3, string4);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return keyRecord;
    }

    public Key getKey() {
        return this.key;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getOwnerMail() {
        return this.ownerMail;
    }

    public String getNotes() {
        return this.notes;
    }

    public Fingerprint getFingerprint() {
        byte[] byArray = new byte[]{0, 0, 0, 0};
        SHA1State sHA1State = new SHA1State();
        sHA1State.update(this.key.getFingerprint().getBytes());
        sHA1State.update(byArray);
        sHA1State.update(this.ownerName);
        sHA1State.update(byArray);
        sHA1State.update(this.ownerMail);
        sHA1State.update(byArray);
        sHA1State.update(this.notes);
        return ((HashState)sHA1State).calculate();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("KeyRecord(");
        stringBuffer.append(this.key);
        stringBuffer.append(",\"");
        stringBuffer.append(this.ownerName);
        stringBuffer.append("\",\"");
        stringBuffer.append(this.ownerMail);
        stringBuffer.append("\",\"");
        stringBuffer.append(this.notes);
        stringBuffer.append("\")");
        return stringBuffer.toString();
    }

    public KeyRecord(Key key, String string, String string2, String string3) {
        this.ownerName = string;
        this.ownerMail = string2;
        this.notes = string3;
        this.key = key;
    }
}

