/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.BinaryBaseType;
import com.sun.msv.datatype.xsd.BinaryValueType;
import org.relaxng.datatype.ValidationContext;

public class Base64BinaryType
extends BinaryBaseType {
    public static final Base64BinaryType theInstance = new Base64BinaryType();
    private static final byte[] decodeMap = Base64BinaryType.initDecodeMap();
    private static final byte PADDING = 127;
    private static final char[] encodeMap;

    private Base64BinaryType() {
        super("base64Binary");
    }

    private static byte[] initDecodeMap() {
        byte[] map = new byte[256];
        int i = 0;
        while (i < 256) {
            map[i] = -1;
            ++i;
        }
        i = 65;
        while (i <= 90) {
            map[i] = (byte)(i - 65);
            ++i;
        }
        i = 97;
        while (i <= 122) {
            map[i] = (byte)(i - 97 + 26);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            map[i] = (byte)(i - 48 + 52);
            ++i;
        }
        map[43] = 62;
        map[47] = 63;
        map[61] = 127;
        return map;
    }

    public Object _createValue(String lexicalValue, ValidationContext context) {
        byte[] buf = Base64BinaryType.load(lexicalValue);
        if (buf == null) {
            return null;
        }
        return new BinaryValueType(buf);
    }

    public static byte[] load(String lexicalValue) {
        byte[] buf = lexicalValue.getBytes();
        int outlen = Base64BinaryType.calcLength(buf);
        if (outlen == -1) {
            return null;
        }
        byte[] out = new byte[outlen];
        int o = 0;
        int len = buf.length;
        byte[] quadruplet = new byte[4];
        int q = 0;
        int i = 0;
        while (i < len) {
            byte v = decodeMap[buf[i]];
            if (v != -1) {
                quadruplet[q++] = v;
            }
            if (q == 4) {
                out[o++] = (byte)(quadruplet[0] << 2 | quadruplet[1] >> 4);
                if (quadruplet[2] != 127) {
                    out[o++] = (byte)(quadruplet[1] << 4 | quadruplet[2] >> 2);
                }
                if (quadruplet[3] != 127) {
                    out[o++] = (byte)(quadruplet[2] << 6 | quadruplet[3]);
                }
                q = 0;
            }
            ++i;
        }
        if (q != 0) {
            throw new IllegalStateException();
        }
        return out;
    }

    protected boolean checkFormat(String lexicalValue, ValidationContext context) {
        return Base64BinaryType.calcLength(lexicalValue.getBytes()) != -1;
    }

    private static int calcLength(byte[] buf) {
        int len = buf.length;
        int base64count = 0;
        int paddingCount = 0;
        int i = 0;
        while (i < len) {
            if (buf[i] == 61) break;
            if (decodeMap[buf[i]] != -1) {
                ++base64count;
            }
            ++i;
        }
        while (i < len) {
            if (buf[i] == 61) {
                ++paddingCount;
            } else if (decodeMap[buf[i]] != -1) {
                return -1;
            }
            ++i;
        }
        if (paddingCount > 2) {
            return -1;
        }
        if ((base64count + paddingCount) % 4 != 0) {
            return -1;
        }
        return (base64count + paddingCount) / 4 * 3 - paddingCount;
    }

    private static char[] initEncodeMap() {
        char[] map = new char[64];
        int i = 0;
        while (i < 26) {
            map[i] = (char)(65 + i);
            ++i;
        }
        i = 26;
        while (i < 52) {
            map[i] = (char)(97 + (i - 26));
            ++i;
        }
        i = 52;
        while (i < 62) {
            map[i] = (char)(48 + (i - 52));
            ++i;
        }
        map[62] = 43;
        map[63] = 47;
        return map;
    }

    protected static char encode(int i) {
        return encodeMap[i & 0x3F];
    }

    public String serializeJavaObject(Object value, SerializationContext context) {
        if (!(value instanceof byte[])) {
            throw new IllegalArgumentException();
        }
        return Base64BinaryType.save((byte[])value);
    }

    public static String save(byte[] input) {
        StringBuffer r = new StringBuffer(input.length * 4 / 3);
        int i = 0;
        while (i < input.length) {
            switch (input.length - i) {
                case 1: {
                    r.append(Base64BinaryType.encode(input[i] >> 2));
                    r.append(Base64BinaryType.encode((input[i] & 3) << 4));
                    r.append("==");
                    break;
                }
                case 2: {
                    r.append(Base64BinaryType.encode(input[i] >> 2));
                    r.append(Base64BinaryType.encode((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF));
                    r.append(Base64BinaryType.encode((input[i + 1] & 0xF) << 2));
                    r.append("=");
                    break;
                }
                default: {
                    r.append(Base64BinaryType.encode(input[i] >> 2));
                    r.append(Base64BinaryType.encode((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF));
                    r.append(Base64BinaryType.encode((input[i + 1] & 0xF) << 2 | input[i + 2] >> 6 & 3));
                    r.append(Base64BinaryType.encode(input[i + 2] & 0x3F));
                }
            }
            i += 3;
        }
        return r.toString();
    }

    public String convertToLexicalValue(Object value, SerializationContext context) {
        if (!(value instanceof BinaryValueType)) {
            throw new IllegalArgumentException();
        }
        return this.serializeJavaObject(((BinaryValueType)value).rawData, context);
    }

    static {
        PADDING = (byte)127;
        encodeMap = Base64BinaryType.initEncodeMap();
    }
}

