/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.BuiltinAtomicType;
import com.sun.msv.datatype.xsd.Comparator;
import com.sun.msv.datatype.xsd.SimpleURType;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.datatype.xsd.datetime.IDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.ISO8601Parser;
import com.sun.msv.datatype.xsd.datetime.TimeZone;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import org.relaxng.datatype.ValidationContext;

abstract class DateTimeBaseType
extends BuiltinAtomicType
implements Comparator {
    static /* synthetic */ Class class$java$util$Calendar;

    protected DateTimeBaseType(String typeName) {
        super(typeName);
    }

    public final XSDatatype getBaseType() {
        return SimpleURType.theInstance;
    }

    private static final ISO8601Parser getParser(String content) throws Exception {
        return new ISO8601Parser((InputStream)new ByteArrayInputStream(content.getBytes("UTF8")));
    }

    protected final boolean checkFormat(String content, ValidationContext context) {
        try {
            this.runParserL(DateTimeBaseType.getParser(content));
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected abstract void runParserL(ISO8601Parser var1) throws Exception;

    public final Object _createValue(String content, ValidationContext context) {
        try {
            return this.runParserV(DateTimeBaseType.getParser(content));
        }
        catch (Throwable e) {
            return null;
        }
    }

    protected abstract IDateTimeValueType runParserV(ISO8601Parser var1) throws Exception;

    public int compare(Object lhs, Object rhs) {
        return ((IDateTimeValueType)lhs).compare((IDateTimeValueType)rhs);
    }

    public final int isFacetApplicable(String facetName) {
        if (facetName.equals("pattern") || facetName.equals("enumeration") || facetName.equals("maxInclusive") || facetName.equals("maxExclusive") || facetName.equals("minInclusive") || facetName.equals("minExclusive")) {
            return 0;
        }
        return -2;
    }

    protected String formatYear(int year) {
        String s = year <= 0 ? Integer.toString(1 - year) : Integer.toString(year);
        while (s.length() < 4) {
            s = "0" + s;
        }
        if (year <= 0) {
            s = "-" + s;
        }
        return s;
    }

    protected String formatYear(BigInteger year) {
        String s = year.signum() <= 0 ? year.negate().add(BigInteger.ONE).toString() : year.toString();
        while (s.length() < 4) {
            s = "0" + s;
        }
        if (year.signum() <= 0) {
            s = "-" + s;
        }
        return s;
    }

    protected String formatTwoDigits(Integer v) {
        return this.formatTwoDigits(v, 0);
    }

    protected String formatTwoDigits(Integer v, int offset) {
        if (v == null) {
            return "00";
        }
        return this.formatTwoDigits(v + offset);
    }

    protected String formatTwoDigits(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return Integer.toString(n);
    }

    protected String formatSeconds(BigDecimal dec) {
        if (dec == null) {
            return "00";
        }
        String s = dec.toString();
        if (dec.compareTo(new BigDecimal("10")) < 0) {
            s = "0" + s;
        }
        return s;
    }

    protected String formatSeconds(Calendar cal) {
        StringBuffer result = new StringBuffer();
        result.append(this.formatTwoDigits(cal.get(13)));
        if (cal.isSet(14)) {
            String ms = Integer.toString(cal.get(14));
            while (ms.length() < 3) {
                ms = "0" + ms;
            }
            result.append('.');
            result.append(ms);
        }
        return result.toString();
    }

    protected String formatTimeZone(TimeZone tz) {
        if (tz == null) {
            return "";
        }
        if (tz.minutes == 0) {
            return "Z";
        }
        return (tz.minutes < 0 ? "-" : "+") + this.formatTwoDigits(new Integer(Math.abs(tz.minutes / 60))) + ":" + this.formatTwoDigits(new Integer(Math.abs(tz.minutes) % 60));
    }

    protected String formatTimeZone(Calendar cal) {
        if (cal.getTimeZone() == null) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        int offset = cal.getTimeZone().getRawOffset();
        if (offset >= 0) {
            result.append('+');
        } else {
            result.append('-');
            offset *= -1;
        }
        result.append(this.formatTwoDigits((offset /= 60000) / 60));
        result.append(':');
        result.append(this.formatTwoDigits(offset % 60));
        return result.toString();
    }

    protected static int nullAsZero(Number n) {
        if (n == null) {
            return 0;
        }
        return n.intValue();
    }

    public final Object _createJavaObject(String literal, ValidationContext context) {
        IDateTimeValueType v = (IDateTimeValueType)this.createValue(literal, context);
        if (v == null) {
            return null;
        }
        return v.toCalendar();
    }

    public abstract String serializeJavaObject(Object var1, SerializationContext var2);

    public Class getJavaObjectType() {
        return class$java$util$Calendar == null ? (class$java$util$Calendar = DateTimeBaseType.class$("java.util.Calendar")) : class$java$util$Calendar;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

