/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.net.UnknownHostException;
import java.util.HashMap;
import phex.host.HostAddress;
import phex.utils.IOUtil;

public class IPCounter {
    private HashMap ipCountMap = new HashMap();
    private int maxCount;

    public IPCounter(int n) {
        this.maxCount = n;
    }

    public synchronized boolean validateAndCountIP(HostAddress hostAddress) {
        byte[] byArray;
        try {
            byArray = hostAddress.getHostIP();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        int n = IOUtil.deserializeIntLE(byArray, 0);
        Integer n2 = new Integer(n);
        Integer n3 = (Integer)this.ipCountMap.get(n2);
        if (n3 != null) {
            if (n3 == this.maxCount) {
                return false;
            }
            this.ipCountMap.put(n2, new Integer(n3 + 1));
        } else {
            this.ipCountMap.put(n2, new Integer(1));
        }
        return true;
    }

    public synchronized void relaseIP(HostAddress hostAddress) {
        byte[] byArray;
        try {
            byArray = hostAddress.getHostIP();
        }
        catch (UnknownHostException unknownHostException) {
            return;
        }
        int n = IOUtil.deserializeIntLE(byArray, 0);
        Integer n2 = new Integer(n);
        Integer n3 = (Integer)this.ipCountMap.get(n2);
        if (n3 != null) {
            if (n3 == 1) {
                this.ipCountMap.remove(n2);
                return;
            }
            this.ipCountMap.put(n2, new Integer(n3 - 1));
        }
    }
}

