/*
 * Decompiled with CFR 0.152.
 */
package phex.common.bandwidth;

import phex.common.DoubleObj;
import phex.common.IntObj;

public class BandwidthWindow {
    private IntObj lastPane;
    private IntObj currentPane;
    private IntObj maxPane;
    private long timesMeasured = 0L;
    private DoubleObj avgBandwidth = new DoubleObj(0.0);

    public BandwidthWindow() {
        this.currentPane = new IntObj(0);
        this.lastPane = new IntObj(0);
        this.maxPane = new IntObj(0);
    }

    public synchronized void slideWindow() {
        IntObj intObj = this.lastPane;
        this.lastPane = this.currentPane;
        this.currentPane = intObj;
        this.currentPane.setValue(0);
        if (this.lastPane.getValue() > this.maxPane.getValue()) {
            this.maxPane.setValue(this.lastPane.getValue());
        }
        ++this.timesMeasured;
        this.avgBandwidth.setValue((this.avgBandwidth.getValue() * (double)(this.timesMeasured - 1L) + (double)this.lastPane.getValue()) / (double)this.timesMeasured);
    }

    public void countBytesTransfered(int n) {
        this.currentPane.inc(n);
    }

    public IntObj getCurrentTransferRate() {
        return this.lastPane;
    }

    public IntObj getMaxTransferRate() {
        return this.maxPane;
    }

    public DoubleObj getAvgTransferRate() {
        return this.avgBandwidth;
    }
}

