/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.util.ArrayList;
import phex.common.ThreadTracking;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.msg.MsgManager;
import phex.utils.Localizer;
import phex.utils.Logger;

public class ConnectionObserver
implements Runnable {
    private long SLEEP_TIME = 10000L;
    private long PING_WAIT_TIME = 8000L;
    private MsgManager messageMgr;
    private ArrayList snapshootList;
    private ArrayList quiteList;
    private NetworkHostsContainer networkHostsContainer = HostManager.getInstance().getNetworkHostsContainer();

    public ConnectionObserver() {
        this.messageMgr = MsgManager.getInstance();
    }

    public void start() {
        Thread thread = new Thread(ThreadTracking.rootThreadGroup, this, "ConnectionObserver-" + Integer.toHexString(this.hashCode()));
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        this.snapshootList = new ArrayList<E>();
        this.quiteList = new ArrayList<E>();
        block4: while (true) {
            this.snapshootList.clear();
            this.quiteList.clear();
            var1_1 = this.networkHostsContainer.getUltrapeerConnections();
            this.createSnapshoots(var1_1);
            var1_1 = this.networkHostsContainer.getLeafConnections();
            this.createSnapshoots(var1_1);
            var1_1 = this.networkHostsContainer.getPeerConnections();
            this.createSnapshoots(var1_1);
            try {
                Thread.currentThread();
                Thread.sleep(this.SLEEP_TIME);
            }
            catch (InterruptedException var2_2) {
                // empty catch block
            }
            var1_1 = this.networkHostsContainer.getUltrapeerConnections();
            this.findQuiteHosts(var1_1);
            var1_1 = this.networkHostsContainer.getLeafConnections();
            this.findQuiteHosts(var1_1);
            var1_1 = this.networkHostsContainer.getPeerConnections();
            this.findQuiteHosts(var1_1);
            if (this.quiteList.size() <= 0) continue;
            var2_3 = this.quiteList.size();
            var3_4 = 0;
            while (true) {
                if (var3_4 < var2_3) ** break;
                continue block4;
                var4_5 = (Host)this.quiteList.get(var3_4);
                var4_5.log(Logger.FINEST, "Sending keep alive ping.");
                this.messageMgr.pingHost(var4_5);
                try {
                    Thread.currentThread();
                    Thread.sleep(this.PING_WAIT_TIME);
                }
                catch (InterruptedException var5_7) {
                    // empty catch block
                }
                var5_6 = this.findSnapshoot(var4_5);
                if (var5_6.hasBeenQuite(var4_5)) {
                    var4_5.setStatus(1, Localizer.getString("HostNotResponding"));
                    var4_5.log(Logger.FINEST, "Host not responding, disconnecting..");
                    this.networkHostsContainer.disconnectHost(var4_5);
                }
                ++var3_4;
            }
            break;
        }
    }

    private void findQuiteHosts(Host[] hostArray) {
        int n = 0;
        while (n < hostArray.length) {
            ConnectionSnapshoot connectionSnapshoot = this.findSnapshoot(hostArray[n]);
            if (connectionSnapshoot != null && connectionSnapshoot.hasBeenQuite(hostArray[n])) {
                this.quiteList.add(hostArray[n]);
            }
            ++n;
        }
    }

    private void createSnapshoots(Host[] hostArray) {
        int n = 0;
        while (n < hostArray.length) {
            this.snapshootList.add(new ConnectionSnapshoot(hostArray[n]));
            ++n;
        }
    }

    private ConnectionSnapshoot findSnapshoot(Host host) {
        int n = this.snapshootList.size();
        int n2 = 0;
        while (n2 < n) {
            ConnectionSnapshoot connectionSnapshoot = (ConnectionSnapshoot)this.snapshootList.get(n2);
            if (connectionSnapshoot.host == host) {
                return connectionSnapshoot;
            }
            ++n2;
        }
        return null;
    }

    private class ConnectionSnapshoot {
        Host host;
        int receivedCount;
        int sentCount;
        int sendDropCount;

        ConnectionSnapshoot(Host host) {
            this.host = host;
            this.receivedCount = host.getReceivedCount();
            this.sentCount = host.getSentCount();
            this.sendDropCount = host.getSendDropCount();
        }

        public boolean hasBeenQuite(Host host) {
            int n = host.getReceivedCount() - this.receivedCount;
            int n2 = host.getSentCount() - this.sentCount;
            int n3 = host.getSendDropCount() - this.sendDropCount;
            if (n == 0) {
                return true;
            }
            return n2 == n3 && n2 != 0;
        }
    }
}

