/*
 * Decompiled with CFR 0.152.
 */
package phex.connection.handshake;

import java.io.IOException;
import phex.connection.ConnectionConstants;
import phex.connection.ConnectionRejectedException;
import phex.connection.ProtocolNotSupportedException;
import phex.http.HTTPHeaders;
import phex.http.HTTPProcessor;
import phex.utils.GnutellaInputStream;
import phex.utils.Logger;

public class HandshakeStatus
implements ConnectionConstants {
    private int statusCode;
    private String statusMessage;
    private HTTPHeaders responseHeaders;

    public HandshakeStatus(int n, String string) {
        this(n, string, HTTPHeaders.EMPTY_HTTPHEADERS);
    }

    public HandshakeStatus(int n, String string, HTTPHeaders hTTPHeaders) {
        this.statusCode = n;
        this.statusMessage = string;
        this.responseHeaders = hTTPHeaders;
    }

    public HandshakeStatus(HTTPHeaders hTTPHeaders) {
        this(200, "OK", hTTPHeaders);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public HTTPHeaders getResponseHeaders() {
        return this.responseHeaders;
    }

    public static HandshakeStatus parseHandshakeResponse(GnutellaInputStream gnutellaInputStream) throws ProtocolNotSupportedException, IOException {
        String string;
        int n;
        String string2 = gnutellaInputStream.readLine();
        if (string2 == null) {
            throw new IOException("Disconnected from remote host during initial handshake");
        }
        if (!string2.startsWith("GNUTELLA/0.6")) {
            throw new ProtocolNotSupportedException("Bad protocol response: " + string2);
        }
        HTTPHeaders hTTPHeaders = HTTPProcessor.parseHTTPHeaders(gnutellaInputStream);
        try {
            String string3 = string2.substring("GNUTELLA/0.6".length()).trim();
            int n2 = string3.indexOf(32);
            if (n2 == -1) {
                n2 = string3.length();
            }
            n = Integer.parseInt(string3.substring(0, n2));
            string = string3.substring(n2).trim();
        }
        catch (Exception exception) {
            Logger.logWarning((short)16, exception, "Error parsing response: '" + string2 + "'.");
            throw new ConnectionRejectedException("Error parsing response: '" + string2 + "'.");
        }
        return new HandshakeStatus(n, string, hTTPHeaders);
    }
}

