/*
 * Decompiled with CFR 0.152.
 */
package phex.dialogues;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import phex.common.ServiceManager;
import phex.gui.common.BaseFrame;

public class DlgNetwork
extends JDialog
implements KeyListener {
    private BaseFrame mFrame;
    private boolean mCancel;
    private JComboBox mNetworkCombo;
    private JCheckBox mAutoJoinCheck;

    public DlgNetwork(BaseFrame baseFrame) {
        super((Frame)baseFrame, true);
        this.mFrame = baseFrame;
        this.setTitle("Switch Network");
        this.setDefaultCloseOperation(1);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 0, 0));
        jPanel.add("Center", new JLabel("Enter the network name to join."));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(20, 20, 8, 20), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(16, 20, 20, 20)));
        this.mNetworkCombo = new JComboBox();
        this.mNetworkCombo.setEditable(true);
        this.mNetworkCombo.addActionListener(new ComboActionHandler());
        this.mAutoJoinCheck = new JCheckBox("Join the network automatically at start up.", ServiceManager.sCfg.mAutoJoin);
        jPanel3.add("North", new JLabel("Network Name:"));
        jPanel3.add("Center", this.mNetworkCombo);
        jPanel3.add("South", this.mAutoJoinCheck);
        jPanel2.add("Center", jPanel3);
        this.getContentPane().add("North", jPanel);
        this.getContentPane().add("Center", jPanel2);
        JPanel jPanel4 = new JPanel(new FlowLayout());
        JButton jButton = new JButton("Join");
        JButton jButton2 = new JButton("Cancel");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!actionEvent.getActionCommand().equals("Cancel")) {
                    if (!DlgNetwork.this.doOk()) {
                        return;
                    }
                } else {
                    DlgNetwork.this.mCancel = true;
                }
                DlgNetwork.this.setVisible(false);
            }
        };
        jButton.addActionListener(actionListener);
        jButton.setMnemonic('J');
        jButton2.addActionListener(actionListener);
        jButton2.setMnemonic('C');
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        this.getContentPane().add("South", jPanel4);
        this.addKeyListener(this);
        this.mNetworkCombo.addItem("<General Gnutella Network>");
        int n = 0;
        while (n < ServiceManager.sCfg.mNetNetworkHistory.size()) {
            this.mNetworkCombo.addItem(ServiceManager.sCfg.mNetNetworkHistory.elementAt(n));
            ++n;
        }
        this.mNetworkCombo.setSelectedItem(ServiceManager.sCfg.mCurrentNetwork);
        this.pack();
        BaseFrame.centerWindow(this, new Point(0, 0));
    }

    public boolean getCancel() {
        return this.mCancel;
    }

    private boolean doOk() {
        String string = ((String)this.mNetworkCombo.getEditor().getItem()).trim();
        if (string.length() == 0) {
            string = "<General Gnutella Network>";
        }
        ServiceManager.sCfg.mCurrentNetwork = string;
        ServiceManager.sCfg.mAutoJoin = this.mAutoJoinCheck.isSelected();
        int n = 0;
        while (n < ServiceManager.sCfg.mNetNetworkHistory.size()) {
            if (string.equals(ServiceManager.sCfg.mNetNetworkHistory.elementAt(n))) break;
            ++n;
        }
        if (!string.equals("<General Gnutella Network>") && n == ServiceManager.sCfg.mNetNetworkHistory.size()) {
            ServiceManager.sCfg.mNetNetworkHistory.insertElementAt(string, 0);
        }
        if (ServiceManager.sCfg.mNetNetworkHistory.size() > 20) {
            ServiceManager.sCfg.mNetNetworkHistory.removeElementAt(20);
        }
        ServiceManager.sCfg.save();
        this.mCancel = false;
        return true;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.mCancel = true;
            this.setVisible(false);
        } else if (keyEvent.getKeyCode() == 10) {
            if (!this.doOk()) {
                return;
            }
            this.mCancel = false;
            this.setVisible(false);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private class ComboActionHandler
    implements ActionListener {
        private ComboActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ((String)DlgNetwork.this.mNetworkCombo.getEditor().getItem()).trim();
        }
    }
}

