/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import java.io.File;
import javax.xml.bind.JAXBException;
import phex.common.FileHandlingException;
import phex.common.ServiceManager;
import phex.download.IDownloadSegment;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadConstants;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadWorker;
import phex.utils.FileUtils;
import phex.utils.Logger;
import phex.xml.ObjectFactory;
import phex.xml.XJBSWDownloadSegment;

public class SWDownloadSegment
implements IDownloadSegment,
SWDownloadConstants {
    private Long startPos;
    private long transferDataSize;
    private long transferredDataSize;
    private long sessionTransferRateBytes;
    private long mergeLengthBoundary;
    private int segmentNumber;
    private long transferRateTimestamp;
    private int transferRateBytes;
    private int transferRate;
    private Integer currentProgress;
    private File incompleteFile;
    private SWDownloadSegment nextSegment;
    private SWDownloadFile downloadFile;
    private SWDownloadWorker worker;
    private SWDownloadCandidate downloadCandidate;
    private long transferStartTime;
    private long transferStopTime;
    private boolean isFixedSizeSegment;

    public SWDownloadSegment(SWDownloadFile sWDownloadFile, int n, long l, long l2) {
        this.downloadFile = sWDownloadFile;
        this.segmentNumber = n;
        this.startPos = new Long(l);
        this.transferDataSize = l2;
        this.transferredDataSize = 0L;
        this.currentProgress = new Integer(0);
        this.initTransferredDataSize();
        this.mergeLengthBoundary = this.transferDataSize - 32768L;
        ServiceManager.getTransferRateService().registerTransferDataProvider(this);
    }

    public SWDownloadSegment(SWDownloadFile sWDownloadFile, XJBSWDownloadSegment xJBSWDownloadSegment) {
        this(sWDownloadFile, xJBSWDownloadSegment.getSegmentNumber(), xJBSWDownloadSegment.getStartPosition(), xJBSWDownloadSegment.getLength());
        String string = xJBSWDownloadSegment.getIncompleteFileName();
        if (string != null) {
            this.incompleteFile = new File(xJBSWDownloadSegment.getIncompleteFileName());
            this.initTransferredDataSize();
        }
    }

    public long getTransferStartPosition() {
        return this.startPos + this.transferredDataSize;
    }

    public long getStartOffset() {
        return this.startPos;
    }

    public Long getStartOffsetObject() {
        return this.startPos;
    }

    public long getEndOffset() {
        return this.startPos + this.transferDataSize;
    }

    public long getTransferredDataSize() {
        return this.transferredDataSize;
    }

    public long getTransferDataSizeLeft() {
        return this.transferDataSize - this.transferredDataSize;
    }

    public long getTransferDataSize() {
        return this.transferDataSize;
    }

    public long getTotalDataSize() {
        return this.getTransferDataSize();
    }

    public void setTransferDataSize(long l) {
        this.transferDataSize = l;
        this.mergeLengthBoundary = this.transferDataSize - 32768L;
        this.fireSegmentChange();
    }

    public void setTransferredDataSize(long l) {
        boolean bl;
        long l2 = l - this.transferredDataSize;
        this.transferRateBytes = (int)((long)this.transferRateBytes + l2);
        this.sessionTransferRateBytes += l2;
        if (l < this.transferredDataSize) {
            try {
                throw new Exception();
            }
            catch (Exception exception) {
                Logger.logError(exception);
            }
        }
        this.transferredDataSize = l;
        if (this.transferredDataSize > this.mergeLengthBoundary && this.mergeLengthBoundary != -1L && !(bl = this.downloadFile.mergeSegmentWithNext(this))) {
            this.mergeLengthBoundary = -1L;
        }
        this.fireSegmentChange();
    }

    public short getDataTransferStatus() {
        return 11;
    }

    public void setTransferRateTimestamp(long l) {
        this.transferRateTimestamp = l;
        this.transferRateBytes = 0;
    }

    public int getShortTermTransferRate() {
        if (this.transferRateTimestamp != 0L) {
            double d = (System.currentTimeMillis() - this.transferRateTimestamp) / 1000L;
            if ((this.transferRateBytes > 0 || d > 1.0) && d != 0.0) {
                this.transferRate = (int)((double)this.transferRateBytes / d);
            }
        }
        return this.transferRate;
    }

    public int getLongTermTransferRate() {
        long l = this.transferStopTime != 0L ? (this.transferStopTime - this.transferStartTime) / 1000L : (System.currentTimeMillis() - this.transferStartTime) / 1000L;
        return (int)(this.sessionTransferRateBytes / (l + 1L));
    }

    public void downloadStartNotify() {
        this.transferRateTimestamp = this.transferStartTime = System.currentTimeMillis();
        this.transferStopTime = 0L;
        this.sessionTransferRateBytes = 0L;
    }

    public void downloadStopNotify() {
        if (this.transferStopTime == 0L) {
            this.transferStopTime = System.currentTimeMillis();
        }
    }

    public Integer getProgress() {
        long l = this.getTransferDataSize();
        if (l == 0L) {
            l = 1L;
        }
        int n = (int)(this.getTransferredDataSize() * 100L / l);
        if (this.currentProgress != n) {
            this.currentProgress = new Integer(n);
        }
        return this.currentProgress;
    }

    public void setNextDownloadSegment(SWDownloadSegment sWDownloadSegment) {
        this.nextSegment = sWDownloadSegment;
    }

    public SWDownloadSegment getNextDownloadSegment() {
        return this.nextSegment;
    }

    public boolean isAbleToBeAllocated() {
        Logger.logMessage(Logger.INFO, (short)2, "isAbleToBeAllocated " + (this.worker == null) + "  " + (this.transferDataSize > this.transferredDataSize));
        return this.worker == null && this.transferDataSize > this.transferredDataSize;
    }

    public void setAllocatedByWorker(SWDownloadWorker sWDownloadWorker) {
        this.worker = sWDownloadWorker;
    }

    public SWDownloadWorker getAllocatedByWorker() {
        return this.worker;
    }

    public void setFixedSizeSegment(boolean bl) {
        this.isFixedSizeSegment = bl;
    }

    public boolean isFixedSizeSegment() {
        return this.isFixedSizeSegment;
    }

    public File getIncompleteFile() {
        this.initIncompleteFile();
        return this.incompleteFile;
    }

    public void removeDownloadDestinationFile() {
        boolean bl;
        if (this.worker != null) {
            this.logMessage(Logger.WARNING, "Can't remove download destination file if worker is allocated.");
        }
        if (this.incompleteFile != null && this.incompleteFile.exists() && !(bl = this.incompleteFile.delete())) {
            this.logMessage(Logger.FINE, "Failed to delete " + this.incompleteFile + ".");
        }
    }

    public void renameToDestinationRoot(File file) throws FileHandlingException {
        this.initIncompleteFile();
        File file2 = SWDownloadSegment.createIncompleteFile(file, this);
        if (this.incompleteFile.exists()) {
            FileUtils.renameLocalFile(this.incompleteFile, file2);
        }
        this.incompleteFile = file2;
    }

    public void associateDownloadCandidate(SWDownloadCandidate sWDownloadCandidate) {
        this.downloadCandidate = sWDownloadCandidate;
    }

    public XJBSWDownloadSegment createXJBSWDownloadSegment() throws JAXBException {
        XJBSWDownloadSegment xJBSWDownloadSegment = ObjectFactory.createXJBSWDownloadSegment();
        xJBSWDownloadSegment.setSegmentNumber(this.segmentNumber);
        xJBSWDownloadSegment.setLength(this.transferDataSize);
        xJBSWDownloadSegment.setStartPosition(this.startPos);
        if (this.incompleteFile != null) {
            xJBSWDownloadSegment.setIncompleteFileName(this.incompleteFile.getAbsolutePath());
        }
        return xJBSWDownloadSegment;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[#");
        stringBuffer.append(this.segmentNumber);
        stringBuffer.append(", ");
        stringBuffer.append(this.startPos);
        stringBuffer.append(", ");
        stringBuffer.append(this.transferredDataSize);
        stringBuffer.append('/');
        stringBuffer.append(this.transferDataSize);
        stringBuffer.append(", ");
        stringBuffer.append(this.worker);
        if (this.nextSegment != null) {
            stringBuffer.append(" -> #");
            stringBuffer.append(this.nextSegment.segmentNumber);
            stringBuffer.append(", ");
            stringBuffer.append(this.nextSegment.startPos);
            stringBuffer.append(", ");
            stringBuffer.append(this.nextSegment.transferredDataSize);
            stringBuffer.append('/');
            stringBuffer.append(this.nextSegment.transferDataSize);
            stringBuffer.append(", ");
            stringBuffer.append(this.nextSegment.worker);
        }
        stringBuffer.append("]@");
        stringBuffer.append(this.hashCode());
        return stringBuffer.toString();
    }

    public void logMessage(Logger.LogLevel logLevel, String string) {
        Logger.logMessage(logLevel, (short)2, "Segment " + this.toString() + ": " + string);
    }

    protected void mergeWithNextSegment() {
        Logger.logMessage(Logger.FINE, (short)2, "Merging " + this + " with " + this.nextSegment);
        long l = this.transferDataSize + this.nextSegment.transferDataSize;
        this.setTransferDataSize(l);
        this.transferredDataSize = l = this.transferredDataSize + this.nextSegment.transferredDataSize;
        this.nextSegment = this.nextSegment.nextSegment;
        Logger.logMessage(Logger.FINE, (short)2, "Merge result: " + this);
    }

    private void initIncompleteFile() {
        if (this.incompleteFile != null) {
            return;
        }
        File file = this.downloadFile.getDestinationFile();
        this.incompleteFile = SWDownloadSegment.createIncompleteFile(file, this);
    }

    private static File createIncompleteFile(File file, SWDownloadSegment sWDownloadSegment) {
        File file2;
        int n = 0;
        do {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(ServiceManager.sCfg.incompleteDir);
            stringBuffer.append(File.separatorChar);
            stringBuffer.append("sg").append(sWDownloadSegment.segmentNumber);
            if (n > 0) {
                stringBuffer.append('(');
                stringBuffer.append(String.valueOf(n));
                stringBuffer.append(')');
            }
            stringBuffer.append(file.getName());
            if (sWDownloadSegment.startPos != 0L) {
                stringBuffer.append(".sg");
            }
            file2 = new File(stringBuffer.toString());
            ++n;
        } while (file2.exists());
        return file2;
    }

    private void initTransferredDataSize() {
        this.initIncompleteFile();
        if (this.incompleteFile.exists()) {
            this.transferredDataSize = this.incompleteFile.length();
        }
    }

    private void fireSegmentChange() {
        this.downloadFile.fireDownloadSegmentChanged(this);
        if (this.downloadCandidate != null) {
            // empty if block
        }
    }
}

