/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import phex.common.Environment;
import phex.common.IPCounter;
import phex.common.Manager;
import phex.common.ServiceManager;
import phex.common.ThreadTracking;
import phex.common.TransferRateService;
import phex.common.URN;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSet;
import phex.download.swarming.SWDownloadWorker;
import phex.event.AsynchronousDispatcher;
import phex.event.DownloadFilesChangeListener;
import phex.utils.FileUtils;
import phex.utils.Logger;
import phex.utils.VersionUtils;
import phex.xml.ObjectFactory;
import phex.xml.XJBOldDownloadFile;
import phex.xml.XJBOldDownloadList;
import phex.xml.XJBOldRemoteFile;
import phex.xml.XJBPhex;
import phex.xml.XJBSWDownloadFile;
import phex.xml.XJBSWDownloadList;
import phex.xml.XMLBuilder;

public class SwarmingManager
implements Manager {
    public static final short PRIORITY_MOVE_TO_TOP = 0;
    public static final short PRIORITY_MOVE_UP = 1;
    public static final short PRIORITY_MOVE_DOWN = 2;
    public static final short PRIORITY_MOVE_TO_BOTTOM = 3;
    private short workerCount;
    private ArrayList downloadList;
    private TransferRateService transferRateService;
    private IPCounter ipDownloadCounter;
    private SWDownloadWorker temporaryWorker;
    private static Object saveDownloadListLock = new Object();
    private SaveDownloadListJob saveDownloadListJob;
    private static SwarmingManager instance;
    private ArrayList listenerList = new ArrayList(2);

    private SwarmingManager() {
    }

    public static SwarmingManager getInstance() {
        if (instance == null) {
            instance = new SwarmingManager();
        }
        return instance;
    }

    public boolean initialize() {
        this.workerCount = 0;
        this.downloadList = new ArrayList(5);
        this.transferRateService = ServiceManager.getTransferRateService();
        this.ipDownloadCounter = new IPCounter(ServiceManager.sCfg.maxDownloadsPerIP);
        return true;
    }

    public boolean onPostInitialization() {
        this.loadDownloadList();
        return true;
    }

    public void shutdown() {
        this.forceSaveDownloadList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SWDownloadFile addFileToDownload(RemoteFile remoteFile, String string, String string2) {
        int n;
        SWDownloadFile sWDownloadFile = new SWDownloadFile(string, string2, remoteFile.getFileSize(), remoteFile.getURN());
        sWDownloadFile.addDownloadCandidate(remoteFile);
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            n = this.downloadList.size();
            this.downloadList.add(n, sWDownloadFile);
        }
        this.fireDownloadFileAdded(n);
        sWDownloadFile.setStatus((short)1);
        this.createRequiredWorker();
        this.triggerSaveDownloadList();
        return sWDownloadFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadFile(SWDownloadFile sWDownloadFile) {
        sWDownloadFile.stopDownload();
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            int n = this.downloadList.indexOf(sWDownloadFile);
            if (n >= 0) {
                this.downloadList.remove(n);
                this.fireDownloadFileRemoved(n);
            }
        }
        sWDownloadFile.removeDownloadSegmentFiles();
        this.triggerSaveDownloadList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadFiles(SWDownloadFile[] sWDownloadFileArray) {
        int n = 0;
        while (n < sWDownloadFileArray.length) {
            sWDownloadFileArray[n].stopDownload();
            ArrayList arrayList = this.downloadList;
            synchronized (arrayList) {
                int n2 = this.downloadList.indexOf(sWDownloadFileArray[n]);
                if (n2 >= 0) {
                    this.downloadList.remove(n2);
                    this.fireDownloadFileRemoved(n2);
                }
            }
            sWDownloadFileArray[n].removeDownloadSegmentFiles();
            ++n;
        }
        this.triggerSaveDownloadList();
    }

    public Integer getDownloadPriority(SWDownloadFile sWDownloadFile) {
        int n = this.downloadList.indexOf(sWDownloadFile);
        if (n >= 0) {
            return new Integer(n);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moveDownloadFilePriority(SWDownloadFile sWDownloadFile, short s) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            int n = this.downloadList.indexOf(sWDownloadFile);
            if (n >= 0) {
                int n2 = n;
                switch (s) {
                    case 1: {
                        --n2;
                        break;
                    }
                    case 2: {
                        ++n2;
                        break;
                    }
                    case 0: {
                        n2 = 0;
                        break;
                    }
                    case 3: {
                        n2 = this.downloadList.size() - 1;
                    }
                }
                if (n2 < 0 || n2 >= this.downloadList.size()) {
                    return n;
                }
                this.downloadList.remove(n);
                this.downloadList.add(n2, sWDownloadFile);
                this.fireDownloadFileRemoved(n);
                this.fireDownloadFileAdded(n2);
                return n2;
            }
            return n;
        }
    }

    public int getDownloadFileCount() {
        return this.downloadList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDownloadFileCount(int n) {
        int n2 = 0;
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            Iterator iterator = this.downloadList.iterator();
            while (iterator.hasNext()) {
                SWDownloadFile sWDownloadFile = (SWDownloadFile)iterator.next();
                if (sWDownloadFile.getStatus() != n) continue;
                ++n2;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWDownloadFile getDownloadFile(int n) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            if (n < 0 || n >= this.downloadList.size()) {
                return null;
            }
            return (SWDownloadFile)this.downloadList.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWDownloadFile[] getDownloadFilesAt(int[] nArray) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            int n = nArray.length;
            SWDownloadFile[] sWDownloadFileArray = new SWDownloadFile[n];
            int n2 = 0;
            while (n2 < n) {
                sWDownloadFileArray[n2] = (SWDownloadFile)this.downloadList.get(nArray[n2]);
                ++n2;
            }
            return sWDownloadFileArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWDownloadFile[] getDownloadFiles(long l, URN uRN) {
        SWDownloadFile[] sWDownloadFileArray;
        ArrayList<SWDownloadFile> arrayList = new ArrayList<SWDownloadFile>(2);
        ArrayList arrayList2 = this.downloadList;
        synchronized (arrayList2) {
            sWDownloadFileArray = this.downloadList.iterator();
            while (sWDownloadFileArray.hasNext()) {
                SWDownloadFile sWDownloadFile = (SWDownloadFile)sWDownloadFileArray.next();
                if (sWDownloadFile.getTotalDataSize() != l) continue;
                URN uRN2 = sWDownloadFile.getFileURN();
                if (uRN != null && uRN2 != null && !uRN.equals(uRN2)) continue;
                arrayList.add(sWDownloadFile);
            }
        }
        sWDownloadFileArray = new SWDownloadFile[arrayList.size()];
        arrayList.toArray(sWDownloadFileArray);
        return sWDownloadFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWDownloadFile getDownloadFileByURN(URN uRN) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            Iterator iterator = this.downloadList.iterator();
            while (iterator.hasNext()) {
                SWDownloadFile sWDownloadFile = (SWDownloadFile)iterator.next();
                URN uRN2 = sWDownloadFile.getFileURN();
                if (uRN != null && uRN2 != null && !uRN.equals(uRN2)) continue;
                return sWDownloadFile;
            }
        }
        return null;
    }

    public void releaseCandidateIP(SWDownloadCandidate sWDownloadCandidate) {
        this.ipDownloadCounter.relaseIP(sWDownloadCandidate.getHostAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SWDownloadSet allocateDownloadSet(SWDownloadWorker sWDownloadWorker) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            SWDownloadFile sWDownloadFile = null;
            SWDownloadCandidate sWDownloadCandidate = null;
            Iterator iterator = this.downloadList.iterator();
            while (iterator.hasNext()) {
                sWDownloadFile = (SWDownloadFile)iterator.next();
                if (!sWDownloadFile.isAbleToBeAllocated() || (sWDownloadCandidate = sWDownloadFile.allocateDownloadCandidate(sWDownloadWorker)) == null) continue;
                boolean bl = this.ipDownloadCounter.validateAndCountIP(sWDownloadCandidate.getHostAddress());
                if (!bl) {
                    sWDownloadFile.releaseDownloadCandidate(sWDownloadCandidate);
                    continue;
                }
                boolean bl2 = sWDownloadFile.isDownloadSegmentAllocateable(sWDownloadCandidate.getAvailableRangeSet());
                if (!bl2) {
                    sWDownloadFile.releaseDownloadCandidate(sWDownloadCandidate);
                    continue;
                }
                sWDownloadFile.incrementWorkerCount();
                SWDownloadSet sWDownloadSet = new SWDownloadSet(sWDownloadFile, sWDownloadCandidate);
                if (sWDownloadWorker == this.temporaryWorker) {
                    this.unsetTemporaryWorker();
                }
                return sWDownloadSet;
            }
        }
        return null;
    }

    public boolean isNewLocalFilenameUsed(SWDownloadFile sWDownloadFile, File file) {
        int n = this.downloadList.size();
        int n2 = 0;
        while (n2 < n) {
            SWDownloadFile sWDownloadFile2 = (SWDownloadFile)this.downloadList.get(n2);
            if ((sWDownloadFile == null || sWDownloadFile2 != sWDownloadFile) && sWDownloadFile2.getDestinationFile().compareTo(file) == 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void loadDownloadList() {
        Logger.logMessage(Logger.CONFIG, (short)2, "Loading download list...");
        File file = Environment.getInstance().getPhexConfigFile("phexdownload.xml");
        File file2 = new File(file.getAbsolutePath() + ".bak");
        if (!file.exists() && !file2.exists()) {
            Logger.logMessage(Logger.FINE, (short)2, "No download list file found.");
            return;
        }
        try {
            Logger.logMessage(Logger.FINER, (short)2, "Try to load from default download list.");
            XJBPhex xJBPhex = XMLBuilder.loadXJBPhexFromFile(file);
            if (xJBPhex == null) {
                Logger.logMessage(Logger.FINER, (short)2, "Try to load from backup download list.");
                xJBPhex = XMLBuilder.loadXJBPhexFromFile(file2);
            }
            if (xJBPhex == null) {
                Logger.logMessage(Logger.SEVERE, (short)255, "Error loading download list.");
                return;
            }
            XJBOldDownloadList xJBOldDownloadList = xJBPhex.getDownloadList();
            if (xJBOldDownloadList != null) {
                this.updateOldXJBDownloadList(xJBOldDownloadList);
            } else {
                XJBSWDownloadList xJBSWDownloadList = xJBPhex.getSWDownloadList();
                if (xJBSWDownloadList != null) {
                    this.loadXJBSWDownloadList(xJBSWDownloadList);
                } else {
                    Logger.logMessage(Logger.FINE, (short)2, "No SWDownloadList found.");
                }
            }
        }
        catch (JAXBException jAXBException) {
            Logger.logError(jAXBException);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerSaveDownloadList() {
        Object object = saveDownloadListLock;
        synchronized (object) {
            if (this.saveDownloadListJob != null) {
                this.saveDownloadListJob.triggerFollowUpSave();
            } else {
                this.saveDownloadListJob = new SaveDownloadListJob();
                this.saveDownloadListJob.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceSaveDownloadList() {
        Object object = saveDownloadListLock;
        synchronized (object) {
            if (this.saveDownloadListJob == null) {
                this.saveDownloadListJob = new SaveDownloadListJob();
                this.saveDownloadListJob.start();
            } else {
                this.saveDownloadListJob.triggerFollowUpSave();
            }
        }
        try {
            this.saveDownloadListJob.join();
        }
        catch (InterruptedException interruptedException) {
            Logger.logError(interruptedException);
        }
    }

    private synchronized void unsetTemporaryWorker() {
        this.temporaryWorker.setTemporaryWorker(false);
        this.temporaryWorker = null;
        this.createNewTemporaryWorker();
    }

    private synchronized void createNewTemporaryWorker() {
        if (this.workerCount < ServiceManager.sCfg.maxTotalDownloadWorker) {
            this.temporaryWorker = new SWDownloadWorker();
            this.temporaryWorker.setTemporaryWorker(true);
            Logger.logMessage(Logger.FINE, (short)2, "Creating new worker: " + this.temporaryWorker);
            this.temporaryWorker.startWorker();
            this.workerCount = (short)(this.workerCount + 1);
        }
    }

    public synchronized void createRequiredWorker() {
        if (this.temporaryWorker == null) {
            this.createNewTemporaryWorker();
        }
    }

    public synchronized void notifyWaitingWorkers() {
        this.notifyAll();
    }

    public synchronized void waitForNotify() {
        try {
            this.wait(1000L);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public synchronized boolean checkToStopWorker(SWDownloadWorker sWDownloadWorker) {
        int n = Math.min(this.downloadList.size() * ServiceManager.sCfg.maxWorkerPerDownload, ServiceManager.sCfg.maxTotalDownloadWorker);
        if (this.workerCount > n) {
            if (sWDownloadWorker.isRunning()) {
                sWDownloadWorker.stopWorker();
                this.workerCount = (short)(this.workerCount - 1);
                if (sWDownloadWorker.isTemporaryWorker()) {
                    this.temporaryWorker = null;
                }
            }
            return true;
        }
        return false;
    }

    public void notifyWorkerShoutdown(SWDownloadWorker sWDownloadWorker) {
        Logger.logMessage(Logger.FINE, (short)2, "Unexpected worker shutdown: " + sWDownloadWorker);
        sWDownloadWorker.stopWorker();
        this.workerCount = (short)(this.workerCount - 1);
        if (sWDownloadWorker.isTemporaryWorker()) {
            this.temporaryWorker = null;
        }
        this.createRequiredWorker();
    }

    private void updateOldXJBDownloadList(XJBOldDownloadList xJBOldDownloadList) throws JAXBException {
        Logger.logMessage(Logger.FINE, (short)2, "Updating old download list.");
        XJBSWDownloadList xJBSWDownloadList = ObjectFactory.createXJBSWDownloadList();
        List list = xJBSWDownloadList.getSWDownloadFileList();
        Iterator iterator = xJBOldDownloadList.getDownloadFileList().iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            XJBOldDownloadFile xJBOldDownloadFile = (XJBOldDownloadFile)iterator.next();
            XJBSWDownloadFile xJBSWDownloadFile = ObjectFactory.createXJBSWDownloadFile();
            xJBSWDownloadFile.setFileSize(xJBOldDownloadFile.getFileSize());
            xJBSWDownloadFile.setLocalFileName(xJBOldDownloadFile.getLocalFileName());
            xJBSWDownloadFile.setSearchTerm(xJBOldDownloadFile.getSearchTerm());
            xJBSWDownloadFile.setStatus((short)1);
            List list2 = xJBSWDownloadFile.getCandidateList();
            Iterator iterator2 = xJBOldDownloadFile.getRemoteFileList().iterator();
            while (iterator2.hasNext()) {
                object2 = (XJBOldRemoteFile)iterator2.next();
                object = ObjectFactory.createXJBSWDownloadCandidate();
                object.setFileIndex(object2.getFileIndex());
                object.setFileName(object2.getFileName());
                object.setGUID(object2.getGuid());
                object.setRemoteHost(object2.getRemoteHost());
                list2.add(object);
            }
            object2 = ServiceManager.sCfg.incompleteDir + File.separator + FileUtils.convertToLocalSystemFilename(xJBOldDownloadFile.getLocalFileName()) + ".dl";
            object = ObjectFactory.createXJBSWDownloadSegment();
            object.setIncompleteFileName(new File((String)object2).getAbsolutePath());
            object.setLength(xJBOldDownloadFile.getFileSize());
            object.setSegmentNumber(0);
            object.setStartPosition(0L);
            xJBSWDownloadFile.getSegmentList().add(object);
            list.add(xJBSWDownloadFile);
        }
        this.loadXJBSWDownloadList(xJBSWDownloadList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadXJBSWDownloadList(XJBSWDownloadList xJBSWDownloadList) throws JAXBException {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            Logger.logMessage(Logger.FINER, (short)2, "Loading SWDownload xml");
            this.downloadList.clear();
            Iterator iterator = xJBSWDownloadList.getSWDownloadFileList().iterator();
            while (iterator.hasNext()) {
                try {
                    XJBSWDownloadFile xJBSWDownloadFile = (XJBSWDownloadFile)iterator.next();
                    SWDownloadFile sWDownloadFile = new SWDownloadFile(xJBSWDownloadFile);
                    int n = this.downloadList.size();
                    this.downloadList.add(n, sWDownloadFile);
                    Logger.logMessage(Logger.FINER, (short)2, "Loaded SWDownloadFile: " + sWDownloadFile);
                    this.fireDownloadFileAdded(n);
                }
                catch (Exception exception) {
                    Logger.logError(exception, "Error loading a download file from XML.");
                }
            }
            this.createRequiredWorker();
        }
    }

    public void addDownloadFilesChangeListener(DownloadFilesChangeListener downloadFilesChangeListener) {
        this.listenerList.add(downloadFilesChangeListener);
    }

    public void removeDownloadFilesChangeListener(DownloadFilesChangeListener downloadFilesChangeListener) {
        this.listenerList.remove(downloadFilesChangeListener);
    }

    private void fireDownloadFileChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SwarmingManager.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    DownloadFilesChangeListener downloadFilesChangeListener = (DownloadFilesChangeListener)objectArray[n2];
                    downloadFilesChangeListener.downloadFileChanged(n);
                    --n2;
                }
            }
        });
    }

    private void fireDownloadFileAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SwarmingManager.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    DownloadFilesChangeListener downloadFilesChangeListener = (DownloadFilesChangeListener)objectArray[n2];
                    downloadFilesChangeListener.downloadFileAdded(n);
                    --n2;
                }
            }
        });
    }

    private void fireDownloadFileRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SwarmingManager.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    DownloadFilesChangeListener downloadFilesChangeListener = (DownloadFilesChangeListener)objectArray[n2];
                    downloadFilesChangeListener.downloadFileRemoved(n);
                    --n2;
                }
            }
        });
    }

    public void fireDownloadFileChanged(SWDownloadFile sWDownloadFile) {
        int n = this.downloadList.indexOf(sWDownloadFile);
        if (n >= 0) {
            this.fireDownloadFileChanged(n);
        }
    }

    private class SaveDownloadListJob
    extends Thread {
        private boolean isFollowUpSaveTriggered;

        public SaveDownloadListJob() {
            super(ThreadTracking.rootThreadGroup, "SaveDownloadListJob");
        }

        public void triggerFollowUpSave() {
            this.isFollowUpSaveTriggered = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            do {
                Logger.logMessage(Logger.CONFIG, (short)8, "Saving download list...");
                this.isFollowUpSaveTriggered = false;
                try {
                    object = ObjectFactory.createPhexElement();
                    XJBSWDownloadList xJBSWDownloadList = this.createXJBSWDownloadList();
                    object.setSWDownloadList(xJBSWDownloadList);
                    object.setPhexVersion(VersionUtils.getProgramVersion());
                    File file = Environment.getInstance().getPhexConfigFile("phexdownload.xml");
                    File file2 = new File(file.getAbsolutePath() + ".bak");
                    XMLBuilder.saveToFile(file2, (XJBPhex)object);
                    FileUtils.copyFile(file2, file);
                    file2.delete();
                }
                catch (JAXBException jAXBException) {
                    Logger.logError(jAXBException);
                }
                catch (IOException iOException) {
                    Logger.logError(iOException);
                }
            } while (this.isFollowUpSaveTriggered);
            object = saveDownloadListLock;
            synchronized (object) {
                SwarmingManager.this.saveDownloadListJob = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private XJBSWDownloadList createXJBSWDownloadList() throws JAXBException {
            XJBSWDownloadList xJBSWDownloadList = ObjectFactory.createXJBSWDownloadList();
            ArrayList arrayList = SwarmingManager.this.downloadList;
            synchronized (arrayList) {
                Iterator iterator = SwarmingManager.this.downloadList.iterator();
                List list = xJBSWDownloadList.getSWDownloadFileList();
                while (iterator.hasNext()) {
                    SWDownloadFile sWDownloadFile = (SWDownloadFile)iterator.next();
                    list.add(sWDownloadFile.createXJBSWDownloadFile());
                }
            }
            return xJBSWDownloadList;
        }
    }
}

