/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.xml.bind.JAXBException;
import phex.chat.ChatManager;
import phex.common.ExpiryDate;
import phex.event.SharedFilesChangeListener;
import phex.event.UploadFilesChangeListener;
import phex.gui.actions.FWAction;
import phex.gui.common.BrowserLauncher;
import phex.gui.common.FWTable;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.MainFrame;
import phex.gui.models.FWSortedTableModel;
import phex.gui.models.FWTableColumnModel;
import phex.gui.models.SharedFilesTableModel;
import phex.gui.models.UploadFilesTableModel;
import phex.gui.tabs.FWTab;
import phex.query.QueryManager;
import phex.query.SearchContainer;
import phex.security.PhexSecurityManager;
import phex.share.FileAdministration;
import phex.share.ShareManager;
import phex.upload.UploadManager;
import phex.upload.UploadState;
import phex.utils.Localizer;
import phex.utils.Logger;
import phex.utils.StrUtil;
import phex.utils.URLUtil;
import phex.xml.ObjectFactory;
import phex.xml.XJBGUISettings;
import phex.xml.XJBGUITable;
import phex.xml.XJBGUITableColumnList;

public class ShareTab
extends FWTab {
    private static final String UPLOAD_TABLE_IDENTIFIER = "UploadTable";
    private static final String SHARED_FILES_TABLE_IDENTIFIER = "SharedFilesTable";
    private static final UploadState[] EMPTY_UPLOADSTATE_ARRAY = new UploadState[0];
    private UploadManager uploadManager;
    private FileAdministration fileAdmin;
    private MainFrame mainFrame;
    private JLabel sharedFilesLabel;
    private FWTable uploadTable;
    private JScrollPane uploadTableScrollPane;
    private UploadFilesTableModel uploadModel;
    private FWTableColumnModel uploadColumnModel;
    private JPopupMenu uploadPopup;
    private FWTable sharedFilesTable;
    private JScrollPane sharedFilesTableScrollPane;
    private SharedFilesTableModel sharedFilesModel;
    private FWTableColumnModel sharedFilesColumnModel;

    public ShareTab(MainFrame mainFrame) {
        super(1004, Localizer.getString("Share"), GUIRegistry.getInstance().getIconFactory().getIcon("Upload"), Localizer.getString("TTTShare"), Localizer.getChar("ShareMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("ShareAccelerator")), 4);
        this.mainFrame = mainFrame;
        this.fileAdmin = ShareManager.getInstance().getFileAdministration();
        this.uploadManager = UploadManager.getInstance();
    }

    public void initComponent(XJBGUISettings xJBGUISettings) {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.uploadModel = new UploadFilesTableModel();
        XJBGUITable xJBGUITable = GUIUtils.getXJBGUITableByIdentifier(xJBGUISettings, UPLOAD_TABLE_IDENTIFIER);
        this.buildUploadTableColumnModel(xJBGUITable);
        MouseHandler mouseHandler = new MouseHandler();
        this.uploadTable = new FWTable((TableModel)new FWSortedTableModel(this.uploadModel), this.uploadColumnModel);
        this.uploadTable.activateAllHeaderActions();
        this.uploadTable.setAutoResizeMode(0);
        this.uploadTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.uploadTable.addMouseListener(mouseHandler);
        this.uploadTableScrollPane = FWTable.createFWTableScrollPane(this.uploadTable);
        this.uploadTableScrollPane.addMouseListener(mouseHandler);
        jPanel.add("Center", this.uploadTableScrollPane);
        GUIUtils.adjustTableProgresssBarHeight(this.uploadTable);
        FWToolBar fWToolBar = new FWToolBar(0);
        fWToolBar.setBorderPainted(false);
        fWToolBar.setFloatable(false);
        this.uploadPopup = new JPopupMenu();
        FWAction fWAction = new AbortUploadAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.uploadPopup.add(fWAction);
        fWAction = new RemoveUploadAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.uploadPopup.add(fWAction);
        fWAction = new ViewBitziTicketAction();
        this.addTabAction(fWAction);
        this.uploadPopup.add(fWAction);
        fWToolBar.addSeparator();
        this.uploadPopup.addSeparator();
        fWAction = new BrowseHostAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.uploadPopup.add(fWAction);
        fWAction = new ChatToHostAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.uploadPopup.add(fWAction);
        fWAction = new BanHostAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.uploadPopup.add(fWAction);
        fWToolBar.addSeparator();
        this.uploadPopup.addSeparator();
        fWAction = new ClearUploadsAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.uploadPopup.add(fWAction);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add("Center", jPanel);
        jPanel2.add("South", fWToolBar);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.getBackground().darker()), Localizer.getString("Uploads")));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.sharedFilesModel = new SharedFilesTableModel();
        xJBGUITable = GUIUtils.getXJBGUITableByIdentifier(xJBGUISettings, SHARED_FILES_TABLE_IDENTIFIER);
        this.buildSharedFilesTableColumnModel(xJBGUITable);
        this.sharedFilesTable = new FWTable((TableModel)new FWSortedTableModel(this.sharedFilesModel), this.sharedFilesColumnModel);
        this.sharedFilesTable.activateAllHeaderActions();
        this.sharedFilesTable.setAutoResizeMode(0);
        this.sharedFilesTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        JPanel jPanel4 = new JPanel(new FlowLayout());
        JButton jButton = new JButton(Localizer.getString("Rescan"));
        jPanel4.add(jButton);
        jButton.addActionListener(new ShareRescanHandler());
        this.sharedFilesLabel = new JLabel(" ");
        this.sharedFilesLabel.setHorizontalAlignment(4);
        this.fileAdmin.addSharedFilesChangeListener(new SharedFilesChangeHandler());
        jPanel3.add("North", this.sharedFilesLabel);
        this.sharedFilesTableScrollPane = FWTable.createFWTableScrollPane(this.sharedFilesTable);
        jPanel3.add("Center", this.sharedFilesTableScrollPane);
        jPanel3.add("South", jPanel4);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.getBackground().darker()), Localizer.getString("SharedFiles")));
        jPanel2.setPreferredSize(new Dimension(780, 230));
        jPanel3.setPreferredSize(new Dimension(780, 200));
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jSplitPane.setDividerSize(6);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setTopComponent(jPanel2);
        jSplitPane.setBottomComponent(jPanel3);
        this.add("Center", jSplitPane);
    }

    public void updateUI() {
        super.updateUI();
        if (this.uploadTable != null) {
            GUIUtils.adjustTableProgresssBarHeight(this.uploadTable);
        }
        if (this.uploadTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.uploadTableScrollPane);
        }
        if (this.sharedFilesTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.sharedFilesTableScrollPane);
        }
    }

    private UploadState[] getSelectedUploadStates() {
        int[] nArray = this.uploadTable.getSelectedRows();
        if (nArray.length == 0) {
            return EMPTY_UPLOADSTATE_ARRAY;
        }
        int[] nArray2 = this.uploadTable.convertRowIndicesToModel(nArray);
        UploadState[] uploadStateArray = this.uploadManager.getUploadStatesAt(nArray2);
        return uploadStateArray;
    }

    private UploadState getSelectedUploadState() {
        int n = this.uploadTable.getSelectedRow();
        int n2 = this.uploadTable.convertRowIndexToModel(n);
        UploadState uploadState = this.uploadManager.getUploadStateAt(n2);
        return uploadState;
    }

    private void buildUploadTableColumnModel(XJBGUITable xJBGUITable) {
        int[] nArray = new int[]{1001, 1002, 1003, 1004, 1005, 1006, 1007};
        XJBGUITableColumnList xJBGUITableColumnList = null;
        if (xJBGUITable != null) {
            xJBGUITableColumnList = xJBGUITable.getTableColumnList();
        }
        this.uploadColumnModel = new FWTableColumnModel(this.uploadModel, nArray, xJBGUITableColumnList);
    }

    private void buildSharedFilesTableColumnModel(XJBGUITable xJBGUITable) {
        int[] nArray = SharedFilesTableModel.getColumnIdArray();
        XJBGUITableColumnList xJBGUITableColumnList = null;
        if (xJBGUITable != null) {
            xJBGUITableColumnList = xJBGUITable.getTableColumnList();
        }
        this.sharedFilesColumnModel = new FWTableColumnModel(this.sharedFilesModel, nArray, xJBGUITableColumnList);
    }

    public void appendXJBGUISettings(XJBGUISettings xJBGUISettings) throws JAXBException {
        super.appendXJBGUISettings(xJBGUISettings);
        XJBGUITableColumnList xJBGUITableColumnList = this.uploadColumnModel.createXJBGUITableColumnList();
        XJBGUITable xJBGUITable = ObjectFactory.createXJBGUITable();
        xJBGUITable.setTableColumnList(xJBGUITableColumnList);
        xJBGUITable.setTableIdentifier(UPLOAD_TABLE_IDENTIFIER);
        xJBGUISettings.getTableList().getTableList().add(xJBGUITable);
        xJBGUITableColumnList = this.sharedFilesColumnModel.createXJBGUITableColumnList();
        xJBGUITable = ObjectFactory.createXJBGUITable();
        xJBGUITable.setTableColumnList(xJBGUITableColumnList);
        xJBGUITable.setTableIdentifier(SHARED_FILES_TABLE_IDENTIFIER);
        xJBGUISettings.getTableList().getTableList().add(xJBGUITable);
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (component == ShareTab.this.uploadTable || component == ShareTab.this.uploadTableScrollPane) {
                ShareTab.this.uploadPopup.show(component, n, n2);
            }
        }
    }

    private class SharedFilesChangeHandler
    implements SharedFilesChangeListener {
        private SharedFilesChangeHandler() {
        }

        public void sharedFileChanged(int n) {
        }

        public void sharedFileAdded(int n) {
            this.updateLabel();
        }

        public void sharedFileRemoved(int n) {
            this.updateLabel();
        }

        public void allSharedFilesChanged() {
            this.updateLabel();
        }

        private void updateLabel() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(');
            stringBuffer.append(ShareTab.this.fileAdmin.getFileCount());
            stringBuffer.append(" / ");
            stringBuffer.append(StrUtil.formatSizeBytes((long)ShareTab.this.fileAdmin.getTotalFileSizeInKb() * 1024L)).append(')');
            ShareTab.this.sharedFilesLabel.setText(stringBuffer.toString());
        }
    }

    private class UploadStateChangeHandler
    implements UploadFilesChangeListener {
        private UploadStateChangeHandler() {
        }

        public void uploadFileChanged(int n) {
            ShareTab.this.refreshTabActions();
        }

        public void uploadFileAdded(int n) {
            ShareTab.this.refreshTabActions();
        }

        public void uploadQueueChanged() {
        }

        public void uploadFileRemoved(int n) {
            ShareTab.this.refreshTabActions();
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                ShareTab.this.refreshTabActions();
            }
        }
    }

    private class ShareRescanHandler
    implements ActionListener {
        private ShareRescanHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShareManager.getInstance().getFileAdministration().rescan(true, true);
        }
    }

    class ClearUploadsAction
    extends FWAction {
        ClearUploadsAction() {
            super(Localizer.getString("ClearCompleted"), GUIRegistry.getInstance().getIconFactory().getIcon("Trash"), Localizer.getString("TTTClearCompleted"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShareTab.this.uploadManager.cleanUploadStateList();
        }

        public void refreshActionState() {
            if (ShareTab.this.uploadTable.getRowCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class BrowseHostAction
    extends FWAction {
        public BrowseHostAction() {
            super(Localizer.getString("BrowseHost"), GUIRegistry.getInstance().getIconFactory().getIcon("BrowseHost"), Localizer.getString("TTTBrowseHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UploadState uploadState = ShareTab.this.getSelectedUploadState();
            if (uploadState == null) {
                return;
            }
            SearchContainer searchContainer = QueryManager.getInstance().getSearchContainer();
            searchContainer.createBrowseHostSearch(uploadState.getHostAddress(), null);
            ShareTab.this.mainFrame.setSelectedTab(1001);
        }

        public void refreshActionState() {
            if (ShareTab.this.uploadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class ViewBitziTicketAction
    extends FWAction {
        public ViewBitziTicketAction() {
            super(Localizer.getString("ViewBitziTicket"), GUIRegistry.getInstance().getIconFactory().getIcon("Bitzi"), Localizer.getString("TTTViewBitziTicket"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                UploadState uploadState = ShareTab.this.getSelectedUploadState();
                if (uploadState == null) {
                    return;
                }
                String string = URLUtil.buildBitziLookupURL(uploadState.getFileURN());
                try {
                    BrowserLauncher.openURL(string);
                }
                catch (IOException iOException) {
                    Logger.logWarning(iOException);
                    Object[] objectArray = new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
                    int n = JOptionPane.showOptionDialog(ShareTab.this, Localizer.getString("FailedToLaunchBrowserURLInClipboard"), Localizer.getString("FailedToLaunchBrowser"), 0, 2, null, objectArray, Localizer.getString("Yes"));
                    if (n != 0) break block3;
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
                }
            }
        }

        public void refreshActionState() {
            if (ShareTab.this.uploadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class BanHostAction
    extends FWAction {
        BanHostAction() {
            super(Localizer.getString("BanHost"), GUIRegistry.getInstance().getIconFactory().getIcon("Ban"), Localizer.getString("TTTBanHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PhexSecurityManager phexSecurityManager = PhexSecurityManager.getInstance();
            UploadState[] uploadStateArray = ShareTab.this.getSelectedUploadStates();
            int n = 0;
            while (n < uploadStateArray.length) {
                if (uploadStateArray[n] != null) {
                    ShareTab.this.uploadManager.removeUploadState(uploadStateArray[n]);
                    try {
                        phexSecurityManager.createIPAccessRule(Localizer.getString("UserBanned"), true, (byte)1, uploadStateArray[n].getHostAddress().getHostIP(), null, false, ExpiryDate.SESSION_EXPIRY_DATE, true);
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
                ++n;
            }
            this.refreshActionState();
        }

        public void refreshActionState() {
            if (ShareTab.this.uploadTable.getRowCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class ChatToHostAction
    extends FWAction {
        public ChatToHostAction() {
            super(Localizer.getString("ChatToHost"), GUIRegistry.getInstance().getIconFactory().getIcon("Chat"), Localizer.getString("TTTChatToHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UploadState uploadState = ShareTab.this.getSelectedUploadState();
            if (uploadState == null) {
                return;
            }
            ChatManager.getInstance().openChat(uploadState.getHostAddress());
        }

        public void refreshActionState() {
            if (ShareTab.this.uploadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class RemoveUploadAction
    extends FWAction {
        RemoveUploadAction() {
            super(Localizer.getString("RemoveUpload"), GUIRegistry.getInstance().getIconFactory().getIcon("Close"), Localizer.getString("TTTRemoveUpload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UploadState[] uploadStateArray = ShareTab.this.getSelectedUploadStates();
            int n = 0;
            while (n < uploadStateArray.length) {
                if (uploadStateArray[n] != null) {
                    ShareTab.this.uploadManager.removeUploadState(uploadStateArray[n]);
                }
                ++n;
            }
            this.refreshActionState();
        }

        public void refreshActionState() {
            if (ShareTab.this.uploadTable.getRowCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class AbortUploadAction
    extends FWAction {
        AbortUploadAction() {
            super(Localizer.getString("AbortUpload"), GUIRegistry.getInstance().getIconFactory().getIcon("Stop"), Localizer.getString("TTTAbortUpload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UploadState[] uploadStateArray = ShareTab.this.getSelectedUploadStates();
            int n = 0;
            while (n < uploadStateArray.length) {
                if (uploadStateArray[n] != null && uploadStateArray[n].isUploadRunning()) {
                    uploadStateArray[n].stopUpload();
                }
                ++n;
            }
            this.refreshActionState();
        }

        public void refreshActionState() {
            UploadState[] uploadStateArray = ShareTab.this.getSelectedUploadStates();
            boolean bl = false;
            int n = 0;
            while (n < uploadStateArray.length) {
                if (uploadStateArray[n] != null && uploadStateArray[n].isUploadRunning()) {
                    bl = true;
                    break;
                }
                ++n;
            }
            this.setEnabled(bl);
        }
    }
}

