/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import phex.common.Environment;
import phex.common.ServiceManager;
import phex.event.AsynchronousDispatcher;
import phex.event.CaughtHostsChangeListener;
import phex.host.GWebCacheContainer;
import phex.host.HostAddress;
import phex.host.MalformedHostAddressException;
import phex.security.PhexSecurityManager;
import phex.utils.IPUtils;
import phex.utils.Logger;
import phex.utils.PriorityQueue;

public class CaughtHostsContainer {
    private static final HostAddress[] DEFAULT_STARTUP_HOSTS = new HostAddress[]{new HostAddress("connect1.gnutellanet.com", 6346), new HostAddress("connect2.gnutellanet.com", 6346), new HostAddress("connect3.gnutellanet.com", 6346), new HostAddress("connect4.gnutellanet.com", 6346), new HostAddress("connect1.bearshare.net", 6346), new HostAddress("connect2.bearshare.net", 6346), new HostAddress("connect3.bearshare.net", 6346)};
    public static final short HIGH_PRIORITY = 2;
    public static final short NORMAL_PRIORITY = 1;
    public static final short LOW_PRIORITY = 0;
    private PriorityQueue caughtHosts;
    private HashSet uniqueCaughtHosts;
    private ArrayList autoConnectHosts;
    private boolean hasChangedSinceLastSave;
    private ArrayList listenerList = new ArrayList(2);

    public CaughtHostsContainer() {
        int[] nArray = new int[3];
        nArray[2] = (int)Math.round((double)ServiceManager.sCfg.mNetMaxHostToCatch * 2.0 / 3.0);
        nArray[1] = (int)Math.round((double)(ServiceManager.sCfg.mNetMaxHostToCatch - nArray[2]) * 2.0 / 3.0);
        nArray[0] = ServiceManager.sCfg.mNetMaxHostToCatch - nArray[2] - nArray[1];
        this.caughtHosts = new PriorityQueue(nArray);
        this.autoConnectHosts = new ArrayList();
        this.uniqueCaughtHosts = new HashSet();
    }

    public void initializeCaughtHostsContainer() {
        this.caughtHosts.clear();
        this.removeAllAutoConnectHosts();
        this.hasChangedSinceLastSave = false;
        this.loadHostsFromFile();
        this.loadAutoConnectHostsFromFile();
    }

    public synchronized void addCaughtHost(HostAddress hostAddress, int n) {
        if (hostAddress.getPort() == -1) {
            return;
        }
        if (hostAddress.isLocalHost()) {
            return;
        }
        try {
            if (IPUtils.isInvalidIP(hostAddress.getHostIP())) {
                return;
            }
        }
        catch (UnknownHostException unknownHostException) {
            return;
        }
        if (IPUtils.isPortInUserInvalidList(hostAddress)) {
            return;
        }
        if (!this.uniqueCaughtHosts.contains(hostAddress)) {
            this.uniqueCaughtHosts.add(hostAddress);
            Object object = this.caughtHosts.addToHead(hostAddress, n);
            if (object != null) {
                this.uniqueCaughtHosts.remove(object);
            }
            this.hasChangedSinceLastSave = true;
            this.fireCaughtHostsChanged();
        }
    }

    public synchronized HostAddress getNextCaughtHost() {
        if (!this.caughtHosts.isEmpty()) {
            HostAddress hostAddress = (HostAddress)this.caughtHosts.removeMaxPriority();
            return hostAddress;
        }
        this.addAutoConnectHosts();
        if (!this.caughtHosts.isEmpty()) {
            HostAddress hostAddress = (HostAddress)this.caughtHosts.removeMaxPriority();
            return hostAddress;
        }
        return null;
    }

    public synchronized int getCaughtHostsCount() {
        return this.caughtHosts.getSize();
    }

    public synchronized int getAutoConnectHostsCount() {
        return this.autoConnectHosts.size();
    }

    public synchronized HostAddress getAutoConnectHostAt(int n) {
        if (n >= this.autoConnectHosts.size()) {
            return null;
        }
        return (HostAddress)this.autoConnectHosts.get(n);
    }

    public synchronized void removeAllAutoConnectHosts() {
        int n = this.autoConnectHosts.size() - 1;
        while (n >= 0) {
            this.removeAutoConnectHost((HostAddress)this.autoConnectHosts.get(n));
            --n;
        }
    }

    public synchronized void addAutoConnectHost(HostAddress hostAddress) {
        this.insertAutoConnectHost(hostAddress, this.autoConnectHosts.size());
    }

    private synchronized void insertAutoConnectHost(HostAddress hostAddress, int n) {
        if (!this.autoConnectHosts.contains(hostAddress)) {
            this.autoConnectHosts.add(n, hostAddress);
            this.hasChangedSinceLastSave = true;
            this.fireAutoConnectHostAdded(n);
        }
    }

    public synchronized void removeAutoConnectHost(HostAddress hostAddress) {
        int n = this.autoConnectHosts.indexOf(hostAddress);
        if (n >= 0) {
            this.autoConnectHosts.remove(n);
            this.fireAutoConnectHostRemoved(n);
            this.hasChangedSinceLastSave = true;
        }
    }

    public synchronized void resetCaughtHosts() {
        this.caughtHosts.clear();
        this.addAutoConnectHosts();
    }

    public synchronized void saveHostsContainer() {
        if (!this.hasChangedSinceLastSave) {
            return;
        }
        this.saveCaughtHosts();
        this.saveAutoConnectHosts();
        this.hasChangedSinceLastSave = false;
    }

    private synchronized void addAutoConnectHosts() {
        if (ServiceManager.sCfg.mCurrentNetwork.equals("<General Gnutella Network>")) {
            int n = this.autoConnectHosts.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                this.addCaughtHost((HostAddress)this.autoConnectHosts.get(n2), 2);
                --n2;
            }
            if (n == 0) {
                this.addDefaultAutoConnectHosts();
            }
            GWebCacheContainer.invokeQueryMoreHostsRequest();
        }
    }

    private synchronized void addDefaultAutoConnectHosts() {
        if (ServiceManager.sCfg.mCurrentNetwork.equals("<General Gnutella Network>")) {
            int n = DEFAULT_STARTUP_HOSTS.length - 1;
            while (n >= 0) {
                this.addCaughtHost(DEFAULT_STARTUP_HOSTS[n], 2);
                --n;
            }
        }
    }

    private void copyDefaultAutoConnectHosts() {
        int n = 0;
        while (n < DEFAULT_STARTUP_HOSTS.length) {
            this.addAutoConnectHost(DEFAULT_STARTUP_HOSTS[n]);
            ++n;
        }
    }

    private void loadHostsFromFile() {
        Logger.logMessage(Logger.FINE, (short)16, "Loading hosts file.");
        try {
            String string;
            Object object;
            BufferedReader bufferedReader;
            File file = ServiceManager.getHostsFile();
            if (file.exists()) {
                bufferedReader = new BufferedReader(new FileReader(file));
            } else {
                Logger.logMessage(Logger.FINE, (short)16, "Load default hosts file.");
                object = ClassLoader.getSystemResourceAsStream("phex/resources/phex.hosts");
                if (object != null) {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
                } else {
                    Logger.logMessage(Logger.FINE, (short)16, "Default Phex Hosts file not found.");
                    return;
                }
            }
            object = PhexSecurityManager.getInstance();
            int n = 2;
            block5: while ((string = bufferedReader.readLine()) != null) {
                byte[] byArray;
                if (string.startsWith("#")) continue;
                if (this.caughtHosts.isFull(n)) {
                    if (n == 0) break;
                    --n;
                }
                if ((byArray = HostAddress.parseIP(string)) == null) continue;
                byte by = ((PhexSecurityManager)object).controlHostIPAccess(byArray);
                switch (by) {
                    case 2: 
                    case 3: {
                        break;
                    }
                    default: {
                        int n2 = HostAddress.parsePort(string);
                        if (n2 == -1) continue block5;
                        HostAddress hostAddress = new HostAddress(byArray, n2);
                        this.addCaughtHost(hostAddress, n);
                    }
                }
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Logger.logWarning(iOException);
        }
    }

    private void loadAutoConnectHostsFromFile() {
        try {
            String string;
            File file = Environment.getInstance().getPhexConfigFile("autoconnecthosts.cfg");
            if (!file.exists()) {
                this.copyDefaultAutoConnectHosts();
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("#")) continue;
                try {
                    this.insertAutoConnectHost(new HostAddress(string), this.autoConnectHosts.size());
                }
                catch (MalformedHostAddressException malformedHostAddressException) {
                    // empty catch block
                }
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
        }
    }

    private synchronized void saveCaughtHosts() {
        try {
            File file = ServiceManager.getHostsFile();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            Iterator iterator = this.caughtHosts.iterator();
            while (iterator.hasNext()) {
                HostAddress hostAddress = (HostAddress)iterator.next();
                if (this.isInStartupHosts(hostAddress)) continue;
                bufferedWriter.write(hostAddress.getFullHostName());
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
        }
    }

    private synchronized void saveAutoConnectHosts() {
        try {
            File file = Environment.getInstance().getPhexConfigFile("autoconnecthosts.cfg");
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            int n = 0;
            while (n < this.autoConnectHosts.size()) {
                HostAddress hostAddress = (HostAddress)this.autoConnectHosts.get(n);
                bufferedWriter.write(hostAddress.getFullHostName());
                bufferedWriter.newLine();
                ++n;
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
        }
    }

    private boolean isInStartupHosts(HostAddress hostAddress) {
        int n = 0;
        while (n < DEFAULT_STARTUP_HOSTS.length) {
            if (hostAddress.equals(DEFAULT_STARTUP_HOSTS[n])) {
                return true;
            }
            ++n;
        }
        int n2 = this.autoConnectHosts.size();
        int n3 = 0;
        while (n3 < n2) {
            if (hostAddress.equals(this.autoConnectHosts.get(n3))) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public void addCaughtHostsChangeListener(CaughtHostsChangeListener caughtHostsChangeListener) {
        this.listenerList.add(caughtHostsChangeListener);
    }

    public void removeCaughtHostsChangeListener(CaughtHostsChangeListener caughtHostsChangeListener) {
        this.listenerList.remove(caughtHostsChangeListener);
    }

    private void fireCaughtHostsChanged() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = CaughtHostsContainer.this.listenerList.toArray();
                int n = objectArray.length - 1;
                while (n >= 0) {
                    CaughtHostsChangeListener caughtHostsChangeListener = (CaughtHostsChangeListener)objectArray[n];
                    caughtHostsChangeListener.caughtHostsChanged();
                    --n;
                }
            }
        });
    }

    private void fireAutoConnectHostAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = CaughtHostsContainer.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    CaughtHostsChangeListener caughtHostsChangeListener = (CaughtHostsChangeListener)objectArray[n2];
                    caughtHostsChangeListener.autoConnectHostAdded(n);
                    --n2;
                }
            }
        });
    }

    private void fireAutoConnectHostRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = CaughtHostsContainer.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    CaughtHostsChangeListener caughtHostsChangeListener = (CaughtHostsChangeListener)objectArray[n2];
                    caughtHostsChangeListener.autoConnectHostRemoved(n);
                    --n2;
                }
            }
        });
    }
}

