/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.IOException;
import phex.host.HostManager;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.utils.HexConverter;
import phex.utils.IOUtil;
import phex.utils.IPUtils;
import phex.utils.Logger;

public class MsgPong
extends Message {
    private byte[] body;
    private MsgHeader header;
    private int port;
    private byte[] ip;
    private int fileCount;
    private int fileSizeInKB;

    public MsgPong(MsgHeader msgHeader, byte[] byArray) {
        this.header = msgHeader;
        this.header.setPayloadType((byte)1);
        this.body = byArray;
        this.header.setDataLen(this.body.length);
        this.parseBody();
    }

    public MsgPong(MsgHeader msgHeader, byte[] byArray, int n, int n2, int n3) {
        this.header = msgHeader;
        msgHeader.setPayloadType((byte)1);
        if (byArray.length != 4) {
            throw new IllegalArgumentException("Can't accept ip that is not 4 bytes in length: " + byArray.length);
        }
        this.ip = byArray;
        this.port = n;
        this.fileCount = n2;
        boolean bl = HostManager.getInstance().isUltrapeer();
        this.fileSizeInKB = bl ? MsgPong.createUltrapeerMarking(n3) : n3;
        this.buildBody();
        msgHeader.setDataLen(this.body.length);
    }

    public MsgHeader getHeader() {
        return this.header;
    }

    public int getPort() {
        return this.port;
    }

    public byte[] getIP() {
        return this.ip;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public int getFileSizeInKB() {
        return this.fileSizeInKB;
    }

    public int getSize() {
        return this.header.getSize() + this.header.getDataLen();
    }

    public int serialize(byte[] byArray, int n) throws IOException {
        n = this.header.serialize(byArray, n);
        try {
            System.arraycopy(this.body, 0, byArray, n, this.header.getDataLen());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Logger.logError((short)16, this.body.length + "  " + n + "  " + this.header.getDataLen() + "  " + "\n" + new String(this.body) + "\n" + new String(byArray) + "\n----");
            Logger.logError(arrayIndexOutOfBoundsException);
        }
        return n + this.header.getDataLen();
    }

    public String getDebugString() {
        return "Pong[ IP=" + IPUtils.ip2string(this.ip) + ", Port=" + this.port + ", FileCount=" + this.fileCount + ", FileSize=" + this.fileSizeInKB + ", HEX=[" + HexConverter.toHexString(this.body) + "] ]";
    }

    private void buildBody() {
        this.body = new byte[14];
        IOUtil.serializeShortLE((short)this.port, this.body, 0);
        System.arraycopy(this.ip, 0, this.body, 2, 4);
        IOUtil.serializeIntLE(this.fileCount, this.body, 6);
        IOUtil.serializeIntLE(this.fileSizeInKB, this.body, 10);
    }

    private void parseBody() {
        this.port = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(this.body, 0));
        this.ip = new byte[4];
        this.ip[0] = this.body[2];
        this.ip[1] = this.body[3];
        this.ip[2] = this.body[4];
        this.ip[3] = this.body[5];
        this.fileCount = IOUtil.deserializeIntLE(this.body, 6);
        this.fileSizeInKB = IOUtil.deserializeIntLE(this.body, 10);
    }

    public boolean isUltrapeerMarked() {
        if (this.fileSizeInKB < 8) {
            return false;
        }
        return (this.fileSizeInKB & this.fileSizeInKB - 1) == 0;
    }

    private static int createUltrapeerMarking(int n) {
        if (n < 12) {
            return 8;
        }
        int n2 = IOUtil.determineBitCount(n);
        int n3 = (int)Math.pow(2.0, n2);
        int n4 = n3 - n3 / 4;
        if (n < n4) {
            n3 = (int)Math.pow(2.0, n2 - 1);
        }
        return n3;
    }
}

