/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import phex.common.ServiceManager;
import phex.connection.NetworkManager;
import phex.host.HostAddress;
import phex.msg.GGEPBlock;
import phex.msg.GUID;
import phex.msg.InvalidGGEPBlockException;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.msg.MsgResRecord;
import phex.query.QueryConstants;
import phex.upload.UploadManager;
import phex.utils.HexConverter;
import phex.utils.IOUtil;
import phex.utils.Logger;

public class MsgQueryResponse
extends Message
implements QueryConstants {
    private static final boolean INCLUDE_QHD = true;
    private static final byte PUSH_NEEDED_MASK = 1;
    private static final byte SERVER_BUSY_MASK = 4;
    private static final byte HAS_UPLOADED_MASK = 8;
    private static final byte UPLOAD_SPEED_MASK = 16;
    private static final byte GGEP_MASK = 32;
    private static final byte CHAT_SUPPORTED_MASK = 1;
    private MsgHeader mHeader;
    private byte[] body;
    private int mRemoteHostSpeed;
    private MsgResRecord[] mRecords;
    private HostAddress hostAddress;
    private GUID remoteClientID;
    private String vendorCode;
    private short pushNeededFlag;
    private short serverBusyFlag;
    private short hasUploadedFlag;
    private short uploadSpeedFlag;
    private boolean isChatSupported;
    private boolean isBrowseHostSupported;
    private boolean isParsed;

    public MsgQueryResponse(MsgHeader msgHeader, GUID gUID, HostAddress hostAddress, int n, MsgResRecord[] msgResRecordArray) throws UnknownHostException {
        boolean bl;
        if (msgResRecordArray.length > 255) {
            throw new IllegalArgumentException("A maximum of 255 records can be associated with a single response: " + msgResRecordArray.length);
        }
        this.mHeader = msgHeader;
        this.mHeader.setPayloadType((byte)-127);
        this.remoteClientID = gUID;
        this.hostAddress = hostAddress;
        this.mRemoteHostSpeed = n;
        this.mRecords = msgResRecordArray;
        if (!NetworkManager.getInstance().getIncomingListener().hasConnectedIncoming() || ServiceManager.sCfg.isBehindFirewall) {
            bl = true;
            this.pushNeededFlag = 1;
        } else {
            bl = false;
            this.pushNeededFlag = 0;
        }
        boolean bl2 = UploadManager.getInstance().isHostBusy();
        this.buildBody(bl, bl2);
        this.mHeader.setDataLen(this.body.length);
        this.isParsed = true;
    }

    public MsgQueryResponse(MsgHeader msgHeader, byte[] byArray) {
        this.mHeader = msgHeader;
        this.mHeader.setPayloadType((byte)-127);
        this.body = byArray;
        msgHeader.setDataLen(this.body.length);
        this.isParsed = false;
    }

    private void buildBody(boolean bl, boolean bl2) throws UnknownHostException {
        int n = this.calculateBodySize();
        this.body = new byte[n];
        int n2 = this.mRecords.length;
        this.body[0] = (byte)n2;
        IOUtil.serializeShortLE((short)this.hostAddress.getPort(), this.body, 1);
        byte[] byArray = this.hostAddress.getHostIP();
        this.body[3] = byArray[0];
        this.body[4] = byArray[1];
        this.body[5] = byArray[2];
        this.body[6] = byArray[3];
        IOUtil.serializeIntLE(this.mRemoteHostSpeed, this.body, 7);
        int n3 = 11;
        int n4 = 0;
        while (n4 < n2) {
            n3 = this.mRecords[n4].serialize(this.body, n3);
            ++n4;
        }
        this.body[n3++] = 80;
        this.body[n3++] = 72;
        this.body[n3++] = 69;
        this.body[n3++] = 88;
        this.body[n3++] = 2;
        int n5 = 0;
        if (bl) {
            n5 = 1;
        }
        int n6 = 0;
        if (bl2) {
            n6 = 4;
        }
        int n7 = 0;
        if (ServiceManager.sCfg.mShareBrowseDir) {
            n7 = 32;
        }
        this.body[n3++] = (byte)(n5 | 4 | 0 | 0x10 | 0x20);
        this.body[n3++] = (byte)(1 | n6 | 0 | 0 | n7);
        this.body[n3++] = ServiceManager.sCfg.isChatEnabled ? (byte)1 : 0;
        if (ServiceManager.sCfg.mShareBrowseDir) {
            byte[] byArray2 = GGEPBlock.getBrowseHostGGEPBlock();
            System.arraycopy(byArray2, 0, this.body, n3, byArray2.length);
            n3 += byArray2.length;
        }
        n3 = this.remoteClientID.serialize(this.body, n3);
    }

    public MsgHeader getHeader() {
        return this.mHeader;
    }

    public short getRecordCount() {
        return (short)IOUtil.unsignedByte2int(this.body[0]);
    }

    public byte[] getHostIP() {
        byte[] byArray = new byte[]{this.body[3], this.body[4], this.body[5], this.body[6]};
        return byArray;
    }

    public HostAddress getHostAddress() {
        if (this.hostAddress == null) {
            short s = IOUtil.deserializeShortLE(this.body, 1);
            this.hostAddress = new HostAddress(this.getHostIP(), (int)s);
        }
        return this.hostAddress;
    }

    public int getRemoteHostSpeed() {
        this.parseBody();
        return this.mRemoteHostSpeed;
    }

    public String getVendorCode() {
        this.parseBody();
        return this.vendorCode;
    }

    public short getPushNeededFlag() {
        this.parseBody();
        return this.pushNeededFlag;
    }

    public short getServerBusyFlag() {
        this.parseBody();
        return this.serverBusyFlag;
    }

    public short getHasUploadedFlag() {
        this.parseBody();
        return this.hasUploadedFlag;
    }

    public short getUploadSpeedFlag() {
        this.parseBody();
        return this.uploadSpeedFlag;
    }

    public boolean isChatSupported() {
        this.parseBody();
        return this.isChatSupported;
    }

    public boolean isBrowseHostSupported() {
        this.parseBody();
        return this.isBrowseHostSupported;
    }

    public GUID getRemoteClientID() {
        if (this.remoteClientID == null) {
            this.parseRemoteClientID();
        }
        return this.remoteClientID;
    }

    public MsgResRecord getMsgRecord(int n) {
        this.parseBody();
        return this.mRecords[n];
    }

    public int getSize() {
        return this.mHeader.getSize() + this.mHeader.getDataLen();
    }

    private int calculateBodySize() {
        int n = 11;
        n += this.getRecordLength();
        n = n + 4 + 1 + 2 + 1;
        if (ServiceManager.sCfg.mShareBrowseDir) {
            n += GGEPBlock.getBrowseHostGGEPBlock().length;
        }
        return n += this.remoteClientID.getSize();
    }

    private int getRecordLength() {
        int n = 0;
        int n2 = this.mRecords.length;
        int n3 = 0;
        while (n3 < n2) {
            MsgResRecord msgResRecord = this.mRecords[n3];
            n += msgResRecord.getSize();
            ++n3;
        }
        return n;
    }

    public void copy(MsgQueryResponse msgQueryResponse) {
        this.mHeader.copy(msgQueryResponse.getHeader());
        this.hostAddress = msgQueryResponse.hostAddress;
        this.mRemoteHostSpeed = msgQueryResponse.mRemoteHostSpeed;
        this.remoteClientID = msgQueryResponse.remoteClientID;
        int n = msgQueryResponse.mRecords.length;
        this.mRecords = new MsgResRecord[n];
        int n2 = 0;
        while (n2 < n) {
            MsgResRecord msgResRecord = new MsgResRecord();
            msgResRecord.copy(msgQueryResponse.mRecords[n2]);
            this.mRecords[n2] = msgResRecord;
            ++n2;
        }
        this.body = msgQueryResponse.body;
    }

    public int serialize(byte[] byArray, int n) throws IOException {
        n = this.mHeader.serialize(byArray, n);
        try {
            System.arraycopy(this.body, 0, byArray, n, this.mHeader.getDataLen());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Logger.logError((short)16, this.body.length + "  " + n + "  " + this.mHeader.getDataLen() + "  " + this.calculateBodySize() + "\n" + new String(this.body) + "\n" + new String(byArray) + "\n----");
            Logger.logError(arrayIndexOutOfBoundsException);
        }
        return n;
    }

    private void parseBody() {
        int n;
        if (this.isParsed) {
            return;
        }
        int n2 = 0;
        int n3 = (n = this.body[n2++]) < 0 ? 256 + n : n;
        n2 += 2;
        n2 += 4;
        try {
            Object object;
            int n4 = IOUtil.deserializeIntLE(this.body, n2);
            if (n4 < 0) {
                n4 = Integer.MAX_VALUE;
            }
            this.mRemoteHostSpeed = n4;
            n2 += 4;
            this.mRecords = new MsgResRecord[n3];
            int n5 = 0;
            while (n5 < n3) {
                object = new MsgResRecord();
                n2 = ((MsgResRecord)object).deserialize(this.body, n2);
                this.mRecords[n5] = object;
                ++n5;
            }
            this.pushNeededFlag = (short)-1;
            this.serverBusyFlag = (short)-1;
            this.hasUploadedFlag = (short)-1;
            this.uploadSpeedFlag = (short)-1;
            this.isBrowseHostSupported = false;
            if (n2 <= this.mHeader.getDataLen() - 16 - 4 - 2) {
                byte by;
                int n6;
                this.vendorCode = new String(this.body, n2, 4, "ISO-8859-1");
                if (!this.isVendorCodeValid(this.vendorCode)) {
                    object = HexConverter.toHexString(this.body, n2, 4);
                    this.mHeader.getFromHost().log(Logger.WARNING, "Illegal QHD vendor code found: " + this.vendorCode + " (" + (String)object + "). Body: " + HexConverter.toHexString(this.body));
                    this.vendorCode = object;
                }
                int n7 = IOUtil.unsignedByte2int(this.body[n2 += 4]);
                ++n2;
                if (n7 > 1) {
                    n6 = this.body[n2];
                    by = this.body[n2 + 1];
                    if ((by & 1) != 0) {
                        this.pushNeededFlag = (n6 & 1) != 0 ? (short)1 : 0;
                    }
                    if ((n6 & 4) != 0) {
                        this.serverBusyFlag = (by & 4) != 0 ? (short)1 : 0;
                    }
                    if ((n6 & 8) != 0) {
                        this.hasUploadedFlag = (by & 8) != 0 ? (short)1 : 0;
                    }
                    if ((n6 & 0x10) != 0) {
                        this.uploadSpeedFlag = (by & 0x10) != 0 ? (short)1 : 0;
                    }
                    if ((n6 & 0x20) != 0 && (by & 0x20) != 0) {
                        int n8 = n2 + 2;
                        while (n8 < this.body.length) {
                            if (this.body[n8] == -61) break;
                            ++n8;
                        }
                        GGEPBlock[] gGEPBlockArray = null;
                        try {
                            gGEPBlockArray = GGEPBlock.parseGGEPBlocks(this.body, n8);
                            this.isBrowseHostSupported = GGEPBlock.isExtensionHeaderInBlocks(gGEPBlockArray, "BH");
                        }
                        catch (InvalidGGEPBlockException invalidGGEPBlockException) {
                            Logger.logMessage(Logger.FINE, (short)16, invalidGGEPBlockException);
                        }
                    }
                }
                if ((n6 = this.body.length - (n2 += n7) - 16) > 0 && (this.vendorCode.equals("LIME") || this.vendorCode.equals("RAZA") || this.vendorCode.equals("PHEX"))) {
                    by = this.body[n2];
                    this.isChatSupported = (by & 1) != 0;
                }
            }
            this.parseRemoteClientID();
            this.isParsed = true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
    }

    private void parseRemoteClientID() {
        if (this.remoteClientID == null) {
            this.remoteClientID = new GUID();
        }
        this.remoteClientID.deserialize(this.body, this.mHeader.getDataLen() - 16);
    }

    private boolean isVendorCodeValid(String string) {
        if (string.length() != 4) {
            return false;
        }
        int n = 0;
        while (n < 4) {
            if (!Character.isLetterOrDigit(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

