/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import phex.common.Cfg;
import phex.common.ServiceManager;
import phex.event.QueryHistoryChangeListener;
import phex.msg.MsgQuery;
import phex.utils.CircularQueue;
import phex.utils.Logger;

public class QueryHistoryMonitor {
    private Cfg configuration = ServiceManager.sCfg;
    private CircularQueue historyQueue;
    private BufferedWriter fileWriter;
    private QueryHistoryChangeListener changeListener;

    public QueryHistoryMonitor() {
        this.historyQueue = new CircularQueue(this.configuration.searchHistoryLength, this.configuration.searchHistoryLength);
        this.updateFileMonitoring();
    }

    public void shutdown() {
        if (this.fileWriter != null) {
            try {
                this.fileWriter.close();
                Logger.logMessage(Logger.INFO, (short)8, "End QueryMonitoring to file.");
            }
            catch (IOException iOException) {
                Logger.logError(iOException);
            }
            this.fileWriter = null;
        }
    }

    private void updateFileMonitoring() {
        if (this.configuration.monitorSearchHistory && this.configuration.searchMonitorFile.length() > 0) {
            try {
                File file = new File(this.configuration.searchMonitorFile);
                File file2 = file.getParentFile();
                if (file2 != null) {
                    file2.mkdirs();
                }
                file.createNewFile();
                this.fileWriter = new BufferedWriter(new FileWriter(file.getAbsolutePath(), true));
                Logger.logMessage(Logger.INFO, (short)8, "Start QueryMonitoring to " + file.getAbsolutePath());
            }
            catch (IOException iOException) {
                Logger.logError(iOException);
            }
        } else {
            this.shutdown();
        }
    }

    public void setHistoryMonitored(boolean bl) {
        this.configuration.monitorSearchHistory = bl;
        this.updateFileMonitoring();
        this.configuration.save();
    }

    public boolean isHistoryMonitored() {
        return this.configuration.monitorSearchHistory;
    }

    public synchronized void setMaxHistroySize(int n) {
        if (n == this.historyQueue.getCapacity()) {
            return;
        }
        this.historyQueue = new CircularQueue(n, n);
        this.configuration.searchHistoryLength = n;
        this.configuration.save();
    }

    public synchronized int getMaxHistorySize() {
        return this.historyQueue.getCapacity();
    }

    public synchronized int getHistorySize() {
        return this.historyQueue.getSize();
    }

    public synchronized MsgQuery getSearchQueryAt(int n) {
        return (MsgQuery)this.historyQueue.get(n);
    }

    public synchronized void addSearchQuery(MsgQuery msgQuery) {
        block4: {
            if (!this.configuration.monitorSearchHistory) break block4;
            if (msgQuery.getSearchString().length() > 0) {
                this.historyQueue.addToHead(msgQuery);
                this.fireQueryHistoryChanged();
            }
            if (this.fileWriter != null) {
                try {
                    this.fileWriter.write(msgQuery.getSearchString());
                    this.fileWriter.newLine();
                }
                catch (IOException iOException) {
                    Logger.logWarning(iOException);
                }
            }
        }
    }

    public void setQueryHistoryChangeListener(QueryHistoryChangeListener queryHistoryChangeListener) {
        if (this.changeListener != null) {
            throw new RuntimeException("CaughtHostChangedListener already used!!");
        }
        this.changeListener = queryHistoryChangeListener;
    }

    private void fireQueryHistoryChanged() {
        this.changeListener.queryHistoryChanged();
    }
}

