/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

public class ResearchServiceConfig {
    private static final long DEFAULT_RESEARCH_TIMEOUT = 120000L;
    private static final long DEFAULT_RESEARCH_INTERVAL_MILLIS = 600000L;
    private static final long DEFAULT_RESEARCH_TIME_PENALTY = 180000L;
    private static final long DEFAULT_MAX_RESEARCH_INTERVAL_MILLIS = 0x6DDD00L;
    private static final int DEFAULT_CANDIDATE_INTERVAL_THRESHOLD = 2;
    private long maxResearchIntervalMillis;
    private long researchIntervalMillis;
    private long researchTimeout;
    private int candidatesIntervalThreshold;
    private long researchTimePenalty;
    private boolean isResearchEnabled;

    public ResearchServiceConfig() {
        this.ensureDefaults();
        this.isResearchEnabled = false;
    }

    public long getResearchIntervalMillis() {
        return this.researchIntervalMillis;
    }

    public long getMaxResearchIntervalMillis() {
        return this.maxResearchIntervalMillis;
    }

    public int getCandidatesIntervalThreshold() {
        return this.candidatesIntervalThreshold;
    }

    public long getResearchTimePenalty() {
        return this.researchTimePenalty;
    }

    public long getResearchTimeout() {
        return this.researchTimeout;
    }

    public boolean isResearchEnabled() {
        return this.isResearchEnabled;
    }

    private void ensureDefaults() {
        if (this.maxResearchIntervalMillis == 0L) {
            this.maxResearchIntervalMillis = 0x6DDD00L;
        }
        if (this.researchIntervalMillis == 0L) {
            this.researchIntervalMillis = 600000L;
        }
        if (this.candidatesIntervalThreshold == 0) {
            this.candidatesIntervalThreshold = 2;
        }
        if (this.researchTimeout == 0L) {
            this.researchTimeout = 120000L;
        }
        if (this.researchTimePenalty == 0L) {
            this.researchTimePenalty = 180000L;
        }
    }
}

