/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import phex.common.Cfg;
import phex.common.URN;
import phex.download.IDownloadFile;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.event.AsynchronousDispatcher;
import phex.event.SearchChangeEvent;
import phex.event.SearchChangeListener;
import phex.query.BackgroundSearchContainer;
import phex.query.QueryManager;
import phex.query.Search;

public class ResearchSetting {
    private long lastResearchStartTime;
    private int noNewResultsCount;
    private int totalResearchCount;
    private String searchTerm;
    private Search search;
    private boolean hasNewSearchResults;
    private IDownloadFile downloadFile;
    private ResearchChangeListener researchChangeListener;

    public ResearchSetting(IDownloadFile iDownloadFile) {
        this.downloadFile = iDownloadFile;
        this.researchChangeListener = new ResearchChangeListener();
    }

    public long getLastResearchStartTime() {
        return this.lastResearchStartTime;
    }

    public void setLastResearchStartTime(long l) {
        this.lastResearchStartTime = l;
    }

    public int getNoNewResultsCount() {
        return this.noNewResultsCount;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public void setSearchTerm(String string) {
        this.searchTerm = string;
    }

    public String getSHA1() {
        URN uRN = this.downloadFile.getFileURN();
        if (uRN == null || !uRN.isSha1Nid()) {
            return "";
        }
        return uRN.getNamespaceSpecificString();
    }

    public void startSearch(long l) {
        long l2;
        if (this.search != null && this.search.isSearching()) {
            return;
        }
        if (this.searchTerm.length() < Cfg.MIN_SEARCH_TERM_LENGTH) {
            return;
        }
        this.hasNewSearchResults = false;
        BackgroundSearchContainer backgroundSearchContainer = QueryManager.getInstance().getBackgroundSearchContainer();
        this.search = backgroundSearchContainer.createSearch(this.searchTerm, this.downloadFile.getFileURN(), this.downloadFile.getTotalDataSize(), this.downloadFile.getTotalDataSize(), l);
        this.search.addSearchChangeListener(this.researchChangeListener);
        ++this.totalResearchCount;
        this.lastResearchStartTime = l2 = System.currentTimeMillis();
    }

    public int getTotalResearchCount() {
        return this.totalResearchCount;
    }

    public void stopSearch() {
        if (this.search == null || !this.search.isSearching()) {
            return;
        }
        this.search.stopSearching();
    }

    public int getSearchHitCount() {
        return this.search.getQueryHitCount();
    }

    public boolean isSearchRunning() {
        if (this.search == null) {
            return false;
        }
        return this.search.isSearching();
    }

    static /* synthetic */ boolean access$100(ResearchSetting researchSetting) {
        return researchSetting.hasNewSearchResults;
    }

    static /* synthetic */ int access$208(ResearchSetting researchSetting) {
        return researchSetting.noNewResultsCount++;
    }

    static /* synthetic */ int access$202(ResearchSetting researchSetting, int n) {
        researchSetting.noNewResultsCount = n;
        return researchSetting.noNewResultsCount;
    }

    static /* synthetic */ IDownloadFile access$300(ResearchSetting researchSetting) {
        return researchSetting.downloadFile;
    }

    static /* synthetic */ boolean access$102(ResearchSetting researchSetting, boolean bl) {
        researchSetting.hasNewSearchResults = bl;
        return researchSetting.hasNewSearchResults;
    }

    public class ResearchChangeListener
    implements SearchChangeListener {
        public void searchChanged(SearchChangeEvent searchChangeEvent) {
            AsynchronousDispatcher.invokeLater(new Runnable(this, searchChangeEvent){
                private final /* synthetic */ SearchChangeEvent val$event;
                private final /* synthetic */ ResearchChangeListener this$1;
                {
                    this.this$1 = researchChangeListener;
                    this.val$event = searchChangeEvent;
                }

                public void run() {
                    if (this.val$event.getType() == 3) {
                        if (!ResearchSetting.access$100(ResearchChangeListener.access$000(this.this$1))) {
                            ResearchSetting.access$208(ResearchChangeListener.access$000(this.this$1));
                        } else {
                            ResearchSetting.access$202(ResearchChangeListener.access$000(this.this$1), 0);
                        }
                    }
                    if (this.val$event.getType() != 1) {
                        SwarmingManager.getInstance().fireDownloadFileChanged((SWDownloadFile)ResearchSetting.access$300(ResearchChangeListener.access$000(this.this$1)));
                        return;
                    }
                    Search search = (Search)this.val$event.getSource();
                    int n = this.val$event.getStartIndex();
                    int n2 = this.val$event.getEndIndex();
                    int n3 = n;
                    while (n3 < n2) {
                        RemoteFile remoteFile = search.getQueryHit(n3);
                        boolean bl = ResearchSetting.access$300(ResearchChangeListener.access$000(this.this$1)).addDownloadCandidate(remoteFile);
                        if (bl) {
                            ResearchSetting.access$102(ResearchChangeListener.access$000(this.this$1), true);
                        }
                        ++n3;
                    }
                    SwarmingManager.getInstance().fireDownloadFileChanged((SWDownloadFile)ResearchSetting.access$300(ResearchChangeListener.access$000(this.this$1)));
                }
            });
        }

        static /* synthetic */ ResearchSetting access$000(ResearchChangeListener researchChangeListener) {
            return researchChangeListener.ResearchSetting.this;
        }
    }
}

